/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.monitor.model.Pose6d;
import com.ur.move.ControllerSocketSender;
import com.ur.move.JointPositionMessageProvider;
import com.ur.move.OKCancelConfirmationListener;
import com.ur.move.PositionReference;
import com.ur.move.internal.ControllerRequirement;
import com.ur.move.poseeditor.PoseEditorPanel;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.move.poseeditor.RobotView3DPanel;
import com.ur.move.poseeditor.RobotView3DPanelImpl;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.move.viewfacade.MoveCameraView;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentationFactory;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.viewfacade.lang.IHideousJTextTranslator;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputOperation;
import com.ur.swing.LongPressListener;
import com.ur.swing.SwingLanguagePack;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogOnScreen;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.help.HelpComponentWrapper;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.vecmath.Vector3d;

@Singleton
public class PoseEditorPanelImpl
extends PoseEditorPanel
implements RobotStateListener,
OKCancelConfirmationListener {
    private static int maxCountBetweenAccelerations = 3;
    private static int acceleration = 2;
    private static int countBetweenAcceleration = 0;
    private static double jointIncreaseDecrease = 0.005;
    private static double positionIncreaseDecrease = 0.01;
    private static double minRotationIncreaseDecrease = 8.726646259971648E-4;
    private static double maxRotationIncreaseDecrease = 0.04363323129985824;
    private static double rotationIncreaseDecrease = minRotationIncreaseDecrease;
    private final NumberField[] jointValueTextFields = new NumberField[6];
    private final JTextField[] coordinateValueTextFields = new JTextField[6];
    private final List<BindingRegistration> validators = new ArrayList<BindingRegistration>();
    private final HelpIdAssigner helpIdAssigner;
    private final ProgramUiControl programUiControl;
    private final ViewContext viewContext;
    private final IHideousJTextTranslator jTextTranslator;
    private final ErrorDialogCreator errorDialogCreator;
    private final MessageDialogCreator messageDialogCreator;
    private final DialogOnScreen dialogOnScreen;
    private final ControllerRequirement controllerRequirement;
    private RobotView3DPanelImpl robotPanel;
    private String unreachableToolPoseErrorMessage;
    private boolean updating;
    private JointPositionVector lastFoundSolution = null;
    private RobotState lastRobotState = null;
    private boolean displayingValidPose = true;
    private boolean isOkOrCancelButtonPressed = false;
    private boolean isInitialized = false;
    private RotationRepresentation rotationRepresentation = null;
    private Pose6d toolFeaturePose = null;
    private PoseRequest poseRequest = null;
    private boolean performUpdateOfTextField = false;
    private JLabel positionHeader;
    private JButton addToJoint1Button;
    private JButton addToJoint2Button;
    private JButton addToJoint3Button;
    private JButton addToJoint4Button;
    private JButton addToJoint5Button;
    private JButton addToJoint6Button;
    private JPanel featurePanel;
    private JComboBox geomFeaturesComboBox;
    private NumberField joint1ValueTextField;
    private NumberField joint2ValueTextField;
    private NumberField joint3ValueTextField;
    private NumberField joint4ValueTextField;
    private NumberField joint5ValueTextField;
    private NumberField joint6ValueTextField;
    private JComboBox rotationTypeComboBox;
    private JLabel safetyWarningMessageLabel;
    private JButton subtractFromJoint1Button;
    private JButton subtractFromJoint2Button;
    private JButton subtractFromJoint3Button;
    private JButton subtractFromJoint4Button;
    private JButton subtractFromJoint5Button;
    private JButton subtractFromJoint6Button;
    private JButton subtractFromToolRZButton;
    private JLabel toolErrorMessageLabel;
    private JPanel toolPositionPanel;
    private NumberField toolRXValueTextField;
    private NumberField toolRYValueTextField;
    private NumberField toolRZValueTextField;
    private NumberField toolXValueTextField;
    private NumberField toolYValueTextField;
    private NumberField toolZValueTextField;
    private TextResource textResource;
    private ControllerInterface controllerInterface;

    @Inject
    public PoseEditorPanelImpl(ElementsVisualizerAggregator elementsVisualizerAggregator, Set<JointPositionMessageProvider> messageProvider, JointPositionRangeProvider jointPositionRangeProvider, JointConfigurationSettings jointConfigurationSettings, FeaturesLookup featureLookup, ControllerRequirement controllerRequirement, RobotCanvas3DFactory robotCanvas3DFactory, HelpIdAssigner helpIdAssigner, ProgramUiControl programUiControl, ViewContext viewContext, ErrorDialogCreator errorDialogCreator, MessageDialogCreator messageDialogCreator, DialogOnScreen dialogOnScreen, IHideousJTextTranslator jTextTranslator, ControllerInterface controllerInterface, InverseKinematicProviderExt inverseKinematicProviderExt) {
        super(messageProvider, jointPositionRangeProvider, jointConfigurationSettings, featureLookup);
        this.controllerRequirement = controllerRequirement;
        this.helpIdAssigner = helpIdAssigner;
        this.programUiControl = programUiControl;
        this.viewContext = viewContext;
        this.errorDialogCreator = errorDialogCreator;
        this.messageDialogCreator = messageDialogCreator;
        this.dialogOnScreen = dialogOnScreen;
        this.jTextTranslator = jTextTranslator;
        this.controllerInterface = controllerInterface;
        try {
            this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
            this.robotPanel = new RobotView3DPanelImpl(elementsVisualizerAggregator, this, robotCanvas3DFactory, viewContext, controllerInterface, inverseKinematicProviderExt);
            this.initComponents();
            this.addJComponentsToArrays();
            this.initializeRotationTypeComboBox();
            this.translateGUILabels();
            this.setupKeyboardShortcuts();
            this.robotPanel.setActive(false);
            this.setComponentNames();
            this.initHelpIds();
        }
        catch (Exception e) {
            Log.error((String)"Ignoring for tests");
        }
    }

    private void setComponentNames() {
        this.jointValueTextFields[0].setName("joint1InputField.PoseEditorPanel");
        this.jointValueTextFields[1].setName("joint2InputField.PoseEditorPanel");
        this.jointValueTextFields[2].setName("joint3InputField.PoseEditorPanel");
        this.jointValueTextFields[3].setName("joint4InputField.PoseEditorPanel");
        this.jointValueTextFields[4].setName("joint5InputField.PoseEditorPanel");
        this.jointValueTextFields[5].setName("joint6InputField.PoseEditorPanel");
        this.coordinateValueTextFields[0].setName("toolXInputField.PoseEditorPanel");
        this.coordinateValueTextFields[1].setName("toolYInputField.PoseEditorPanel");
        this.coordinateValueTextFields[2].setName("toolZInputField.PoseEditorPanel");
        this.coordinateValueTextFields[3].setName("toolRXInputField.PoseEditorPanel");
        this.coordinateValueTextFields[4].setName("toolRYInputField.PoseEditorPanel");
        this.coordinateValueTextFields[5].setName("toolRZInputField.PoseEditorPanel");
        this.geomFeaturesComboBox.setName("featuresComboBox.PoseEditorPanel");
        this.rotationTypeComboBox.setName("rotationTypeComboBox.PoseEditorPanel");
    }

    private void addJComponentsToArrays() {
        this.jointValueTextFields[0] = this.joint1ValueTextField;
        this.jointValueTextFields[1] = this.joint2ValueTextField;
        this.jointValueTextFields[2] = this.joint3ValueTextField;
        this.jointValueTextFields[3] = this.joint4ValueTextField;
        this.jointValueTextFields[4] = this.joint5ValueTextField;
        this.jointValueTextFields[5] = this.joint6ValueTextField;
        this.setTextFieldProperties((JTextField[])this.jointValueTextFields);
        this.coordinateValueTextFields[0] = this.toolXValueTextField;
        this.coordinateValueTextFields[1] = this.toolYValueTextField;
        this.coordinateValueTextFields[2] = this.toolZValueTextField;
        this.coordinateValueTextFields[3] = this.toolRXValueTextField;
        this.coordinateValueTextFields[4] = this.toolRYValueTextField;
        this.coordinateValueTextFields[5] = this.toolRZValueTextField;
        this.setTextFieldProperties(this.coordinateValueTextFields);
    }

    private void setTextFieldProperties(JTextField[] textFields) {
        for (JTextField each : textFields) {
            each.setColumns(6);
            each.setFocusable(false);
            each.setRequestFocusEnabled(false);
            each.setHorizontalAlignment(4);
        }
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.geomFeaturesComboBox, "gui:poseeditor_feature_tool_position");
        this.helpIdAssigner.assignHelpId((JComponent)new HelpComponentWrapper((Component)this.toolPositionPanel, (Component)this.subtractFromToolRZButton), "gui:poseeditor_feature_tool_position");
        this.helpIdAssigner.assignHelpId((JComponent)new HelpComponentWrapper((Component)this.positionHeader, (Component)this.subtractFromJoint6Button), "gui:poseeditor_joint_positions");
        this.helpIdAssigner.assignHelpId((JComponent)this.robotPanel, "gui:poseeditor_3drobot");
    }

    private void updateSafetyWarningMessage() {
        String safetyWarningMessage = this.messageProvider.getWarningMessage(this.robotPanel.getCurrentJointPostionVector(), this.robotPanel.getCurrentToolBasePose());
        if (!this.safetyWarningMessageLabel.getText().equals(safetyWarningMessage)) {
            this.safetyWarningMessageLabel.setText(safetyWarningMessage);
        }
    }

    private static void setRotationIncreaseDecrease(RotationRepresentation.RotationType oldRotRep, RotationRepresentation.RotationType newRotRep) {
        if (oldRotRep == RotationRepresentation.RotationType.ANGLES_DEGREES || oldRotRep == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            maxRotationIncreaseDecrease *= Math.PI / 180;
            rotationIncreaseDecrease = minRotationIncreaseDecrease *= Math.PI / 180;
        }
        if (newRotRep == RotationRepresentation.RotationType.ANGLES_DEGREES || newRotRep == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            maxRotationIncreaseDecrease *= 57.29577951308232;
            rotationIncreaseDecrease = minRotationIncreaseDecrease *= 57.29577951308232;
        }
    }

    void handleNewToolFeaturePose(Pose6d newToolPose) {
        if (newToolPose.equals((Object)this.toolFeaturePose)) {
            return;
        }
        this.toolFeaturePose = newToolPose;
        this.rotationRepresentation.setValues(this.rotationRepresentation.computeRotation(this.toolFeaturePose.getRot()));
        this.setToolPositionValueTextFields(this.robotPanel.getCurrentToolFeaturePose(), false);
    }

    private ViewableGeomFeature initGeomFeatures(ViewableGeomFeature selectedJoggableGeomFeature) {
        DefaultComboBoxModel<GeomFeature> model = new DefaultComboBoxModel<GeomFeature>(this.featureLookup.getFeatureContainer().getJoggableGeomNodes());
        this.geomFeaturesComboBox.setModel(model);
        this.featureLookup.getFeatureContainer().getToolViewFeature().setOnline(false);
        if (selectedJoggableGeomFeature == null) {
            selectedJoggableGeomFeature = (ViewableGeomFeature)this.geomFeaturesComboBox.getItemAt(0);
        } else if (this.isGeomFeatureSetTo_Not_Joggable(selectedJoggableGeomFeature = this.updateReferenceToGeomFeature(selectedJoggableGeomFeature.getName()))) {
            selectedJoggableGeomFeature = (ViewableGeomFeature)this.geomFeaturesComboBox.getItemAt(0);
        }
        this.geomFeaturesComboBox.setSelectedItem(selectedJoggableGeomFeature);
        return selectedJoggableGeomFeature;
    }

    private ViewableGeomFeature updateReferenceToGeomFeature(String geomFeatureName) {
        return (ViewableGeomFeature)this.featureLookup.getFeatureContainer().getFeatureByName(geomFeatureName);
    }

    private boolean isGeomFeatureSetTo_Not_Joggable(ViewableGeomFeature geomFeature) {
        return geomFeature == null || !geomFeature.isJoggableEnabled();
    }

    private void setupKeyboardShortcuts() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "Escape");
        actionMap.put("Escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PoseEditorPanelImpl.this.cancelAction();
            }
        });
    }

    private void handlePositionIncreaseDecrease(PoseEditorPanel.ValueToEdit value, InputOperation operation) {
        if (positionIncreaseDecrease < 15.0) {
            if (++countBetweenAcceleration > maxCountBetweenAccelerations) {
                positionIncreaseDecrease *= (double)acceleration;
                countBetweenAcceleration = 0;
            }
        } else {
            positionIncreaseDecrease = 15.0;
        }
        this.updateToolPositionData(positionIncreaseDecrease, value, operation);
    }

    private void handleRotationIncreaseDecrease(PoseEditorPanel.ValueToEdit value, InputOperation operation) {
        if (rotationIncreaseDecrease < maxRotationIncreaseDecrease) {
            if (++countBetweenAcceleration > maxCountBetweenAccelerations) {
                rotationIncreaseDecrease *= (double)acceleration;
                countBetweenAcceleration = 0;
            }
        } else {
            rotationIncreaseDecrease = maxRotationIncreaseDecrease;
        }
        this.updateToolPositionData(rotationIncreaseDecrease, value, operation);
    }

    private void handleJointIncreaseDecrease(PoseEditorPanel.ValueToEdit value, InputOperation inputOperation) {
        if (jointIncreaseDecrease < 2.5) {
            if (++countBetweenAcceleration > maxCountBetweenAccelerations) {
                jointIncreaseDecrease *= (double)acceleration;
                countBetweenAcceleration = 0;
            }
        } else {
            jointIncreaseDecrease = 2.5;
        }
        this.updateJointPositionData(jointIncreaseDecrease, value, inputOperation, true);
    }

    @Override
    protected PoseRequest createPoseRequest(PositionReference positionReference) {
        PoseRequest request = this.createPoseRequest(positionReference.getActualJointPositionVector());
        request.setTcp(this.getTCPFromPositionReference(positionReference));
        request.setLastEditType(PoseRequest.LastEditType.POSE_EDIT);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Object o) {
        super.enter(o);
        this.updating = true;
        try {
            this.isOkOrCancelButtonPressed = false;
            this.robotPanel.setActive(true);
            this.robotPanel.showOkCancelPanel();
            this.robotPanel.robotCanvas3D.enter();
            if (o instanceof PoseRequest) {
                JointPositionVector initialJointPosition;
                this.isInitialized = false;
                this.poseRequest = (PoseRequest)o;
                this.programUiControl.stopProgram();
                ViewableGeomFeature joggableFeaturePoseRequest = this.poseRequest.getJoggableGeomFeature();
                ViewableGeomFeature selectedJoggableGeomFeature = joggableFeaturePoseRequest != null ? joggableFeaturePoseRequest : this.robotPanel.getJoggableGeomFeature();
                selectedJoggableGeomFeature = this.initGeomFeatures(selectedJoggableGeomFeature);
                TCP tcp = this.poseRequest.getTcp();
                if (tcp != null) {
                    ((TitledBorder)this.toolPositionPanel.getBorder()).setTitle(tcp.getDisplayName());
                    ControllerSocketSender.sendSetTCPTransform(tcp.getOffsetPose());
                    this.robotPanel.clearVisualization();
                    this.robotPanel.initializeRobotGraphics(this.poseRequest.getCurrentJointPosition());
                }
                if ((initialJointPosition = this.poseRequest.getCurrentJointPosition()) == null) {
                    initialJointPosition = RobotState.getLatestRobotState().targetJointPosition;
                }
                if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.NONE) {
                    this.lastRobotState = RobotState.getLatestRobotState().clone();
                    if (this.lastRobotState.jointPosition.epsilonEquals(initialJointPosition, 0.005)) {
                        initialJointPosition = this.lastRobotState.jointPosition;
                    }
                } else if (this.lastRobotState == null || this.lastRobotState != null && RobotState.getLatestRobotState().real && !this.lastRobotState.jointPosition.epsilonEquals(RobotState.getLatestRobotState().jointPosition, 0.005)) {
                    this.lastRobotState = RobotState.getLatestRobotState().clone();
                }
                this.featureLookup.getFeatureContainer().getToolViewFeature().setTransformAccordingToRobotState(this.lastRobotState.tool);
                this.robotPanel.setJoggableGeomFeature(selectedJoggableGeomFeature, false, true);
                this.setEnabledJointComponents(true);
                this.isInitialized = this.robotPanel.initializeRobotGraphics(initialJointPosition);
                JointPositionVector targetJointPositionVector = this.poseRequest.getTargetJointPosition();
                if (targetJointPositionVector != null) {
                    if (this.robotPanel.updateRobot2JointPosition(targetJointPositionVector)) {
                        this.setJointsValueTextFields(targetJointPositionVector);
                    }
                } else {
                    this.setJointsValueTextFields(initialJointPosition);
                }
                this.toolFeaturePose = this.robotPanel.getCurrentToolFeaturePose();
                if (targetJointPositionVector != null && this.lastFoundSolution != null && targetJointPositionVector.equals(this.lastFoundSolution)) {
                    this.setToolPositionValueTextFields(this.toolFeaturePose, true);
                } else {
                    this.rotationRepresentation.resetState();
                    Vector3d rotation = this.rotationRepresentation.computeRotation(this.toolFeaturePose.getRot());
                    this.rotationRepresentation.setValues(rotation);
                    this.setToolPositionValueTextFields(this.toolFeaturePose, false);
                }
                this.clearLabel(this.safetyWarningMessageLabel);
            } else if (o != null) {
                Log.error((String)("Class of argument not supported: " + o.getClass()), (Throwable)new Exception());
            }
            this.updateValidators();
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        }
        finally {
            this.updating = false;
        }
    }

    public void updateRobotState(RobotState robotState) {
        if (!this.isInitialized) {
            this.isInitialized = this.robotPanel.initializeRobotGraphics(this.robotPanel.getCurrentJointPostionVector());
            if (this.isInitialized) {
                JointPositionVector jvpTarget = this.poseRequest.getTargetJointPosition();
                if (jvpTarget != null) {
                    this.robotPanel.updateRobot2JointPosition(jvpTarget);
                }
                this.toolFeaturePose = this.robotPanel.getCurrentToolFeaturePose();
                this.setToolPositionValueTextFields(this.toolFeaturePose, false);
            }
        }
        boolean bl = this.performUpdateOfTextField = !this.performUpdateOfTextField;
        if (this.performUpdateOfTextField && this.robotPanel.getJoggableGeomFeature() instanceof MoveCameraView) {
            this.handleNewToolFeaturePose(this.robotPanel.updateToolFeaturePose());
        }
    }

    private void updateValidators() {
        for (BindingRegistration br : this.validators) {
            br.removeRegistration();
        }
        this.validators.clear();
        for (int i = 0; i < JOINT_LIST.size(); ++i) {
            this.validators.add(NumberFieldUtils.bindErrorValidator((JTextField)this.jointValueTextFields[i], (ValidationStrategy)this.getJointValidator((PoseEditorPanel.ValueToEdit)((Object)JOINT_LIST.get(i)))));
        }
        ValidationStrategy numberValidator = ValidationFactory.getNumberValidator();
        for (int i = 0; i < this.coordinateValueTextFields.length; ++i) {
            this.validators.add(NumberFieldUtils.bindErrorValidator((JTextField)this.coordinateValueTextFields[i], (ValidationStrategy)numberValidator));
        }
    }

    private ValidationStrategy getJointValidator(PoseEditorPanel.ValueToEdit joint) {
        double min = this.jointPositionRangeProvider.getMinimumCombinedPosition(joint.getJoint());
        double max = this.jointPositionRangeProvider.getMaximumCombinedPosition(joint.getJoint());
        WrappedJoingValidatorStrategy validator = new WrappedJoingValidatorStrategy(min, max);
        validator.setStrategy(ValidationFactory.getJointValueValidator((double)min, (double)max));
        return validator;
    }

    private void exitScreen() {
        this.featureLookup.getFeatureContainer().getToolViewFeature().setOnline(true);
        this.robotPanel.clearVisualization();
        this.poseRequest = null;
    }

    private void clearLabel(JLabel label) {
        label.setText(" ");
    }

    public Object exit() {
        if (this.poseListener != null) {
            this.poseListener = null;
        }
        if (!this.isOkOrCancelButtonPressed) {
            this.resetPoseRequest();
        }
        EventNotificationService.unregister((Object)this, RobotStateListener.class);
        this.robotPanel.setActive(false);
        this.robotPanel.robotCanvas3D.exit();
        return super.exit();
    }

    private void setJointsValueTextFields(JointPositionVector jpv) {
        for (int i = 0; i < this.jointValueTextFields.length; ++i) {
            this.jointValueTextFields[i].setValue((Object)Angle.from((double)jpv.getJoint(i), (Angle.Unit)Angle.Unit.RADIANS));
        }
    }

    private void setToolPositionValueTextFields(Pose6d toolFeaturePose, boolean useRotationRepresentationValues) {
        this.toolXValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getX(), (Length.Unit)Length.Unit.M));
        this.toolYValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getY(), (Length.Unit)Length.Unit.M));
        this.toolZValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getZ(), (Length.Unit)Length.Unit.M));
        if (useRotationRepresentationValues) {
            this.setToolRotationValueTextFields(this.rotationRepresentation.getValues());
        } else {
            Vector3d rotation = this.rotationRepresentation.computeRotation(toolFeaturePose.getRot());
            this.rotationRepresentation.setValues(rotation);
            this.setToolRotationValueTextFields(rotation);
        }
    }

    private void setToolRotationValueTextFields(Vector3d rotation) {
        Angle.Unit unit = this.getAngleUnitForRotationType(this.rotationRepresentation.getRotationType());
        this.toolRXValueTextField.setValue((Object)Angle.from((double)rotation.x, (Angle.Unit)unit));
        this.toolRYValueTextField.setValue((Object)Angle.from((double)rotation.y, (Angle.Unit)unit));
        this.toolRZValueTextField.setValue((Object)Angle.from((double)rotation.z, (Angle.Unit)unit));
    }

    private void initializeRotationTypeComboBox() {
        DefaultComboBoxModel<RotationRepresentation> comboBoxModel = new DefaultComboBoxModel<RotationRepresentation>();
        for (RotationRepresentation rr : RotationRepresentationFactory.createAll()) {
            comboBoxModel.addElement(rr);
        }
        try {
            this.rotationRepresentation = (RotationRepresentation)comboBoxModel.getSelectedItem();
        }
        catch (Exception exp) {
            Log.error((String)("Item not of type RotationRepresentation: " + comboBoxModel.getSelectedItem().getClass()), (Throwable)exp);
            this.geomFeaturesComboBox.setSelectedIndex(0);
            this.robotPanel.setJoggableGeomFeature((ViewableGeomFeature)this.geomFeaturesComboBox.getItemAt(0), false, true);
        }
        this.rotationTypeComboBox.setModel(comboBoxModel);
    }

    private void translateGUILabels() {
        this.jTextTranslator.translateJText(this.featurePanel);
        this.jTextTranslator.translateJText(this.toolPositionPanel);
        this.unreachableToolPoseErrorMessage = this.textResource.unreachablePose();
        this.clearLabel(this.toolErrorMessageLabel);
        this.clearLabel(this.safetyWarningMessageLabel);
    }

    private void initComponents() {
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        JPanel emptyNorthPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel centerPanel2 = new JPanel();
        JPanel featureCoordinateJointPanel = new JPanel();
        JPanel featureCoordinatePanel = new JPanel();
        this.featurePanel = new JPanel();
        this.geomFeaturesComboBox = new JComboBox();
        this.positionHeader = new JLabel(this.textResource.jointPositions());
        this.joint1ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT1), UnitsValueConverterFactory.getAngleConverter());
        this.joint2ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT2), UnitsValueConverterFactory.getAngleConverter());
        this.joint3ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT3), UnitsValueConverterFactory.getAngleConverter());
        this.joint4ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT4), UnitsValueConverterFactory.getAngleConverter());
        this.joint5ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT5), UnitsValueConverterFactory.getAngleConverter());
        this.joint6ValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.JOINT6), UnitsValueConverterFactory.getAngleConverter());
        this.addToJoint1Button = new JButton();
        this.addToJoint2Button = new JButton();
        this.addToJoint3Button = new JButton();
        this.addToJoint4Button = new JButton();
        this.addToJoint5Button = new JButton();
        this.addToJoint6Button = new JButton();
        this.subtractFromJoint1Button = new JButton();
        this.subtractFromJoint2Button = new JButton();
        this.subtractFromJoint3Button = new JButton();
        this.subtractFromJoint4Button = new JButton();
        this.subtractFromJoint5Button = new JButton();
        this.subtractFromJoint6Button = new JButton();
        this.toolYValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.Y_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolXValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.X_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolZValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.Z_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolRXValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.X_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        this.toolRYValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.Y_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        this.toolRZValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(PoseEditorPanel.ValueToEdit.Z_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        JButton addToToolXButton = new JButton();
        JButton addToToolYButton = new JButton();
        JButton addToToolZButton = new JButton();
        JButton addToToolRXButton = new JButton();
        JButton addToToolRYButton = new JButton();
        JButton addToToolRZButton = new JButton();
        JButton subtractFromToolXButton = new JButton();
        JButton subtractFromToolYButton = new JButton();
        JButton subtractFromToolZButton = new JButton();
        JButton subtractFromToolRXButton = new JButton();
        JButton subtractFromToolRYButton = new JButton();
        this.subtractFromToolRZButton = new JButton();
        this.rotationTypeComboBox = new JComboBox();
        this.toolErrorMessageLabel = new JLabel();
        JPanel buttonsSouthPanel = new JPanel();
        JPanel safetyWarningPanel = new JPanel();
        this.safetyWarningMessageLabel = new JLabel();
        this.setMinimumSize(new Dimension(944, 538));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        emptyNorthPanel.setMinimumSize(new Dimension(800, 10));
        emptyNorthPanel.setOpaque(false);
        emptyNorthPanel.setPreferredSize(new Dimension(800, 10));
        emptyNorthPanel.setLayout(new FlowLayout(2));
        this.add(emptyNorthPanel);
        centerPanel.setMinimumSize(new Dimension(200, 400));
        centerPanel.setPreferredSize(new Dimension(222, 77));
        centerPanel.setRequestFocusEnabled(false);
        centerPanel.setLayout(new BorderLayout());
        centerPanel2.setLayout(new BorderLayout());
        featureCoordinateJointPanel.setLayout(new BorderLayout());
        featureCoordinatePanel.setLayout(new BorderLayout());
        this.featurePanel.setBorder(BorderFactory.createTitledBorder("Feature"));
        this.featurePanel.setLayout(new BorderLayout());
        this.geomFeaturesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"No feature"}));
        this.geomFeaturesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoseEditorPanelImpl.this.geomFeaturesComboBoxActionPerformed();
            }
        });
        String x = "<html><font color=\"red\"><b>X</b></font></html>";
        String y = "<html><font color=\"lime\"><b>Y</b></font></html>";
        String z = "<html><font color=\"blue\"><b>Z</b></font></html>";
        String rx = "<html><font color=\"red\"><b>RX</b></font></html>";
        String ry = "<html><font color=\"lime\"><b>RY</b></font></html>";
        String rz = "<html><font color=\"blue\"><b>RZ</b></font></html>";
        this.toolPositionPanel = formBuilder.componentWithLabel(x, (JComponent)this.toolXValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolXButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolXButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(y, (JComponent)this.toolYValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolYButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolYButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(z, (JComponent)this.toolZValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolZButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolZButton, new FormBuilder.PanelConstraints[0]).end().end().component((JComponent)this.rotationTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().end().componentWithLabel(rx, (JComponent)this.toolRXValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRXButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolRXButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(ry, (JComponent)this.toolRYValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRYButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolRYButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(rz, (JComponent)this.toolRZValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRZButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromToolRZButton, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.toolErrorMessageLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.positionHeader, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().label(this.textResource.joint0Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint1ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint1Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint1Button, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint1Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint2ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint2Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint2Button, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint2Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint3ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint3Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint3Button, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint3Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint4ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint4Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint4Button, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint4Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint5ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint5Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint5Button, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint5Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.joint6ValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addToJoint6Button, new FormBuilder.PanelConstraints[0]).component((JComponent)this.subtractFromJoint6Button, new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{3, 4}).getPanel();
        this.toolPositionPanel.setBorder(BorderFactory.createTitledBorder("Tool_Position"));
        this.toolXValueTextField.setText("-1800.00");
        this.toolYValueTextField.setText("-1800.00");
        this.toolZValueTextField.setText("-1800.00");
        this.toolRXValueTextField.setText("-80.0000");
        this.toolRYValueTextField.setText("-00.0000");
        this.toolRZValueTextField.setText("-80.0000");
        this.initializeIncrementButton(addToToolXButton, PoseEditorPanel.ValueToEdit.X_COORD, (JTextField)this.toolXValueTextField);
        this.initializeIncrementButton(addToToolYButton, PoseEditorPanel.ValueToEdit.Y_COORD, (JTextField)this.toolYValueTextField);
        this.initializeIncrementButton(addToToolZButton, PoseEditorPanel.ValueToEdit.Z_COORD, (JTextField)this.toolZValueTextField);
        this.initializeIncrementButton(addToToolRXButton, PoseEditorPanel.ValueToEdit.X_ROT, (JTextField)this.toolRXValueTextField);
        this.initializeIncrementButton(addToToolRYButton, PoseEditorPanel.ValueToEdit.Y_ROT, (JTextField)this.toolRYValueTextField);
        this.initializeIncrementButton(addToToolRZButton, PoseEditorPanel.ValueToEdit.Z_ROT, (JTextField)this.toolRZValueTextField);
        this.initializeDecrementButton(subtractFromToolXButton, PoseEditorPanel.ValueToEdit.X_COORD, (JTextField)this.toolXValueTextField);
        this.initializeDecrementButton(subtractFromToolYButton, PoseEditorPanel.ValueToEdit.Y_COORD, (JTextField)this.toolYValueTextField);
        this.initializeDecrementButton(subtractFromToolZButton, PoseEditorPanel.ValueToEdit.Z_COORD, (JTextField)this.toolZValueTextField);
        this.initializeDecrementButton(subtractFromToolRXButton, PoseEditorPanel.ValueToEdit.X_ROT, (JTextField)this.toolRXValueTextField);
        this.initializeDecrementButton(subtractFromToolRYButton, PoseEditorPanel.ValueToEdit.Y_ROT, (JTextField)this.toolRYValueTextField);
        this.initializeDecrementButton(this.subtractFromToolRZButton, PoseEditorPanel.ValueToEdit.Z_ROT, (JTextField)this.toolRZValueTextField);
        this.rotationTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Rotation Vector Rad", "Rotation Vector Deg", "RPY Deg", "RPY Rad"}));
        this.rotationTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoseEditorPanelImpl.this.rotationTypeComboBoxActionPerformed();
            }
        });
        this.positionHeader.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        this.joint1ValueTextField.setText("-180.00");
        this.initializeIncrementButton(this.addToJoint1Button, PoseEditorPanel.ValueToEdit.JOINT1, (JTextField)this.joint1ValueTextField);
        this.initializeIncrementButton(this.addToJoint2Button, PoseEditorPanel.ValueToEdit.JOINT2, (JTextField)this.joint2ValueTextField);
        this.initializeIncrementButton(this.addToJoint3Button, PoseEditorPanel.ValueToEdit.JOINT3, (JTextField)this.joint3ValueTextField);
        this.initializeIncrementButton(this.addToJoint4Button, PoseEditorPanel.ValueToEdit.JOINT4, (JTextField)this.joint4ValueTextField);
        this.initializeIncrementButton(this.addToJoint5Button, PoseEditorPanel.ValueToEdit.JOINT5, (JTextField)this.joint5ValueTextField);
        this.initializeIncrementButton(this.addToJoint6Button, PoseEditorPanel.ValueToEdit.JOINT6, (JTextField)this.joint6ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint1Button, PoseEditorPanel.ValueToEdit.JOINT1, (JTextField)this.joint1ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint2Button, PoseEditorPanel.ValueToEdit.JOINT2, (JTextField)this.joint2ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint3Button, PoseEditorPanel.ValueToEdit.JOINT3, (JTextField)this.joint3ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint4Button, PoseEditorPanel.ValueToEdit.JOINT4, (JTextField)this.joint4ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint5Button, PoseEditorPanel.ValueToEdit.JOINT5, (JTextField)this.joint5ValueTextField);
        this.initializeDecrementButton(this.subtractFromJoint6Button, PoseEditorPanel.ValueToEdit.JOINT6, (JTextField)this.joint6ValueTextField);
        this.toolErrorMessageLabel.setFont(new Font("DejaVu Sans", 0, 13));
        this.toolErrorMessageLabel.setForeground(Color.red);
        this.toolErrorMessageLabel.setLabelFor(centerPanel);
        this.toolErrorMessageLabel.setText("Unreachable_pose");
        buttonsSouthPanel.setMinimumSize(new Dimension(800, 39));
        buttonsSouthPanel.setOpaque(false);
        buttonsSouthPanel.setPreferredSize(new Dimension(800, 40));
        buttonsSouthPanel.setLayout(new FlowLayout(2));
        safetyWarningPanel.setPreferredSize(new Dimension(560, 29));
        this.safetyWarningMessageLabel.setForeground(new Color(255, 146, 0));
        this.safetyWarningMessageLabel.setText("safety_warning");
        safetyWarningPanel.add(this.safetyWarningMessageLabel);
        JPanel featureInsetPanel = new JPanel(new BorderLayout());
        featureInsetPanel.setBorder(BorderFactory.createEmptyBorder(0, UIManager.getInt("Form.indentSize"), 5, 0));
        featureInsetPanel.add((Component)this.geomFeaturesComboBox, "Center");
        this.featurePanel.add((Component)featureInsetPanel, "Center");
        featureCoordinatePanel.add((Component)this.featurePanel, "North");
        featureCoordinatePanel.add((Component)this.toolPositionPanel, "Center");
        featureCoordinateJointPanel.add((Component)featureCoordinatePanel, "Center");
        centerPanel2.add((Component)featureCoordinateJointPanel, "East");
        centerPanel2.add((Component)this.robotPanel, "Center");
        centerPanel.add((Component)centerPanel2, "Center");
        this.add(centerPanel);
        buttonsSouthPanel.add(safetyWarningPanel);
        this.add(buttonsSouthPanel);
    }

    private void initializeIncrementButton(JButton button, PoseEditorPanel.ValueToEdit value, JTextField field) {
        button.setIcon(MoveImageResource.gtkAdd());
        this.initializeChangeValueButton(button, value, InputOperation.ADD, field);
    }

    private void initializeDecrementButton(JButton button, PoseEditorPanel.ValueToEdit value, JTextField field) {
        button.setIcon(MoveImageResource.gtkRemove());
        this.initializeChangeValueButton(button, value, InputOperation.SUBTRACT, field);
    }

    private void initializeChangeValueButton(JButton button, PoseEditorPanel.ValueToEdit value, InputOperation operation, JTextField field) {
        button.setPreferredSize(new Dimension(35, 24));
        button.setMaximumSize(new Dimension(35, 24));
        button.setMinimumSize(new Dimension(35, 24));
        button.setRequestFocusEnabled(false);
        button.addMouseListener((MouseListener)((Object)new AddSubtractValueListener(value, operation, button, field, this)));
        button.setFocusPainted(false);
    }

    @Override
    public void cancelAction() {
        if (!this.isVisible()) {
            return;
        }
        this.isOkOrCancelButtonPressed = true;
        this.resetPoseRequest();
        this.lastFoundSolution = null;
        this.exitScreen();
        this.navigateBack();
    }

    private void resetPoseRequest() {
        if (this.poseRequest != null) {
            this.poseRequest.setLastEditType(PoseRequest.LastEditType.NONE);
        }
    }

    private void geomFeaturesComboBoxActionPerformed() {
        if (this.updating) {
            return;
        }
        try {
            ViewableGeomFeature newSelectedJoggableGeomFeature = (ViewableGeomFeature)this.geomFeaturesComboBox.getSelectedItem();
            this.toolFeaturePose = this.robotPanel.calculateNewToolFeaturePose(this.robotPanel.getJoggableGeomFeature(), newSelectedJoggableGeomFeature, this.toolFeaturePose);
            this.robotPanel.setJoggableGeomFeature(newSelectedJoggableGeomFeature, true, true);
            this.setToolPositionValueTextFields(this.toolFeaturePose, false);
        }
        catch (Exception e) {
            Log.error((String)"Something that was not a JoggableGeomFeature was in the geomFeaturesComboBox", (Throwable)e);
        }
    }

    private Angle.Unit getAngleUnitForRotationType(RotationRepresentation.RotationType rotationType) {
        Angle.Unit unit = Angle.Unit.DEGREES;
        if (rotationType == RotationRepresentation.RotationType.ANGLES_RADIANS || rotationType == RotationRepresentation.RotationType.VECTOR_RADIANS) {
            unit = Angle.Unit.RADIANS;
        }
        return unit;
    }

    private void updateToolPositionData(double inputValue, PoseEditorPanel.ValueToEdit value, InputOperation inputOperation) {
        Vector3d rotationComponent = this.rotationRepresentation.getValues();
        Angle.Unit unit = this.getAngleUnitForRotationType(this.rotationRepresentation.getRotationType());
        switch (value) {
            case X_COORD: {
                double newValue;
                this.toolFeaturePose.getPos().x = newValue = inputOperation.getNewValue(this.toolFeaturePose.getPos().x, Units.convert_to_m((double)inputValue));
                this.toolXValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case Y_COORD: {
                double newValue;
                this.toolFeaturePose.getPos().y = newValue = inputOperation.getNewValue(this.toolFeaturePose.getPos().y, Units.convert_to_m((double)inputValue));
                this.toolYValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case Z_COORD: {
                double newValue;
                this.toolFeaturePose.getPos().z = newValue = inputOperation.getNewValue(this.toolFeaturePose.getPos().z, Units.convert_to_m((double)inputValue));
                this.toolZValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case X_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.x, inputValue);
                this.toolRXValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.x = newValue;
                break;
            }
            case Y_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.y, inputValue);
                this.toolRYValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.y = newValue;
                break;
            }
            case Z_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.z, inputValue);
                this.toolRZValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.z = newValue;
                break;
            }
            default: {
                Log.error((String)("Value of gettingCoordinate = " + (Object)((Object)value) + " not supported"));
                Thread.dumpStack();
                return;
            }
        }
        this.toolFeaturePose.setRot(this.rotationRepresentation.getRotationVector(rotationComponent));
        this.rotationRepresentation.setValues(rotationComponent);
        JointPositionVector jpvStart = this.poseRequest.getCurrentJointPosition();
        RobotView3DPanel.MoveRobot2ToolPositionResult target = this.robotPanel.moveRobot2ToolPosition(jpvStart, this.toolFeaturePose);
        this.setValidPose(target.isValid());
        if (target.isValid()) {
            this.setJointsValueTextFields(target.getTarget());
            this.setToolPositionValueTextFields(this.toolFeaturePose, true);
            this.poseRequest.setLastEditType(PoseRequest.LastEditType.TOOL_POSE_COORDINATE);
        } else {
            if (!this.controllerInterface.isConnected()) {
                return;
            }
            this.poseRequest.setLastEditType(PoseRequest.LastEditType.NONE);
        }
    }

    private void setToolErrorMessage(boolean validPose) {
        if (validPose) {
            this.clearLabel(this.toolErrorMessageLabel);
        } else {
            this.toolErrorMessageLabel.setText(this.unreachableToolPoseErrorMessage);
        }
    }

    private void setEnabledJointComponents(boolean enabled) {
        this.setButtonsEnabled(enabled);
        this.setJointValueTextFieldsEnabled(enabled);
        this.setToolErrorMessage(enabled);
    }

    private void setValidPose(boolean isValid) {
        this.setEnabledJointComponents(isValid);
        if (!isValid) {
            this.robotPanel.setShadowRobotAttached(false);
            this.robotPanel.clearSafetyBoundaryVisualization();
            this.clearLabel(this.safetyWarningMessageLabel);
        }
        this.displayingValidPose = isValid;
    }

    private void setButtonsEnabled(boolean enabled) {
        this.addToJoint1Button.setEnabled(enabled);
        this.addToJoint2Button.setEnabled(enabled);
        this.addToJoint3Button.setEnabled(enabled);
        this.addToJoint4Button.setEnabled(enabled);
        this.addToJoint5Button.setEnabled(enabled);
        this.addToJoint6Button.setEnabled(enabled);
        this.subtractFromJoint1Button.setEnabled(enabled);
        this.subtractFromJoint2Button.setEnabled(enabled);
        this.subtractFromJoint3Button.setEnabled(enabled);
        this.subtractFromJoint4Button.setEnabled(enabled);
        this.subtractFromJoint5Button.setEnabled(enabled);
        this.subtractFromJoint6Button.setEnabled(enabled);
        this.robotPanel.enableOk(enabled);
    }

    private void updateJointPositionData(double inputValueInDegrees, PoseEditorPanel.ValueToEdit value, InputOperation inputOperation, boolean snapToLimit) {
        JointType jointType = value.getJoint();
        JointPositionVector jpvTarget = new JointPositionVector(this.robotPanel.getCurrentJointPostionVector());
        double newValue = inputOperation.getNewValue(jpvTarget.getJoint(jointType), inputValueInDegrees * (Math.PI / 180));
        jpvTarget.setJoint(jointType.getJointNumber(), newValue);
        if (snapToLimit) {
            double jointValue = jpvTarget.getJoint(jointType.getJointNumber());
            if (jointValue > this.jointPositionRangeProvider.getMaximumCombinedPosition(jointType)) {
                jointValue = this.jointConfigurationSettings.getMaximumJointLimit(jointType);
            } else if (jointValue < this.jointPositionRangeProvider.getMinimumCombinedPosition(jointType)) {
                jointValue = this.jointConfigurationSettings.getMinimumJointLimit(jointType);
            }
            jpvTarget.setJoint(jointType.getJointNumber(), jointValue);
        }
        if (this.jointPositionRangeProvider.isJointInsideRange(jointType, jpvTarget.getJoint(jointType))) {
            if (this.robotPanel.updateRobot2JointPosition(jpvTarget)) {
                this.toolFeaturePose = this.robotPanel.getCurrentToolFeaturePose();
                this.jointValueTextFields[jointType.getJointNumber()].setValue((Object)Angle.from((double)jpvTarget.getJoint(jointType), (Angle.Unit)Angle.Unit.RADIANS));
                this.setToolPositionValueTextFields(this.toolFeaturePose, false);
                this.clearLabel(this.toolErrorMessageLabel);
                this.setValidPose(true);
                this.poseRequest.setLastEditType(PoseRequest.LastEditType.JOINT_POSITION);
            }
        } else {
            this.setJointsValueTextFields(this.robotPanel.getCurrentJointPostionVector());
            String unitStr = Units.getText().unitDegrees();
            long jointMaxLimitInDegrees = Math.round(Math.toDegrees(this.jointPositionRangeProvider.getMaximumCombinedPosition(jointType)));
            long jointMinLimitInDegrees = Math.round(Math.toDegrees(this.jointPositionRangeProvider.getMinimumCombinedPosition(jointType)));
            this.errorDialogCreator.showErrorDialog(new ErrorMessage(this.textResource.valueIsNotValid(), this.textResource.valueOutOfRange(jointMinLimitInDegrees, unitStr, jointMaxLimitInDegrees)), new OkDialogListener());
        }
    }

    private void setJointValueTextFieldsEnabled(boolean enabled) {
        this.joint1ValueTextField.setEnabled(enabled);
        this.joint2ValueTextField.setEnabled(enabled);
        this.joint3ValueTextField.setEnabled(enabled);
        this.joint4ValueTextField.setEnabled(enabled);
        this.joint5ValueTextField.setEnabled(enabled);
        this.joint6ValueTextField.setEnabled(enabled);
    }

    @Override
    public void okAction() {
        if (!this.isVisible()) {
            return;
        }
        this.isOkOrCancelButtonPressed = true;
        if (this.poseRequest != null) {
            this.poseRequest.setJoggableGeomFeature(this.robotPanel.getJoggableGeomFeature());
            if (this.displayingValidPose) {
                this.poseRequest.setTargetJointPostion(this.robotPanel.getCurrentJointPostionVector().clone());
                this.poseRequest.setToolPose(new Pose6d(this.robotPanel.getCurrentToolBasePose()));
                this.lastFoundSolution = this.robotPanel.getCurrentJointPostionVector().clone();
            }
        }
        if (this.poseListener != null) {
            this.poseListener.handleNewPose(this.poseRequest);
            this.poseListener = null;
        }
        this.exitScreen();
        this.navigateBack();
    }

    private void rotationTypeComboBoxActionPerformed() {
        try {
            RotationRepresentation newSelectedRotationRepresentation = (RotationRepresentation)this.rotationTypeComboBox.getSelectedItem();
            RotationRepresentation.RotationType oldRotType = this.rotationRepresentation.getRotationType();
            Vector3d rotation = newSelectedRotationRepresentation.computeRotation(this.rotationRepresentation.getRotationMatrix());
            newSelectedRotationRepresentation.setValues(rotation);
            this.rotationRepresentation = newSelectedRotationRepresentation;
            PoseEditorPanelImpl.setRotationIncreaseDecrease(oldRotType, this.rotationRepresentation.getRotationType());
            this.setValueConvertersOnRotationFields(this.rotationRepresentation.getRotationType());
            this.setToolRotationValueTextFields(rotation);
        }
        catch (Exception e) {
            Log.error((String)"Something that was not a RotationRepresentation was in the rotationTypeComboBox: ", (Throwable)e);
        }
    }

    private void setValueConvertersOnRotationFields(RotationRepresentation.RotationType rotationType) {
        if (rotationType == RotationRepresentation.RotationType.ANGLES_DEGREES || rotationType == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            this.toolRXValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
            this.toolRYValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
            this.toolRZValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
        } else {
            this.toolRXValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
            this.toolRYValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
            this.toolRZValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
        }
    }

    private void userEnteredInput(JTextField textField, PoseEditorPanel.ValueToEdit coordinate, InputOperation operation) {
        this.userEnteredInput(textField, coordinate, operation, null);
    }

    private void userEnteredInput(JTextField textField, PoseEditorPanel.ValueToEdit coordinate, InputOperation operation, JTextField inputValueTextField) {
        try {
            double inputValue = PrimitiveUtils.parseDouble((String)(inputValueTextField == null ? textField.getText() : inputValueTextField.getText()));
            if (coordinate.isJoint()) {
                this.updateJointPositionData(inputValue, coordinate, operation, false);
            } else {
                this.updateToolPositionData(inputValue, coordinate, operation);
            }
        }
        catch (NumberFormatException ex1) {
            this.messageDialogCreator.showMessageDialog(new DialogMessage(this.textResource.Message(), this.textResource.notANumber()), MessageDialogType.MESSAGE, new OkDialogListener());
        }
        catch (Exception ex2) {
            Log.error((String)"Invalid number entered ", (Throwable)ex2);
            this.errorDialogCreator.showErrorDialog(new ErrorMessage(this.textResource.Error(), ex2.getMessage()), new OkDialogListener());
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private PoseEditorPanel.ValueToEdit valueToEdit;

        public TextFieldActionListener(PoseEditorPanel.ValueToEdit valueToEdit) {
            this.valueToEdit = valueToEdit;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField source = (JTextField)e.getSource();
            PoseEditorPanelImpl.this.userEnteredInput(source, this.valueToEdit, InputOperation.VALUE);
            PoseEditorPanelImpl.this.updateSafetyWarningMessage();
        }
    }

    private class AddSubtractValueListener
    extends LongPressListener
    implements RobotStateListener {
        private PoseEditorPanel.ValueToEdit value;
        private InputOperation operation;
        private JButton button;
        private JTextField field;
        private PoseEditorPanelImpl panel;

        AddSubtractValueListener(PoseEditorPanel.ValueToEdit value, InputOperation operation, JButton button, JTextField field, PoseEditorPanelImpl panel) {
            super(150);
            this.value = value;
            this.operation = operation;
            this.button = button;
            this.field = field;
            this.panel = panel;
        }

        public void onShortPress() {
            if (this.panel.controllerRequirement.checkAndNotify()) {
                this.jumpToOnScreenKeyPad();
            }
        }

        public void onLongPress() {
            EventNotificationService.unregister((Object)this.panel);
            EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)((Object)this));
        }

        public void updateRobotState(RobotState robotState) {
            if (!this.panel.controllerRequirement.checkAndNotify()) {
                this.panel.performUpdateOfTextField = !this.panel.performUpdateOfTextField;
                if (this.panel.performUpdateOfTextField && this.panel.robotPanel.getJoggableGeomFeature() instanceof MoveCameraView) {
                    this.panel.handleNewToolFeaturePose(this.panel.robotPanel.updateToolFeaturePose());
                }
            }
            if (PoseEditorPanelImpl.this.dialogOnScreen.isShowingADialog()) {
                this.mouseReleased(null);
                return;
            }
            if (this.value.isJoint()) {
                this.panel.handleJointIncreaseDecrease(this.value, this.operation);
            }
            if (this.value.isCoordinate()) {
                this.panel.handlePositionIncreaseDecrease(this.value, this.operation);
            }
            if (this.value.isRotation()) {
                this.panel.handleRotationIncreaseDecrease(this.value, this.operation);
            }
            this.panel.updateSafetyWarningMessage();
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            EventNotificationService.register((Object)this.panel, RobotStateListener.class, (Object)this.panel);
            EventNotificationService.unregister((Object)((Object)this));
            this.button.setSelected(false);
            jointIncreaseDecrease = 0.005;
            positionIncreaseDecrease = 0.01;
            rotationIncreaseDecrease = minRotationIncreaseDecrease;
            countBetweenAcceleration = 0;
        }

        private void jumpToOnScreenKeyPad() {
            final JTextField textField = new JTextField("0");
            textField.selectAll();
            final BindingRegistration registration = NumberFieldUtils.bindValidator((JTextField)textField, (ValidationStrategy)this.getValidationStrategy(), (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
            NumberPicker numberPicker = new NumberPicker(textField, true);
            numberPicker.setMode(((NumberField)this.field).getMode());
            numberPicker.addCloseListener(new CloseListener(){

                public void onClose() {
                    registration.removeRegistration();
                }
            });
            numberPicker.addCompletedListener((CompletedListener)new CompletedListener.Template(){

                public void requestApply() {
                    AddSubtractValueListener.this.panel.userEnteredInput(AddSubtractValueListener.this.field, AddSubtractValueListener.this.value, AddSubtractValueListener.this.operation, textField);
                    AddSubtractValueListener.this.panel.updateSafetyWarningMessage();
                }
            });
            numberPicker.showKeypad((JComponent)this.field);
        }

        private ValidationStrategy getValidationStrategy() {
            ValidationStrategy validationStrategy = ValidationStrategy.ALWAYS_VALID;
            if (this.value.isCoordinate() || this.value.isRotation()) {
                validationStrategy = ValidationFactory.getNumberValidator();
            }
            if (this.value.isJoint()) {
                JointType jointType = this.value.getJoint();
                double min = this.panel.jointPositionRangeProvider.getMinimumCombinedPosition(jointType);
                double max = this.panel.jointPositionRangeProvider.getMaximumCombinedPosition(jointType);
                validationStrategy = ValidationFactory.getJointValueValidator((double)min, (double)max, (double)PrimitiveUtils.parseDouble((String)this.field.getText(), (double)0.0), (InputOperation)this.operation);
            }
            return validationStrategy;
        }
    }

    private static class WrappedJoingValidatorStrategy
    extends ValidationStrategy.ValidationWrapperStrategy {
        private final double minJointLimit;
        private final double maxJointLimit;

        public WrappedJoingValidatorStrategy(double minJointLimit, double maxJointLimit) {
            this.minJointLimit = Math.round(Math.toDegrees(minJointLimit));
            this.maxJointLimit = Math.round(Math.toDegrees(maxJointLimit));
        }

        public String getErrorMessage(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)(uncheckedString = uncheckedString.replace(',', '.'))) || StringUtils.equalsAny((String)uncheckedString, (String[])new String[]{".", "-", "-."})) {
                return "";
            }
            try {
                PrimitiveUtils.parseDouble((String)uncheckedString);
            }
            catch (NumberFormatException nfex) {
                return SwingLanguagePack.getTextResource().notANumber();
            }
            return SwingLanguagePack.getTextResource().valueOutOfRange(this.minJointLimit, Units.getText().unitDegrees(), this.maxJointLimit);
        }
    }
}

