/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.injection.Builder;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTabPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.poseeditor.PoseEditorPanel;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.move.AutoMoveCallback;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.move.MoveRequestFactory;
import com.ur.polyscope.move.RobotMovement;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.swing.CardPanel;
import com.ur.view.constants.dev.RobotMode;
import javax.inject.Inject;

public class PoseRequester {
    private final MoveTabRobotModel robotModel;
    private final RobotInitializationService initializationRobotDialog;
    private final Builder builder;
    private final RobotMovement robotMovement;
    private final MoveRequestFactory moveRequestFactory;
    private CardPanel cardPanel;
    private boolean jumpedToAutoMovePanel = false;
    private PoseRequest poseRequest = null;
    private int callStackDepth = 0;

    @Inject
    public PoseRequester(MoveTabRobotModel robotModel, RobotInitializationService initializationRobotDialog, Builder builder, RobotMovement robotMovement, MoveRequestFactory moveRequestFactory) {
        this.robotModel = robotModel;
        this.initializationRobotDialog = initializationRobotDialog;
        this.builder = builder;
        this.robotMovement = robotMovement;
        this.moveRequestFactory = moveRequestFactory;
    }

    public void setCardPanel(MoveTabPanel cardPanel) {
        this.cardPanel = cardPanel;
    }

    public int getCallStackDepth() {
        return this.callStackDepth;
    }

    public void setCallStackDepth(int callStackDepth) {
        this.callStackDepth = callStackDepth;
    }

    public void cancelPoseRequest() {
        this.poseRequest = null;
    }

    public PoseRequest getPoseRequest() {
        return this.poseRequest;
    }

    public void startPoseRequest(ViewableGeomFeature feature, TCP tcp) {
        if (this.robotModel.poweredOnRobotRequirement().checkAndNotify() && this.preparePoseRequest(feature, tcp)) {
            this.switchToPoseEditor();
        }
    }

    public void handlePoseRequests() {
        if (this.jumpedToAutoMovePanel) {
            if (this.poseRequest != null) {
                boolean returnToPoseEditor = true;
                if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.JOINT_POSITION) {
                    JointPositionVector jointPosition = RobotState.getLatestRobotState().jointPosition;
                    if (jointPosition.epsilonEquals(this.poseRequest.getTargetJointPosition(), 0.005)) {
                        returnToPoseEditor = false;
                    }
                } else if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.TOOL_POSE_COORDINATE) {
                    RobotState rs = RobotState.getLatestRobotState();
                    Pose6d currentToolPose = new Pose6d(rs.tool);
                    if (Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentToolPose, (Pose6d)this.poseRequest.getTargetToolPose()) < 0.005) {
                        returnToPoseEditor = false;
                    }
                } else {
                    returnToPoseEditor = false;
                }
                if (returnToPoseEditor) {
                    this.jumpedToAutoMovePanel = false;
                    this.setCurrentJointPositionInPoseRequest();
                    this.switchToPoseEditor();
                } else {
                    this.poseRequest = null;
                }
            }
            this.jumpedToAutoMovePanel = false;
        } else if (this.poseRequest != null) {
            this.userEnteredInput();
        }
    }

    private void userEnteredInput() {
        if (this.poseRequest == null) {
            return;
        }
        if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.NONE) {
            this.poseRequest = null;
            return;
        }
        JointPositionVector userEnteredJpvTarget = this.poseRequest.getTargetJointPosition();
        if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.TOOL_POSE_COORDINATE) {
            MoveRequest moveRequest = this.moveRequestFactory.createMoveRequest(new ToolPosition(this.poseRequest.getTargetToolPose().toArray()), (AutoMoveCallback)new AutoMoveCallback.Template());
            this.robotMovement.moveTo(moveRequest);
            this.poseRequest = null;
        } else if (this.poseRequest.getLastEditType() == PoseRequest.LastEditType.JOINT_POSITION) {
            MoveRequest moveRequest = this.moveRequestFactory.createMoveRequest(new JointConfiguration(userEnteredJpvTarget.getJoints()), (AutoMoveCallback)new AutoMoveCallback.Template());
            this.robotMovement.moveTo(moveRequest);
            this.poseRequest = null;
        }
    }

    private boolean preparePoseRequest(ViewableGeomFeature feature, TCP tcp) {
        if (RobotState.getLatestRobotState().robotMode != RobotMode.NO_CONTROLLER && RobotState.getLatestRobotState().hasReceivedPositionData) {
            this.poseRequest = new PoseRequest();
            if (feature != null) {
                this.poseRequest.setJoggableGeomFeature(feature);
            }
            if (tcp != null) {
                this.poseRequest.setTcp(tcp);
            }
            this.setCurrentJointPositionInPoseRequest();
            return true;
        }
        this.initializationRobotDialog.initializeRobot();
        return false;
    }

    private void setCurrentJointPositionInPoseRequest() {
        RobotState robotState = RobotState.getLatestRobotState();
        this.poseRequest.setCurrentJointPosition(robotState.real ? robotState.targetJointPosition : robotState.jointPosition);
    }

    private void switchToPoseEditor() {
        this.cardPanel.stackCurrentCardAndSwitchTo(((Object)((Object)((PoseEditorPanel)((Object)this.builder.get(PoseEditorPanel.class))))).getClass(), (Object)this.poseRequest);
    }
}

