/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.ControllerSocketSender;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.internaltcp.domain.TCPVisualization;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehavior;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.ViewContext;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class RobotView3DPanel
extends JPanel
implements RobotStateListener,
ViewBehaviorHolder {
    private final ElementsVisualizer elementsVisualizerAggregator;
    private final TextResource textResource;
    private final JointPositionVector currentJointPostionVector = new JointPositionVector();
    protected RobotCanvas3D robotCanvas3D;
    protected ViewBehavior viewBehavior = ViewBehavior.NONE;
    protected ViewableGeomFeature joggableGeomFeature;
    private final InverseKinematicProviderExt inverseKinematicProviderExt;
    boolean updating = false;
    private Pose6d currentToolFeaturePose = new Pose6d();
    private Pose6d currentToolBasePose = new Pose6d();
    private ProgramVisualization programVisualization;
    private ControllerInterface controllerInterface;
    private JPanel robotViewPanel;
    protected TCPVisualization tcpVisualization = new TCPVisualization();

    public ProgramVisualization getProgramVisualization() {
        return this.programVisualization;
    }

    public RobotView3DPanel(ElementsVisualizerAggregator elementsVisualizerAggregator, RobotCanvas3DFactory robotCanvas3DFactory, ViewContext viewContext, ControllerInterface controllerInterface, InverseKinematicProviderExt inverseKinematicProviderExt) {
        this.elementsVisualizerAggregator = elementsVisualizerAggregator;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.controllerInterface = controllerInterface;
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.initComponents();
        this.initComponentNames();
        this.robotCanvas3D = robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("Pose Editor 3D Canvas");
        this.robotViewPanel.add(this.robotCanvas3D.getComponent());
        this.robotCanvas3D.showStaticElements(Collections.singleton(VisualizerElementType.TCP));
        this.programVisualization = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualization.getElementNode());
        }
        this.robotCanvas3D.addNodeToScene(elementsVisualizerAggregator.getElementNode());
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
    }

    public ViewBehavior getViewBehavior() {
        return this.viewBehavior;
    }

    public void setViewBehavior(ViewBehavior viewBehavior) {
        this.viewBehavior = viewBehavior;
    }

    public void updateRobotState(RobotState robotState) {
        this.robotCanvas3D.addQueue((Runnable)new UpdateViewRunnable());
    }

    private void clearToolData() {
        this.currentToolBasePose.getPos().set(0.0, 0.0, 0.0);
        this.currentToolBasePose.getRot().set(0.0, 0.0, 0.0);
        this.currentToolFeaturePose.getPos().set(0.0, 0.0, 0.0);
        this.currentToolFeaturePose.getRot().set(0.0, 0.0, 0.0);
    }

    private void calculateNewToolFeaturePose(ViewableGeomFeature newJoggableGeomFeature) {
        Pose6d baseCoordinatesTargetPose = this.currentToolFeaturePose;
        if (this.joggableGeomFeature != null) {
            this.currentToolBasePose = baseCoordinatesTargetPose = this.joggableGeomFeature.transformPoseInFeatureFrameToPoseInBaseFrame(this.currentToolFeaturePose);
        }
        if (newJoggableGeomFeature != null) {
            this.currentToolFeaturePose = newJoggableGeomFeature.calculateToolPoseInFeatureCoordinates(baseCoordinatesTargetPose);
        }
    }

    public Pose6d updateToolFeaturePose() {
        if (this.joggableGeomFeature != null) {
            this.currentToolFeaturePose = this.joggableGeomFeature.calculateToolPoseInFeatureCoordinates(this.currentToolBasePose);
        }
        return this.currentToolFeaturePose;
    }

    public Pose6d calculateNewToolFeaturePose(ViewableGeomFeature oldJoggableGeomFeature, ViewableGeomFeature newJoggableGeomFeature, Pose6d oldFeaturePose) {
        if (oldJoggableGeomFeature != null && newJoggableGeomFeature != null) {
            Pose6d oldBaseCoordinatesPose = oldJoggableGeomFeature.transformPoseInFeatureFrameToPoseInBaseFrame(oldFeaturePose);
            return newJoggableGeomFeature.calculateToolPoseInFeatureCoordinates(oldBaseCoordinatesPose);
        }
        return null;
    }

    public void setJoggableGeomFeature(ViewableGeomFeature newJoggableGeomFeature, boolean transitionEnabled) {
        this.setJoggableGeomFeature(newJoggableGeomFeature, transitionEnabled, false);
    }

    public void setJoggableGeomFeature(ViewableGeomFeature newJoggableGeomFeature, boolean transitionEnabled, boolean longArrows) {
        this.updating = true;
        this.calculateNewToolFeaturePose(newJoggableGeomFeature);
        if (this.joggableGeomFeature != newJoggableGeomFeature && newJoggableGeomFeature != null) {
            ViewableGeomFeature currentGeomFeature = this.joggableGeomFeature;
            this.joggableGeomFeature = newJoggableGeomFeature;
            this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(currentGeomFeature, transitionEnabled, newJoggableGeomFeature, longArrows));
        }
        this.updating = false;
    }

    public MoveRobot2ToolPositionResult moveRobot2ToolPosition(JointPositionVector jpvFrom, Pose6d targetFeaturePose) {
        if (!this.controllerInterface.isConnected()) {
            return new MoveRobot2ToolPositionResult(null, false);
        }
        Pose6d baseCoordinatesTargetPose = this.joggableGeomFeature != null ? this.joggableGeomFeature.transformPoseInFeatureFrameToPoseInBaseFrame(targetFeaturePose) : targetFeaturePose;
        JointPositionVector jpv_target = jpvFrom != null ? this.inverseKinematicProviderExt.getInverseKinematicsMoveL(baseCoordinatesTargetPose.getPos(), baseCoordinatesTargetPose.getRot(), jpvFrom) : this.inverseKinematicProviderExt.getInverseKinematics(baseCoordinatesTargetPose, this.currentJointPostionVector);
        this.currentToolFeaturePose = targetFeaturePose;
        this.currentToolBasePose = baseCoordinatesTargetPose;
        boolean insideLimit = false;
        if (jpv_target != null) {
            this.updateRobotGrahpics(jpv_target, false);
            insideLimit = true;
        } else {
            Log.warning((String)"Received invalid joint position vector");
        }
        return new MoveRobot2ToolPositionResult(jpv_target, insideLimit);
    }

    public Pose6d getCurrentToolFeaturePose() {
        return this.currentToolFeaturePose;
    }

    public JointPositionVector getCurrentJointPostionVector() {
        return this.currentJointPostionVector;
    }

    public boolean initializeRobotGraphics(JointPositionVector jpv) {
        boolean isInitialized = false;
        if (this.controllerInterface.isConnected()) {
            isInitialized = this.updateTCPPose(jpv);
        }
        this.updateRobotGrahpics(jpv, true);
        return isInitialized;
    }

    public void setShadowRobotAttached(boolean attach) {
        this.robotCanvas3D.addQueue((Runnable)new SetShadowsRunnable(attach));
    }

    private void updateRobotGrahpics(JointPositionVector jpvec, boolean drawRealRobot) {
        this.robotCanvas3D.addQueue((Runnable)new RedrawGraphicsRunnable(drawRealRobot, jpvec));
        this.currentJointPostionVector.set(jpvec);
    }

    private boolean updateTCPPose(JointPositionVector jpv) {
        try {
            Pose6d baseTCPPose = ControllerSocketSender.getTCPPose(jpv);
            if (baseTCPPose == null) {
                Log.error((String)"RobotView3DPanel: Retrieving TCP pose: error");
                return false;
            }
            this.currentToolFeaturePose = this.joggableGeomFeature != null ? this.joggableGeomFeature.calculateToolPoseInFeatureCoordinates(baseTCPPose) : baseTCPPose;
            this.currentToolBasePose = baseTCPPose;
        }
        catch (Exception ex) {
            Log.error((String)("RobotView3DPanel: Retrieving TCP pose: exception: " + ex));
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateRobot2JointPosition(JointPositionVector jpvTarget) {
        if (!this.controllerInterface.isConnected()) {
            return false;
        }
        if (this.updateTCPPose(jpvTarget)) {
            this.updateRobotGrahpics(jpvTarget, false);
            return true;
        }
        Log.error((String)"Getting TCP failed!");
        return false;
    }

    public void clearVisualization() {
        ViewableGeomFeature joggableGeomFeatureFinal = this.joggableGeomFeature;
        this.joggableGeomFeature = null;
        this.robotCanvas3D.addQueue((Runnable)new ClearVisualizationRunnable(joggableGeomFeatureFinal));
        this.clearToolData();
    }

    public void clearSafetyBoundaryVisualization() {
        this.elementsVisualizerAggregator.clearVisualization();
    }

    public ViewableGeomFeature getJoggableGeomFeature() {
        return this.joggableGeomFeature;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.robotCanvas3D.setVisible(this.joggableGeomFeature, visible);
    }

    public void setActive(boolean active) {
        this.setVisible(active);
        if (active) {
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        } else {
            EventNotificationService.unregister((Object)this, RobotStateListener.class);
        }
    }

    private void initComponentNames() {
        TitledBorder titledBorder = (TitledBorder)this.getBorder();
        if (titledBorder != null) {
            titledBorder.setTitle(this.textResource.robotView());
        }
    }

    public Pose6d getCurrentToolBasePose() {
        return this.currentToolBasePose;
    }

    private void initComponents() {
        this.robotViewPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("Robot_View"));
        this.setLayout(new BorderLayout());
        this.robotViewPanel.setLayout(new BorderLayout());
        this.add((Component)this.robotViewPanel, "Center");
    }

    private class ClearVisualizationRunnable
    implements Runnable {
        private final ViewableGeomFeature joggableGeomFeatureFinal;

        public ClearVisualizationRunnable(ViewableGeomFeature joggableGeomFeatureFinal) {
            this.joggableGeomFeatureFinal = joggableGeomFeatureFinal;
        }

        @Override
        public void run() {
            RobotView3DPanel.this.programVisualization.clearVisualization();
            if (this.joggableGeomFeatureFinal != null) {
                RobotView3DPanel.this.robotCanvas3D.unsetViewableGeomFeature(this.joggableGeomFeatureFinal);
            }
            RobotView3DPanel.this.robotCanvas3D.setShadowRobotAttached(false);
            RobotView3DPanel.this.robotCanvas3D.setRobotAttached(false);
            RobotView3DPanel.this.clearSafetyBoundaryVisualization();
        }
    }

    private class RedrawGraphicsRunnable
    implements Runnable {
        private final boolean drawRealRobot;
        private final JointPositionVector jpvec;

        public RedrawGraphicsRunnable(boolean drawRealRobot, JointPositionVector jpvec) {
            this.drawRealRobot = drawRealRobot;
            this.jpvec = jpvec;
        }

        @Override
        public void run() {
            if (this.drawRealRobot) {
                RobotView3DPanel.this.robotCanvas3D.setShadowRobotAttached(false);
                RobotView3DPanel.this.robotCanvas3D.setRobotAttached(true);
                RobotView3DPanel.this.robotCanvas3D.setJointAngleVector(this.jpvec);
                RobotView3DPanel.this.tcpVisualization.setPosition(RobotView3DPanel.this.currentToolBasePose);
            } else {
                RobotView3DPanel.this.robotCanvas3D.setShadowRobotJointAngleVector(this.jpvec);
            }
            RobotView3DPanel.this.elementsVisualizerAggregator.displayProximity(RobotView3DPanel.this.currentToolBasePose);
        }
    }

    private class SetShadowsRunnable
    implements Runnable {
        private final boolean attach;

        public SetShadowsRunnable(boolean attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            RobotView3DPanel.this.robotCanvas3D.setShadowRobotAttached(this.attach);
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private final ViewableGeomFeature currentGeomFeature;
        private final boolean transitionEnabled;
        private final ViewableGeomFeature newJoggableGeomFeature;
        private final boolean longArrows;

        public UpdateGraphicsRunnable(ViewableGeomFeature currentGeomFeature, boolean transitionEnabled, ViewableGeomFeature newJoggableGeomFeature, boolean longArrows) {
            this.currentGeomFeature = currentGeomFeature;
            this.transitionEnabled = transitionEnabled;
            this.newJoggableGeomFeature = newJoggableGeomFeature;
            this.longArrows = longArrows;
        }

        @Override
        public void run() {
            if (this.currentGeomFeature != null) {
                RobotView3DPanel.this.robotCanvas3D.unsetViewableGeomFeature(this.currentGeomFeature);
            }
            RobotView3DPanel.this.robotCanvas3D.setTransitionEnabled(this.transitionEnabled);
            RobotView3DPanel.this.robotCanvas3D.setViewableGeomFeature(this.newJoggableGeomFeature);
            RobotView3DPanel.this.programVisualization.clearVisualization();
            this.newJoggableGeomFeature.setProgramVisualization(RobotView3DPanel.this.programVisualization);
            this.newJoggableGeomFeature.applyShowAxesChoice(RobotView3DPanel.this.programVisualization, false, this.longArrows);
        }
    }

    public final class MoveRobot2ToolPositionResult {
        private JointPositionVector jpv_target = null;
        private boolean isInsideLimit = false;

        public MoveRobot2ToolPositionResult(JointPositionVector jpv_target, boolean isInsideLimit) {
            this.jpv_target = jpv_target;
            this.isInsideLimit = isInsideLimit;
        }

        public boolean isValid() {
            return this.jpv_target != null && this.isInsideLimit;
        }

        public JointPositionVector getTarget() {
            return this.jpv_target;
        }
    }

    private class UpdateViewRunnable
    implements Runnable {
        private UpdateViewRunnable() {
        }

        @Override
        public void run() {
            switch (RobotView3DPanel.this.viewBehavior) {
                case NONE: {
                    break;
                }
                case ZOOMING_IN: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(-0.05, 0.0, 0.0);
                    break;
                }
                case ZOOMING_OUT: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(0.05, 0.0, 0.0);
                    break;
                }
                case PANNING_LEFT: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(0.0, -0.05, 0.0);
                    break;
                }
                case PANNING_RIGHT: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(0.0, 0.05, 0.0);
                    break;
                }
                case PANNING_UP: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(0.0, 0.0, 0.025);
                    break;
                }
                case PANNING_DOWN: {
                    RobotView3DPanel.this.joggableGeomFeature.moveView(0.0, 0.0, -0.025);
                    break;
                }
                default: {
                    Log.error((String)("RobotView3DPanel.updateRobotState() Error: Value of viewBehavior = " + RobotView3DPanel.this.viewBehavior + " not supported"));
                }
            }
        }
    }
}

