/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class MoveImageResource {
    private static boolean isG5 = true;

    private MoveImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="form-warning.png")
    public static Icon formWarning() {
        return MoveImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="move-align.png")
    public static Icon moveAlign() {
        return MoveImageResource.tryGetImage("move-align.png");
    }

    @Key(value="play_icon.png")
    public static Icon playIcon() {
        return MoveImageResource.tryGetImage("play_icon.png");
    }

    @Key(value="step_icon.png")
    public static Icon stepIcon() {
        return MoveImageResource.tryGetImage("step_icon.png");
    }

    @Key(value="stock-zoom-out.png")
    public static Icon stockZoomOut() {
        return MoveImageResource.tryGetImage("stock-zoom-out.png");
    }

    @Key(value="gtk-cancel.png")
    public static Icon gtkCancel() {
        return MoveImageResource.tryGetImage("gtk-cancel.png");
    }

    @Key(value="stop_black.png")
    public static Icon stopBlack() {
        return MoveImageResource.tryGetImage("stop_black.png");
    }

    @Key(value="stock-zoom-fit.png")
    public static Icon stockZoomFit() {
        return MoveImageResource.tryGetImage("stock-zoom-fit.png");
    }

    @Key(value="auto_move_3pe.png")
    public static Icon autoMove3pe() {
        return MoveImageResource.tryGetImage("auto_move_3pe.png");
    }

    @Key(value="cancel.png")
    public static Icon cancel() {
        return MoveImageResource.tryGetImage("cancel.png");
    }

    @Key(value="gtk-remove.png")
    public static Icon gtkRemove() {
        return MoveImageResource.tryGetImage("gtk-remove.png");
    }

    @Key(value="move_black.png")
    public static Icon moveBlack() {
        return MoveImageResource.tryGetImage("move_black.png");
    }

    @Key(value="metal-info.png")
    public static Icon metalInfo() {
        return MoveImageResource.tryGetImage("metal-info.png");
    }

    @Key(value="stock-zoom-in.png")
    public static Icon stockZoomIn() {
        return MoveImageResource.tryGetImage("stock-zoom-in.png");
    }

    @Key(value="gtk-add.png")
    public static Icon gtkAdd() {
        return MoveImageResource.tryGetImage("gtk-add.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return MoveImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            MoveImageResource.tryGetImage("form-warning.png");
            MoveImageResource.tryGetImage("move-align.png");
            MoveImageResource.tryGetImage("play_icon.png");
            MoveImageResource.tryGetImage("step_icon.png");
            MoveImageResource.tryGetImage("stock-zoom-out.png");
            MoveImageResource.tryGetImage("gtk-cancel.png");
            MoveImageResource.tryGetImage("stop_black.png");
            MoveImageResource.tryGetImage("stock-zoom-fit.png");
            MoveImageResource.tryGetImage("auto_move_3pe.png");
            MoveImageResource.tryGetImage("cancel.png");
            MoveImageResource.tryGetImage("gtk-remove.png");
            MoveImageResource.tryGetImage("move_black.png");
            MoveImageResource.tryGetImage("metal-info.png");
            MoveImageResource.tryGetImage("stock-zoom-in.png");
            MoveImageResource.tryGetImage("gtk-add.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

