/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.selftest;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.JointPaintStrategy;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionVectorPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.move.JointPositionMovePanel;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MoveJointsSelfTestPanel
extends JPanel
implements JointPositionMovePanel {
    private final JointPaintStrategy jointPaintStrategy;
    private final InstallationComponentLookup installationLookup;
    private EventManager eventManager;
    private Subscription robotStateSubscription = Subscription.NULL;
    private MoveTabRobotModel robotModel;

    @Inject
    public MoveJointsSelfTestPanel(MoveTabRobotModel robotModel, InstallationComponentLookup installationLookup, ViewContext viewContext, JointConfigurationSettings configurationSettings, JointPositionRangeProvider rangeProvider, EventManager eventManager) {
        this.eventManager = eventManager;
        this.installationLookup = installationLookup;
        this.robotModel = robotModel;
        JointPositionVectorPanel jointPositionVectorPanel = new JointPositionVectorPanel(viewContext, robotModel);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.jointPaintStrategy = new JointPaintStrategy(rangeProvider, jointPositionVectorPanel.getJointPositionIndicators().toArray(new JointPositionIndicator[jointPositionVectorPanel.getJointPositionIndicators().size()]), jointPositionVectorPanel.getJointPositionFields().toArray(new JTextField[jointPositionVectorPanel.getJointPositionFields().size()]), new JTextField[0], jointPositionVectorPanel.getJointRevolutionLabels().toArray(new JLabel[jointPositionVectorPanel.getJointRevolutionLabels().size()]));
        this.jointPaintStrategy.setConfigurationSettings(configurationSettings);
        this.add((Component)jointPositionVectorPanel, "Center");
        this.onEnter();
    }

    public void onEnter() {
        this.jointPaintStrategy.setEnabledOnAllTextFields(true);
        this.jointPaintStrategy.paintJointLimits(RobotState.getLatestRobotState().reducedModeActive, true);
        this.jointPaintStrategy.hideTargetPositions();
        this.robotStateSubscription = this.eventManager.addStrongListener(RobotStateListener.class, (Object)new MoveJointsRobotStateListener());
        this.robotModel.setDisplayedTCP(((TCPSettings)this.installationLookup.getComponent(TCPSettings.class)).getActiveTCP());
    }

    public JPanel asJPanel() {
        return this;
    }

    public void onExit() {
        this.robotStateSubscription.dispose();
    }

    private void showGotoInitializeRobotIfRobotNotRunning() {
        if (!RobotState.getLatestRobotState().hasReceivedPositionData) {
            this.robotModel.runningRobotRequirement().checkAndNotify();
        }
    }

    private class MoveJointsRobotStateListener
    implements RobotStateListener {
        private boolean performUpdateOfTextField = true;

        private MoveJointsRobotStateListener() {
        }

        public void updateRobotState(RobotState rs) {
            this.performUpdateOfTextField = !this.performUpdateOfTextField;
            JointPositionVector jointPositionVector = rs.jointPosition;
            MoveJointsSelfTestPanel.this.jointPaintStrategy.setEnabledOnAllTextFields(rs.masterSafetyState != SafetyMode.RECOVERY);
            MoveJointsSelfTestPanel.this.jointPaintStrategy.paintJointLimits(rs.reducedModeActive, true);
            MoveJointsSelfTestPanel.this.jointPaintStrategy.setPositionsValues(jointPositionVector);
            if (this.performUpdateOfTextField) {
                MoveJointsSelfTestPanel.this.jointPaintStrategy.paintJointText(jointPositionVector, rs.reducedModeActive);
            }
        }
    }
}

