/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.HashCodeUtil;
import java.util.logging.Logger;
import javax.media.j3d.MasterControl;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.GMatrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;

public class Transform3D {
    private static final Logger LOG = Logger.getLogger(Transform3D.class.getName());
    double[] mat = new double[16];
    double[] rot = null;
    double[] scales = null;
    private int type = 0;
    private static final int AFFINE_BIT = 1;
    private static final int ORTHO_BIT = 2;
    private static final int CONGRUENT_BIT = 4;
    private static final int RIGID_BIT = 8;
    private static final int CLASSIFY_BIT = 16;
    private static final int SCALE_BIT = 32;
    private static final int ROTATION_BIT = 64;
    private static final int SVD_BIT = 128;
    private static final int CLASSIFY_ALL_DIRTY = 31;
    private static final int ROTSCALESVD_DIRTY = 224;
    private static final int ALL_DIRTY = 255;
    private int dirtyBits;
    boolean autoNormalize = false;
    private static final double EPS = 1.110223024E-16;
    static final double EPSILON = 1.0E-10;
    static final double EPSILON_ABSOLUTE = 1.0E-5;
    static final double EPSILON_RELATIVE = 1.0E-4;
    public static final int ZERO = 1;
    public static final int IDENTITY = 2;
    public static final int SCALE = 4;
    public static final int TRANSLATION = 8;
    public static final int ORTHOGONAL = 16;
    public static final int RIGID = 32;
    public static final int CONGRUENT = 64;
    public static final int AFFINE = 128;
    public static final int NEGATIVE_DETERMINANT = 256;
    private static final int ORTHO = 0x40000000;

    public Transform3D(Matrix4f var1) {
        this.set(var1);
    }

    public Transform3D(Matrix4d var1) {
        this.set(var1);
    }

    public Transform3D(Transform3D var1) {
        this.set(var1);
    }

    public Transform3D() {
        this.setIdentity();
    }

    public Transform3D(float[] var1) {
        this.set(var1);
    }

    public Transform3D(double[] var1) {
        this.set(var1);
    }

    public Transform3D(Quat4d var1, Vector3d var2, double var3) {
        this.set(var1, var2, var3);
    }

    public Transform3D(Quat4f var1, Vector3d var2, double var3) {
        this.set(var1, var2, var3);
    }

    public Transform3D(Quat4f var1, Vector3f var2, float var3) {
        this.set(var1, var2, var3);
    }

    public Transform3D(GMatrix var1) {
        this.set(var1);
    }

    public Transform3D(Matrix3f var1, Vector3d var2, double var3) {
        this.set(var1, var2, var3);
    }

    public Transform3D(Matrix3d var1, Vector3d var2, double var3) {
        this.set(var1, var2, var3);
    }

    public Transform3D(Matrix3f var1, Vector3f var2, float var3) {
        this.set(var1, var2, var3);
    }

    public final int getType() {
        if ((this.dirtyBits & 0x10) != 0) {
            this.classify();
        }
        return this.type & 0xBFFFFFFF;
    }

    final boolean isOrtho() {
        if ((this.dirtyBits & 2) != 0) {
            if (Transform3D.almostZero(this.mat[0] * this.mat[2] + this.mat[4] * this.mat[6] + this.mat[8] * this.mat[10]) && Transform3D.almostZero(this.mat[0] * this.mat[1] + this.mat[4] * this.mat[5] + this.mat[8] * this.mat[9]) && Transform3D.almostZero(this.mat[1] * this.mat[2] + this.mat[5] * this.mat[6] + this.mat[9] * this.mat[10])) {
                this.type |= 0x40000000;
                this.dirtyBits &= 0xFFFFFFFD;
                return true;
            }
            this.type &= 0xBFFFFFFF;
            this.dirtyBits &= 0xFFFFFFFD;
            return false;
        }
        return (this.type & 0x40000000) != 0;
    }

    final boolean isCongruent() {
        if ((this.dirtyBits & 4) != 0) {
            this.classifyRigid();
        }
        return (this.type & 0x40) != 0;
    }

    final boolean isAffine() {
        if ((this.dirtyBits & 1) != 0) {
            this.classifyAffine();
        }
        return (this.type & 0x80) != 0;
    }

    final boolean isRigid() {
        if ((this.dirtyBits & 8) != 0) {
            if ((this.dirtyBits & 4) != 0) {
                this.classifyRigid();
            } else {
                if ((this.type & 0x40) != 0) {
                    double var1;
                    if ((this.dirtyBits & 0x20) != 0) {
                        var1 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                    } else {
                        if (this.scales == null) {
                            this.scales = new double[3];
                        }
                        var1 = this.scales[0];
                    }
                    this.type = Transform3D.almostOne(var1) ? (this.type |= 0x20) : (this.type &= 0xFFFFFFDF);
                } else {
                    this.type &= 0xFFFFFFDF;
                }
                this.dirtyBits &= 0xFFFFFFF7;
            }
        }
        return (this.type & 0x20) != 0;
    }

    public final int getBestType() {
        this.getType();
        if ((this.type & 1) != 0) {
            return 1;
        }
        if ((this.type & 2) != 0) {
            return 2;
        }
        if ((this.type & 4) != 0) {
            return 4;
        }
        if ((this.type & 8) != 0) {
            return 8;
        }
        if ((this.type & 0x10) != 0) {
            return 16;
        }
        if ((this.type & 0x20) != 0) {
            return 32;
        }
        if ((this.type & 0x40) != 0) {
            return 64;
        }
        if ((this.type & 0x80) != 0) {
            return 128;
        }
        return (this.type & 0x100) != 0 ? 256 : 0;
    }

    public final boolean getDeterminantSign() {
        double var1 = this.determinant();
        if (Double.isNaN(var1)) {
            return true;
        }
        return var1 >= 0.0;
    }

    public final void setAutoNormalize(boolean var1) {
        this.autoNormalize = var1;
        if (var1) {
            this.normalize();
        }
    }

    public final boolean getAutoNormalize() {
        return this.autoNormalize;
    }

    void transform(Point3d var1, Point4d var2) {
        var2.x = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z + this.mat[3];
        var2.y = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z + this.mat[7];
        var2.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z + this.mat[11];
        var2.w = this.mat[12] * var1.x + this.mat[13] * var1.y + this.mat[14] * var1.z + this.mat[15];
    }

    private static final boolean almostZero(double var0) {
        return var0 < 1.0E-5 && var0 > -1.0E-5;
    }

    private static final boolean almostOne(double var0) {
        return var0 < 1.00001 && var0 > 0.99999;
    }

    private static final boolean almostEqual(double var0, double var2) {
        double var4 = var0 - var2;
        if (var4 >= 0.0) {
            if (var4 < 1.0E-10) {
                return true;
            }
            if (!(var2 > 0.0) && !(var0 > -var2)) {
                return var4 < -1.0E-4 * var2;
            }
            return var4 < 1.0E-4 * var0;
        }
        if (var4 > -1.0E-10) {
            return true;
        }
        if (!(var2 < 0.0) && !(-var0 > var2)) {
            return var4 > -1.0E-4 * var2;
        }
        return var4 > 1.0E-4 * var0;
    }

    private final void classifyAffine() {
        this.type = !this.isInfOrNaN() && Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostOne(this.mat[15]) ? (this.type |= 0x80) : (this.type &= 0xFFFFFF7F);
        this.dirtyBits &= 0xFFFFFFFE;
    }

    private final void classifyRigid() {
        if ((this.dirtyBits & 1) != 0) {
            this.type &= 0x40000000;
            this.classifyAffine();
        } else {
            this.type &= 0x40000080;
        }
        if ((this.type & 0x80) != 0 && this.isOrtho()) {
            if ((this.dirtyBits & 0x20) != 0) {
                double var5;
                double var1 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                double var3 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
                if (Transform3D.almostEqual(var1, var3) && Transform3D.almostEqual(var5 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10], var1)) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(var1)) {
                        this.type |= 0x20;
                    }
                }
            } else {
                double var7;
                if (this.scales == null) {
                    this.scales = new double[3];
                }
                if (Transform3D.almostEqual(var7 = this.scales[0], this.scales[1]) && Transform3D.almostEqual(var7, this.scales[2])) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(var7)) {
                        this.type |= 0x20;
                    }
                }
            }
        }
        this.dirtyBits &= 0xFFFFFFFF;
    }

    private final void classify() {
        if ((this.dirtyBits & 0xD) != 0) {
            this.classifyRigid();
        }
        if ((this.type & 0x80) != 0) {
            if ((this.type & 0x40) != 0) {
                if ((this.type & 0x20) != 0) {
                    if (this.zeroTranslation()) {
                        this.type |= 0x10;
                        if (this.rotateZero() && this.mat[0] > 0.0 && this.mat[5] > 0.0 && this.mat[10] > 0.0) {
                            this.type |= 0xE;
                        }
                    } else if (this.rotateZero()) {
                        this.type |= 8;
                    }
                } else if (this.zeroTranslation() && this.rotateZero()) {
                    this.type |= 4;
                }
            }
        } else if (Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostZero(this.mat[15]) && this.zeroTranslation() && this.rotateZero() && Transform3D.almostZero(this.mat[0]) && Transform3D.almostZero(this.mat[5]) && Transform3D.almostZero(this.mat[10])) {
            this.type |= 1;
        }
        if (!this.getDeterminantSign()) {
            this.type |= 0x100;
        }
        this.dirtyBits &= 0xFFFFFFEF;
    }

    final boolean zeroTranslation() {
        return Transform3D.almostZero(this.mat[3]) && Transform3D.almostZero(this.mat[7]) && Transform3D.almostZero(this.mat[11]);
    }

    final boolean rotateZero() {
        return Transform3D.almostZero(this.mat[1]) && Transform3D.almostZero(this.mat[2]) && Transform3D.almostZero(this.mat[4]) && Transform3D.almostZero(this.mat[6]) && Transform3D.almostZero(this.mat[8]) && Transform3D.almostZero(this.mat[9]);
    }

    public String toString() {
        return this.mat[0] + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15] + "\n";
    }

    public final void setIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 1073742078;
        this.dirtyBits = 96;
    }

    public final void setZero() {
        this.mat[0] = 0.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 0.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 0.0;
        this.type = 0x40000001;
        this.dirtyBits = 96;
    }

    public final void add(Transform3D var1) {
        for (int var2 = 0; var2 < 16; ++var2) {
            double[] var10000 = this.mat;
            int n = var2;
            var10000[n] = var10000[n] + var1.mat[var2];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void add(Transform3D var1, Transform3D var2) {
        for (int var3 = 0; var3 < 16; ++var3) {
            this.mat[var3] = var1.mat[var3] + var2.mat[var3];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D var1) {
        for (int var2 = 0; var2 < 16; ++var2) {
            double[] var10000 = this.mat;
            int n = var2;
            var10000[n] = var10000[n] - var1.mat[var2];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D var1, Transform3D var2) {
        for (int var3 = 0; var3 < 16; ++var3) {
            this.mat[var3] = var1.mat[var3] - var2.mat[var3];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose() {
        double var1 = this.mat[4];
        this.mat[4] = this.mat[1];
        this.mat[1] = var1;
        var1 = this.mat[8];
        this.mat[8] = this.mat[2];
        this.mat[2] = var1;
        var1 = this.mat[12];
        this.mat[12] = this.mat[3];
        this.mat[3] = var1;
        var1 = this.mat[9];
        this.mat[9] = this.mat[6];
        this.mat[6] = var1;
        var1 = this.mat[13];
        this.mat[13] = this.mat[7];
        this.mat[7] = var1;
        var1 = this.mat[14];
        this.mat[14] = this.mat[11];
        this.mat[11] = var1;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose(Transform3D var1) {
        if (this != var1) {
            this.mat[0] = var1.mat[0];
            this.mat[1] = var1.mat[4];
            this.mat[2] = var1.mat[8];
            this.mat[3] = var1.mat[12];
            this.mat[4] = var1.mat[1];
            this.mat[5] = var1.mat[5];
            this.mat[6] = var1.mat[9];
            this.mat[7] = var1.mat[13];
            this.mat[8] = var1.mat[2];
            this.mat[9] = var1.mat[6];
            this.mat[10] = var1.mat[10];
            this.mat[11] = var1.mat[14];
            this.mat[12] = var1.mat[3];
            this.mat[13] = var1.mat[7];
            this.mat[14] = var1.mat[11];
            this.mat[15] = var1.mat[15];
            this.dirtyBits = 255;
            if (this.autoNormalize) {
                this.normalize();
            }
        } else {
            this.transpose();
        }
    }

    public final void set(Quat4f var1) {
        this.mat[0] = 1.0f - 2.0f * var1.y * var1.y - 2.0f * var1.z * var1.z;
        this.mat[4] = 2.0f * (var1.x * var1.y + var1.w * var1.z);
        this.mat[8] = 2.0f * (var1.x * var1.z - var1.w * var1.y);
        this.mat[1] = 2.0f * (var1.x * var1.y - var1.w * var1.z);
        this.mat[5] = 1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.z * var1.z;
        this.mat[9] = 2.0f * (var1.y * var1.z + var1.w * var1.x);
        this.mat[2] = 2.0f * (var1.x * var1.z + var1.w * var1.y);
        this.mat[6] = 2.0f * (var1.y * var1.z - var1.w * var1.x);
        this.mat[10] = 1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.y * var1.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits = 112;
            this.type = 0x400000E0;
        }
    }

    public final void set(Quat4d var1) {
        this.mat[0] = 1.0 - 2.0 * var1.y * var1.y - 2.0 * var1.z * var1.z;
        this.mat[4] = 2.0 * (var1.x * var1.y + var1.w * var1.z);
        this.mat[8] = 2.0 * (var1.x * var1.z - var1.w * var1.y);
        this.mat[1] = 2.0 * (var1.x * var1.y - var1.w * var1.z);
        this.mat[5] = 1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.z * var1.z;
        this.mat[9] = 2.0 * (var1.y * var1.z + var1.w * var1.x);
        this.mat[2] = 2.0 * (var1.x * var1.z + var1.w * var1.y);
        this.mat[6] = 2.0 * (var1.y * var1.z - var1.w * var1.x);
        this.mat[10] = 1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.y * var1.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits = 112;
            this.type = 0x400000E0;
        }
    }

    public final void setRotation(Matrix3d var1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = var1.m00 * this.scales[0];
        this.mat[1] = var1.m01 * this.scales[1];
        this.mat[2] = var1.m02 * this.scales[2];
        this.mat[4] = var1.m10 * this.scales[0];
        this.mat[5] = var1.m11 * this.scales[1];
        this.mat[6] = var1.m12 * this.scales[2];
        this.mat[8] = var1.m20 * this.scales[0];
        this.mat[9] = var1.m21 * this.scales[1];
        this.mat[10] = var1.m22 * this.scales[2];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Matrix3f var1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (double)var1.m00 * this.scales[0];
        this.mat[1] = (double)var1.m01 * this.scales[1];
        this.mat[2] = (double)var1.m02 * this.scales[2];
        this.mat[4] = (double)var1.m10 * this.scales[0];
        this.mat[5] = (double)var1.m11 * this.scales[1];
        this.mat[6] = (double)var1.m12 * this.scales[2];
        this.mat[8] = (double)var1.m20 * this.scales[0];
        this.mat[9] = (double)var1.m21 * this.scales[1];
        this.mat[10] = (double)var1.m22 * this.scales[2];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Quat4f var1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * (double)var1.y * (double)var1.y - 2.0 * (double)var1.z * (double)var1.z) * this.scales[0];
        this.mat[4] = 2.0 * (double)(var1.x * var1.y + var1.w * var1.z) * this.scales[0];
        this.mat[8] = 2.0 * (double)(var1.x * var1.z - var1.w * var1.y) * this.scales[0];
        this.mat[1] = 2.0 * (double)(var1.x * var1.y - var1.w * var1.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * (double)var1.x * (double)var1.x - 2.0 * (double)var1.z * (double)var1.z) * this.scales[1];
        this.mat[9] = 2.0 * (double)(var1.y * var1.z + var1.w * var1.x) * this.scales[1];
        this.mat[2] = 2.0 * (double)(var1.x * var1.z + var1.w * var1.y) * this.scales[2];
        this.mat[6] = 2.0 * (double)(var1.y * var1.z - var1.w * var1.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * (double)var1.x * (double)var1.x - 2.0 * (double)var1.y * (double)var1.y) * this.scales[2];
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x50;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
            this.type &= 0xFFFFFFE0;
        }
    }

    public final void setRotation(Quat4d var1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * var1.y * var1.y - 2.0 * var1.z * var1.z) * this.scales[0];
        this.mat[4] = 2.0 * (var1.x * var1.y + var1.w * var1.z) * this.scales[0];
        this.mat[8] = 2.0 * (var1.x * var1.z - var1.w * var1.y) * this.scales[0];
        this.mat[1] = 2.0 * (var1.x * var1.y - var1.w * var1.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.z * var1.z) * this.scales[1];
        this.mat[9] = 2.0 * (var1.y * var1.z + var1.w * var1.x) * this.scales[1];
        this.mat[2] = 2.0 * (var1.x * var1.z + var1.w * var1.y) * this.scales[2];
        this.mat[6] = 2.0 * (var1.y * var1.z - var1.w * var1.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.y * var1.y) * this.scales[2];
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x50;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
            this.type &= 0xFFFFFFE0;
        }
    }

    public final void set(AxisAngle4f var1) {
        double var2 = Math.sqrt(var1.x * var1.x + var1.y * var1.y + var1.z * var1.z);
        if (Transform3D.almostZero(var2)) {
            this.setIdentity();
        } else {
            var2 = 1.0 / var2;
            double var4 = (double)var1.x * var2;
            double var6 = (double)var1.y * var2;
            double var8 = (double)var1.z * var2;
            double var10 = Math.sin(var1.angle);
            double var12 = Math.cos(var1.angle);
            double var14 = 1.0 - var12;
            double var16 = var4 * var8;
            double var18 = var4 * var6;
            double var20 = var6 * var8;
            this.mat[0] = var14 * var4 * var4 + var12;
            this.mat[1] = var14 * var18 - var10 * var8;
            this.mat[2] = var14 * var16 + var10 * var6;
            this.mat[3] = 0.0;
            this.mat[4] = var14 * var18 + var10 * var8;
            this.mat[5] = var14 * var6 * var6 + var12;
            this.mat[6] = var14 * var20 - var10 * var4;
            this.mat[7] = 0.0;
            this.mat[8] = var14 * var16 - var10 * var6;
            this.mat[9] = var14 * var20 + var10 * var4;
            this.mat[10] = var14 * var8 * var8 + var12;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            if (this.isInfOrNaN(var1)) {
                this.dirtyBits = 255;
                return;
            }
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void set(AxisAngle4d var1) {
        double var2 = Math.sqrt(var1.x * var1.x + var1.y * var1.y + var1.z * var1.z);
        if (Transform3D.almostZero(var2)) {
            this.setIdentity();
        } else {
            var2 = 1.0 / var2;
            double var4 = var1.x * var2;
            double var6 = var1.y * var2;
            double var8 = var1.z * var2;
            double var10 = Math.sin(var1.angle);
            double var12 = Math.cos(var1.angle);
            double var14 = 1.0 - var12;
            double var16 = var4 * var8;
            double var18 = var4 * var6;
            double var20 = var6 * var8;
            this.mat[0] = var14 * var4 * var4 + var12;
            this.mat[1] = var14 * var18 - var10 * var8;
            this.mat[2] = var14 * var16 + var10 * var6;
            this.mat[3] = 0.0;
            this.mat[4] = var14 * var18 + var10 * var8;
            this.mat[5] = var14 * var6 * var6 + var12;
            this.mat[6] = var14 * var20 - var10 * var4;
            this.mat[7] = 0.0;
            this.mat[8] = var14 * var16 - var10 * var6;
            this.mat[9] = var14 * var20 + var10 * var4;
            this.mat[10] = var14 * var8 * var8 + var12;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            if (this.isInfOrNaN(var1)) {
                this.dirtyBits = 255;
                return;
            }
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setRotation(AxisAngle4d var1) {
        double var2;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(var2 = Math.sqrt(var1.x * var1.x + var1.y * var1.y + var1.z * var1.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            var2 = 1.0 / var2;
            double var4 = var1.x * var2;
            double var6 = var1.y * var2;
            double var8 = var1.z * var2;
            double var10 = Math.sin(var1.angle);
            double var12 = Math.cos(var1.angle);
            double var14 = 1.0 - var12;
            double var16 = var4 * var8;
            double var18 = var4 * var6;
            double var20 = var6 * var8;
            this.mat[0] = (var14 * var4 * var4 + var12) * this.scales[0];
            this.mat[1] = (var14 * var18 - var10 * var8) * this.scales[1];
            this.mat[2] = (var14 * var16 + var10 * var6) * this.scales[2];
            this.mat[4] = (var14 * var18 + var10 * var8) * this.scales[0];
            this.mat[5] = (var14 * var6 * var6 + var12) * this.scales[1];
            this.mat[6] = (var14 * var20 - var10 * var4) * this.scales[2];
            this.mat[8] = (var14 * var16 - var10 * var6) * this.scales[0];
            this.mat[9] = (var14 * var20 + var10 * var4) * this.scales[1];
            this.mat[10] = (var14 * var8 * var8 + var12) * this.scales[2];
        }
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x50;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
            this.type &= 0xFFFFFFE0;
        }
    }

    public final void setRotation(AxisAngle4f var1) {
        double var2;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(var2 = Math.sqrt(var1.x * var1.x + var1.y * var1.y + var1.z * var1.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            var2 = 1.0 / var2;
            double var4 = (double)var1.x * var2;
            double var6 = (double)var1.y * var2;
            double var8 = (double)var1.z * var2;
            double var10 = Math.sin(var1.angle);
            double var12 = Math.cos(var1.angle);
            double var14 = 1.0 - var12;
            double var16 = var4 * var8;
            double var18 = var4 * var6;
            double var20 = var6 * var8;
            this.mat[0] = (var14 * var4 * var4 + var12) * this.scales[0];
            this.mat[1] = (var14 * var18 - var10 * var8) * this.scales[1];
            this.mat[2] = (var14 * var16 + var10 * var6) * this.scales[2];
            this.mat[4] = (var14 * var18 + var10 * var8) * this.scales[0];
            this.mat[5] = (var14 * var6 * var6 + var12) * this.scales[1];
            this.mat[6] = (var14 * var20 - var10 * var4) * this.scales[2];
            this.mat[8] = (var14 * var16 - var10 * var6) * this.scales[0];
            this.mat[9] = (var14 * var20 + var10 * var4) * this.scales[1];
            this.mat[10] = (var14 * var8 * var8 + var12) * this.scales[2];
        }
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x50;
            this.dirtyBits &= 0xFFFFFFFF;
            this.type |= 0x40000000;
            this.type &= 0xFFFFFFE0;
        }
    }

    public void rotX(double var1) {
        double var3 = Math.sin(var1);
        double var5 = Math.cos(var1);
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = var5;
        this.mat[6] = -var3;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = var3;
        this.mat[10] = var5;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public void rotY(double var1) {
        double var5;
        double var3 = Math.sin(var1);
        this.mat[0] = var5 = Math.cos(var1);
        this.mat[1] = 0.0;
        this.mat[2] = var3;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = -var3;
        this.mat[9] = 0.0;
        this.mat[10] = var5;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public void rotZ(double var1) {
        double var5;
        double var3 = Math.sin(var1);
        this.mat[0] = var5 = Math.cos(var1);
        this.mat[1] = -var3;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = var3;
        this.mat[5] = var5;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void set(Vector3f var1) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = var1.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = var1.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = var1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void set(Vector3d var1) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = var1.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = var1.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = var1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setScale(double var1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[1] = this.scales[2] = var1;
        this.scales[0] = this.scales[2];
        this.mat[0] = this.rot[0] * var1;
        this.mat[1] = this.rot[1] * var1;
        this.mat[2] = this.rot[2] * var1;
        this.mat[4] = this.rot[3] * var1;
        this.mat[5] = this.rot[4] * var1;
        this.mat[6] = this.rot[5] * var1;
        this.mat[8] = this.rot[6] * var1;
        this.mat[9] = this.rot[7] * var1;
        this.mat[10] = this.rot[8] * var1;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x9C;
            this.dirtyBits &= 0xFFFFFFDF;
        }
    }

    public final void setScale(Vector3d var1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[0] = var1.x;
        this.scales[1] = var1.y;
        this.scales[2] = var1.z;
        this.mat[0] = this.rot[0] * var1.x;
        this.mat[1] = this.rot[1] * var1.y;
        this.mat[2] = this.rot[2] * var1.z;
        this.mat[4] = this.rot[3] * var1.x;
        this.mat[5] = this.rot[4] * var1.y;
        this.mat[6] = this.rot[5] * var1.z;
        this.mat[8] = this.rot[6] * var1.x;
        this.mat[9] = this.rot[7] * var1.y;
        this.mat[10] = this.rot[8] * var1.z;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.dirtyBits |= 0x9C;
            this.dirtyBits &= 0xFFFFFFDF;
        }
    }

    public final void setNonUniformScale(double var1, double var3, double var5) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[0] = var1;
        this.scales[1] = var3;
        this.scales[2] = var5;
        this.mat[0] = var1;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = var3;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = var5;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void setTranslation(Vector3f var1) {
        this.mat[3] = var1.x;
        this.mat[7] = var1.y;
        this.mat[11] = var1.z;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type &= 0xFFFFFFE0;
            this.dirtyBits |= 0x10;
        }
    }

    public final void setTranslation(Vector3d var1) {
        this.mat[3] = var1.x;
        this.mat[7] = var1.y;
        this.mat[11] = var1.z;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type &= 0xFFFFFFE0;
            this.dirtyBits |= 0x10;
        }
    }

    public final void set(Quat4d var1, Vector3d var2, double var3) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = var3;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0 - 2.0 * var1.y * var1.y - 2.0 * var1.z * var1.z) * var3;
        this.mat[4] = 2.0 * (var1.x * var1.y + var1.w * var1.z) * var3;
        this.mat[8] = 2.0 * (var1.x * var1.z - var1.w * var1.y) * var3;
        this.mat[1] = 2.0 * (var1.x * var1.y - var1.w * var1.z) * var3;
        this.mat[5] = (1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.z * var1.z) * var3;
        this.mat[9] = 2.0 * (var1.y * var1.z + var1.w * var1.x) * var3;
        this.mat[2] = 2.0 * (var1.x * var1.z + var1.w * var1.y) * var3;
        this.mat[6] = 2.0 * (var1.y * var1.z - var1.w * var1.x) * var3;
        this.mat[10] = (1.0 - 2.0 * var1.x * var1.x - 2.0 * var1.y * var1.y) * var3;
        this.mat[3] = var2.x;
        this.mat[7] = var2.y;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Quat4f var1, Vector3d var2, double var3) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = var3;
        this.scales[0] = this.scales[2];
        this.mat[0] = (double)(1.0f - 2.0f * var1.y * var1.y - 2.0f * var1.z * var1.z) * var3;
        this.mat[4] = (double)(2.0f * (var1.x * var1.y + var1.w * var1.z)) * var3;
        this.mat[8] = (double)(2.0f * (var1.x * var1.z - var1.w * var1.y)) * var3;
        this.mat[1] = (double)(2.0f * (var1.x * var1.y - var1.w * var1.z)) * var3;
        this.mat[5] = (double)(1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.z * var1.z) * var3;
        this.mat[9] = (double)(2.0f * (var1.y * var1.z + var1.w * var1.x)) * var3;
        this.mat[2] = (double)(2.0f * (var1.x * var1.z + var1.w * var1.y)) * var3;
        this.mat[6] = (double)(2.0f * (var1.y * var1.z - var1.w * var1.x)) * var3;
        this.mat[10] = (double)(1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.y * var1.y) * var3;
        this.mat[3] = var2.x;
        this.mat[7] = var2.y;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Quat4f var1, Vector3f var2, float var3) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = (double)var3;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0f - 2.0f * var1.y * var1.y - 2.0f * var1.z * var1.z) * var3;
        this.mat[4] = 2.0f * (var1.x * var1.y + var1.w * var1.z) * var3;
        this.mat[8] = 2.0f * (var1.x * var1.z - var1.w * var1.y) * var3;
        this.mat[1] = 2.0f * (var1.x * var1.y - var1.w * var1.z) * var3;
        this.mat[5] = (1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.z * var1.z) * var3;
        this.mat[9] = 2.0f * (var1.y * var1.z + var1.w * var1.x) * var3;
        this.mat[2] = 2.0f * (var1.x * var1.z + var1.w * var1.y) * var3;
        this.mat[6] = 2.0f * (var1.y * var1.z - var1.w * var1.x) * var3;
        this.mat[10] = (1.0f - 2.0f * var1.x * var1.x - 2.0f * var1.y * var1.y) * var3;
        this.mat[3] = var2.x;
        this.mat[7] = var2.y;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Matrix3f var1, Vector3f var2, float var3) {
        this.mat[0] = var1.m00 * var3;
        this.mat[1] = var1.m01 * var3;
        this.mat[2] = var1.m02 * var3;
        this.mat[3] = var2.x;
        this.mat[4] = var1.m10 * var3;
        this.mat[5] = var1.m11 * var3;
        this.mat[6] = var1.m12 * var3;
        this.mat[7] = var2.y;
        this.mat[8] = var1.m20 * var3;
        this.mat[9] = var1.m21 * var3;
        this.mat[10] = var1.m22 * var3;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f var1, Vector3d var2, double var3) {
        this.mat[0] = (double)var1.m00 * var3;
        this.mat[1] = (double)var1.m01 * var3;
        this.mat[2] = (double)var1.m02 * var3;
        this.mat[3] = var2.x;
        this.mat[4] = (double)var1.m10 * var3;
        this.mat[5] = (double)var1.m11 * var3;
        this.mat[6] = (double)var1.m12 * var3;
        this.mat[7] = var2.y;
        this.mat[8] = (double)var1.m20 * var3;
        this.mat[9] = (double)var1.m21 * var3;
        this.mat[10] = (double)var1.m22 * var3;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d var1, Vector3d var2, double var3) {
        this.mat[0] = var1.m00 * var3;
        this.mat[1] = var1.m01 * var3;
        this.mat[2] = var1.m02 * var3;
        this.mat[3] = var2.x;
        this.mat[4] = var1.m10 * var3;
        this.mat[5] = var1.m11 * var3;
        this.mat[6] = var1.m12 * var3;
        this.mat[7] = var2.y;
        this.mat[8] = var1.m20 * var3;
        this.mat[9] = var1.m21 * var3;
        this.mat[10] = var1.m22 * var3;
        this.mat[11] = var2.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(GMatrix var1) {
        int var5 = var1.getNumRow();
        int var6 = var1.getNumCol();
        for (int var2 = 0; var2 < 4; ++var2) {
            int var4 = var2 * 4;
            for (int var3 = 0; var3 < 4; ++var3) {
                this.mat[var4 + var3] = var2 < var5 && var3 < var6 ? var1.getElement(var2, var3) : 0.0;
            }
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Transform3D var1) {
        this.mat[0] = var1.mat[0];
        this.mat[1] = var1.mat[1];
        this.mat[2] = var1.mat[2];
        this.mat[3] = var1.mat[3];
        this.mat[4] = var1.mat[4];
        this.mat[5] = var1.mat[5];
        this.mat[6] = var1.mat[6];
        this.mat[7] = var1.mat[7];
        this.mat[8] = var1.mat[8];
        this.mat[9] = var1.mat[9];
        this.mat[10] = var1.mat[10];
        this.mat[11] = var1.mat[11];
        this.mat[12] = var1.mat[12];
        this.mat[13] = var1.mat[13];
        this.mat[14] = var1.mat[14];
        this.mat[15] = var1.mat[15];
        this.type = var1.type;
        this.dirtyBits = var1.dirtyBits | 0x40 | 0x20;
        this.autoNormalize = var1.autoNormalize;
    }

    synchronized void setWithLock(Transform3D var1) {
        this.set(var1);
    }

    synchronized void getWithLock(Transform3D var1) {
        var1.set(this);
    }

    public final void set(double[] var1) {
        this.mat[0] = var1[0];
        this.mat[1] = var1[1];
        this.mat[2] = var1[2];
        this.mat[3] = var1[3];
        this.mat[4] = var1[4];
        this.mat[5] = var1[5];
        this.mat[6] = var1[6];
        this.mat[7] = var1[7];
        this.mat[8] = var1[8];
        this.mat[9] = var1[9];
        this.mat[10] = var1[10];
        this.mat[11] = var1[11];
        this.mat[12] = var1[12];
        this.mat[13] = var1[13];
        this.mat[14] = var1[14];
        this.mat[15] = var1[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(float[] var1) {
        this.mat[0] = var1[0];
        this.mat[1] = var1[1];
        this.mat[2] = var1[2];
        this.mat[3] = var1[3];
        this.mat[4] = var1[4];
        this.mat[5] = var1[5];
        this.mat[6] = var1[6];
        this.mat[7] = var1[7];
        this.mat[8] = var1[8];
        this.mat[9] = var1[9];
        this.mat[10] = var1[10];
        this.mat[11] = var1[11];
        this.mat[12] = var1[12];
        this.mat[13] = var1[13];
        this.mat[14] = var1[14];
        this.mat[15] = var1[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4d var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[3] = var1.m03;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[7] = var1.m13;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.mat[11] = var1.m23;
        this.mat[12] = var1.m30;
        this.mat[13] = var1.m31;
        this.mat[14] = var1.m32;
        this.mat[15] = var1.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4f var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[3] = var1.m03;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[7] = var1.m13;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.mat[11] = var1.m23;
        this.mat[12] = var1.m30;
        this.mat[13] = var1.m31;
        this.mat[14] = var1.m32;
        this.mat[15] = var1.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[3] = 0.0;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[7] = 0.0;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[3] = 0.0;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[7] = 0.0;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setEuler(Vector3d var1) {
        double var2 = Math.sin(var1.x);
        double var4 = Math.sin(var1.y);
        double var6 = Math.sin(var1.z);
        double var8 = Math.cos(var1.x);
        double var10 = Math.cos(var1.y);
        double var12 = Math.cos(var1.z);
        this.mat[0] = var10 * var12;
        this.mat[1] = -(var8 * var6) + var2 * var4 * var12;
        this.mat[2] = var2 * var6 + var8 * var4 * var12;
        this.mat[3] = 0.0;
        this.mat[4] = var10 * var6;
        this.mat[5] = var8 * var12 + var2 * var4 * var6;
        this.mat[6] = -(var2 * var12) + var8 * var4 * var6;
        this.mat[7] = 0.0;
        this.mat[8] = -var4;
        this.mat[9] = var2 * var10;
        this.mat[10] = var8 * var10;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(var1)) {
            this.dirtyBits = 255;
        } else {
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void get(double[] var1) {
        var1[0] = this.mat[0];
        var1[1] = this.mat[1];
        var1[2] = this.mat[2];
        var1[3] = this.mat[3];
        var1[4] = this.mat[4];
        var1[5] = this.mat[5];
        var1[6] = this.mat[6];
        var1[7] = this.mat[7];
        var1[8] = this.mat[8];
        var1[9] = this.mat[9];
        var1[10] = this.mat[10];
        var1[11] = this.mat[11];
        var1[12] = this.mat[12];
        var1[13] = this.mat[13];
        var1[14] = this.mat[14];
        var1[15] = this.mat[15];
    }

    public final void get(float[] var1) {
        var1[0] = (float)this.mat[0];
        var1[1] = (float)this.mat[1];
        var1[2] = (float)this.mat[2];
        var1[3] = (float)this.mat[3];
        var1[4] = (float)this.mat[4];
        var1[5] = (float)this.mat[5];
        var1[6] = (float)this.mat[6];
        var1[7] = (float)this.mat[7];
        var1[8] = (float)this.mat[8];
        var1[9] = (float)this.mat[9];
        var1[10] = (float)this.mat[10];
        var1[11] = (float)this.mat[11];
        var1[12] = (float)this.mat[12];
        var1[13] = (float)this.mat[13];
        var1[14] = (float)this.mat[14];
        var1[15] = (float)this.mat[15];
    }

    public final void get(Matrix3d var1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        var1.m00 = this.rot[0];
        var1.m01 = this.rot[1];
        var1.m02 = this.rot[2];
        var1.m10 = this.rot[3];
        var1.m11 = this.rot[4];
        var1.m12 = this.rot[5];
        var1.m20 = this.rot[6];
        var1.m21 = this.rot[7];
        var1.m22 = this.rot[8];
    }

    public final void get(Matrix3f var1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        var1.m00 = (float)this.rot[0];
        var1.m01 = (float)this.rot[1];
        var1.m02 = (float)this.rot[2];
        var1.m10 = (float)this.rot[3];
        var1.m11 = (float)this.rot[4];
        var1.m12 = (float)this.rot[5];
        var1.m20 = (float)this.rot[6];
        var1.m21 = (float)this.rot[7];
        var1.m22 = (float)this.rot[8];
    }

    public final void get(Quat4f var1) {
        double var2;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((var2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -var2 : var2) < 1.0E-10)) {
            var1.w = (float)Math.sqrt(var2);
            var2 = 0.25 / (double)var1.w;
            var1.x = (float)((this.rot[7] - this.rot[5]) * var2);
            var1.y = (float)((this.rot[2] - this.rot[6]) * var2);
            var1.z = (float)((this.rot[3] - this.rot[1]) * var2);
        } else {
            var1.w = 0.0f;
            var2 = -0.5 * (this.rot[4] + this.rot[8]);
            if (!((var2 < 0.0 ? -var2 : var2) < 1.0E-10)) {
                var1.x = (float)Math.sqrt(var2);
                var2 = 0.5 / (double)var1.x;
                var1.y = (float)(this.rot[3] * var2);
                var1.z = (float)(this.rot[6] * var2);
            } else {
                var1.x = 0.0f;
                var2 = 0.5 * (1.0 - this.rot[8]);
                if (!((var2 < 0.0 ? -var2 : var2) < 1.0E-10)) {
                    var1.y = (float)Math.sqrt(var2);
                    var1.z = (float)(this.rot[7] / (2.0 * (double)var1.y));
                } else {
                    var1.y = 0.0f;
                    var1.z = 1.0f;
                }
            }
        }
    }

    public final void get(Quat4d var1) {
        double var2;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((var2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -var2 : var2) < 1.0E-10)) {
            var1.w = Math.sqrt(var2);
            var2 = 0.25 / var1.w;
            var1.x = (this.rot[7] - this.rot[5]) * var2;
            var1.y = (this.rot[2] - this.rot[6]) * var2;
            var1.z = (this.rot[3] - this.rot[1]) * var2;
        } else {
            var1.w = 0.0;
            var2 = -0.5 * (this.rot[4] + this.rot[8]);
            if (!((var2 < 0.0 ? -var2 : var2) < 1.0E-10)) {
                var1.x = Math.sqrt(var2);
                var2 = 0.5 / var1.x;
                var1.y = this.rot[3] * var2;
                var1.z = this.rot[6] * var2;
            } else {
                var1.x = 0.0;
                var2 = 0.5 * (1.0 - this.rot[8]);
                if (!((var2 < 0.0 ? -var2 : var2) < 1.0E-10)) {
                    var1.y = Math.sqrt(var2);
                    var1.z = this.rot[7] / (2.0 * var1.y);
                } else {
                    var1.y = 0.0;
                    var1.z = 1.0;
                }
            }
        }
    }

    public final void get(Matrix4d var1) {
        var1.m00 = this.mat[0];
        var1.m01 = this.mat[1];
        var1.m02 = this.mat[2];
        var1.m03 = this.mat[3];
        var1.m10 = this.mat[4];
        var1.m11 = this.mat[5];
        var1.m12 = this.mat[6];
        var1.m13 = this.mat[7];
        var1.m20 = this.mat[8];
        var1.m21 = this.mat[9];
        var1.m22 = this.mat[10];
        var1.m23 = this.mat[11];
        var1.m30 = this.mat[12];
        var1.m31 = this.mat[13];
        var1.m32 = this.mat[14];
        var1.m33 = this.mat[15];
    }

    public final void get(Matrix4f var1) {
        var1.m00 = (float)this.mat[0];
        var1.m01 = (float)this.mat[1];
        var1.m02 = (float)this.mat[2];
        var1.m03 = (float)this.mat[3];
        var1.m10 = (float)this.mat[4];
        var1.m11 = (float)this.mat[5];
        var1.m12 = (float)this.mat[6];
        var1.m13 = (float)this.mat[7];
        var1.m20 = (float)this.mat[8];
        var1.m21 = (float)this.mat[9];
        var1.m22 = (float)this.mat[10];
        var1.m23 = (float)this.mat[11];
        var1.m30 = (float)this.mat[12];
        var1.m31 = (float)this.mat[13];
        var1.m32 = (float)this.mat[14];
        var1.m33 = (float)this.mat[15];
    }

    public final double get(Quat4d var1, Vector3d var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        var2.x = this.mat[3];
        var2.y = this.mat[7];
        var2.z = this.mat[11];
        double var3 = Transform3D.max3(this.scales);
        double var5 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.w = Math.sqrt(var5);
            var5 = 0.25 / var1.w;
            var1.x = (this.rot[7] - this.rot[5]) * var5;
            var1.y = (this.rot[2] - this.rot[6]) * var5;
            var1.z = (this.rot[3] - this.rot[1]) * var5;
            return var3;
        }
        var1.w = 0.0;
        var5 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.x = Math.sqrt(var5);
            var5 = 0.5 / var1.x;
            var1.y = this.rot[3] * var5;
            var1.z = this.rot[6] * var5;
            return var3;
        }
        var1.x = 0.0;
        var5 = 0.5 * (1.0 - this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.y = Math.sqrt(var5);
            var1.z = this.rot[7] / (2.0 * var1.y);
            return var3;
        }
        var1.y = 0.0;
        var1.z = 1.0;
        return var3;
    }

    public final float get(Quat4f var1, Vector3f var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double var3 = Transform3D.max3(this.scales);
        var2.x = (float)this.mat[3];
        var2.y = (float)this.mat[7];
        var2.z = (float)this.mat[11];
        double var5 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.w = (float)Math.sqrt(var5);
            var5 = 0.25 / (double)var1.w;
            var1.x = (float)((this.rot[7] - this.rot[5]) * var5);
            var1.y = (float)((this.rot[2] - this.rot[6]) * var5);
            var1.z = (float)((this.rot[3] - this.rot[1]) * var5);
            return (float)var3;
        }
        var1.w = 0.0f;
        var5 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.x = (float)Math.sqrt(var5);
            var5 = 0.5 / (double)var1.x;
            var1.y = (float)(this.rot[3] * var5);
            var1.z = (float)(this.rot[6] * var5);
            return (float)var3;
        }
        var1.x = 0.0f;
        var5 = 0.5 * (1.0 - this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.y = (float)Math.sqrt(var5);
            var1.z = (float)(this.rot[7] / (2.0 * (double)var1.y));
            return (float)var3;
        }
        var1.y = 0.0f;
        var1.z = 1.0f;
        return (float)var3;
    }

    public final double get(Quat4f var1, Vector3d var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double var3 = Transform3D.max3(this.scales);
        var2.x = this.mat[3];
        var2.y = this.mat[7];
        var2.z = this.mat[11];
        double var5 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.w = (float)Math.sqrt(var5);
            var5 = 0.25 / (double)var1.w;
            var1.x = (float)((this.rot[7] - this.rot[5]) * var5);
            var1.y = (float)((this.rot[2] - this.rot[6]) * var5);
            var1.z = (float)((this.rot[3] - this.rot[1]) * var5);
            return var3;
        }
        var1.w = 0.0f;
        var5 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.x = (float)Math.sqrt(var5);
            var5 = 0.5 / (double)var1.x;
            var1.y = (float)(this.rot[3] * var5);
            var1.z = (float)(this.rot[6] * var5);
            return var3;
        }
        var1.x = 0.0f;
        var5 = 0.5 * (1.0 - this.rot[8]);
        if (!((var5 < 0.0 ? -var5 : var5) < 1.0E-10)) {
            var1.y = (float)Math.sqrt(var5);
            var1.z = (float)(this.rot[7] / (2.0 * (double)var1.y));
            return var3;
        }
        var1.y = 0.0f;
        var1.z = 1.0f;
        return var3;
    }

    public final double get(Matrix3d var1, Vector3d var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        var2.x = this.mat[3];
        var2.y = this.mat[7];
        var2.z = this.mat[11];
        var1.m00 = this.rot[0];
        var1.m01 = this.rot[1];
        var1.m02 = this.rot[2];
        var1.m10 = this.rot[3];
        var1.m11 = this.rot[4];
        var1.m12 = this.rot[5];
        var1.m20 = this.rot[6];
        var1.m21 = this.rot[7];
        var1.m22 = this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final float get(Matrix3f var1, Vector3f var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        var2.x = (float)this.mat[3];
        var2.y = (float)this.mat[7];
        var2.z = (float)this.mat[11];
        var1.m00 = (float)this.rot[0];
        var1.m01 = (float)this.rot[1];
        var1.m02 = (float)this.rot[2];
        var1.m10 = (float)this.rot[3];
        var1.m11 = (float)this.rot[4];
        var1.m12 = (float)this.rot[5];
        var1.m20 = (float)this.rot[6];
        var1.m21 = (float)this.rot[7];
        var1.m22 = (float)this.rot[8];
        return (float)Transform3D.max3(this.scales);
    }

    public final double get(Matrix3f var1, Vector3d var2) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        var2.x = this.mat[3];
        var2.y = this.mat[7];
        var2.z = this.mat[11];
        var1.m00 = (float)this.rot[0];
        var1.m01 = (float)this.rot[1];
        var1.m02 = (float)this.rot[2];
        var1.m10 = (float)this.rot[3];
        var1.m11 = (float)this.rot[4];
        var1.m12 = (float)this.rot[5];
        var1.m20 = (float)this.rot[6];
        var1.m21 = (float)this.rot[7];
        var1.m22 = (float)this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final double getScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        return Transform3D.max3(this.scales);
    }

    public final void getScale(Vector3d var1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        var1.x = this.scales[0];
        var1.y = this.scales[1];
        var1.z = this.scales[2];
    }

    public final void get(Vector3f var1) {
        var1.x = (float)this.mat[3];
        var1.y = (float)this.mat[7];
        var1.z = (float)this.mat[11];
    }

    public final void get(Vector3d var1) {
        var1.x = this.mat[3];
        var1.y = this.mat[7];
        var1.z = this.mat[11];
    }

    public final void invert(Transform3D var1) {
        if (var1 == this) {
            this.invert();
        } else if (var1.isAffine()) {
            this.invertAffine(var1);
        } else {
            this.invertGeneral(var1);
        }
    }

    public final void invert() {
        if (this.isAffine()) {
            this.invertAffine();
        } else {
            this.invertGeneral(this);
        }
    }

    final void invertAffine(Transform3D var1) {
        double var2 = var1.affineDeterminant();
        if (var2 == 0.0) {
            this.fallbackInverse(var1);
        } else {
            double var4 = (var1.mat[0] * var1.mat[0] + var1.mat[1] * var1.mat[1] + var1.mat[2] * var1.mat[2] + var1.mat[3] * var1.mat[3]) * (var1.mat[4] * var1.mat[4] + var1.mat[5] * var1.mat[5] + var1.mat[6] * var1.mat[6] + var1.mat[7] * var1.mat[7]) * (var1.mat[8] * var1.mat[8] + var1.mat[9] * var1.mat[9] + var1.mat[10] * var1.mat[10] + var1.mat[11] * var1.mat[11]);
            if (var2 * var2 < 1.110223024E-16 * var4) {
                this.invertGeneral(var1);
            } else {
                var4 = 1.0 / var2;
                this.mat[0] = (var1.mat[5] * var1.mat[10] - var1.mat[9] * var1.mat[6]) * var4;
                this.mat[1] = -(var1.mat[1] * var1.mat[10] - var1.mat[9] * var1.mat[2]) * var4;
                this.mat[2] = (var1.mat[1] * var1.mat[6] - var1.mat[5] * var1.mat[2]) * var4;
                this.mat[4] = -(var1.mat[4] * var1.mat[10] - var1.mat[8] * var1.mat[6]) * var4;
                this.mat[5] = (var1.mat[0] * var1.mat[10] - var1.mat[8] * var1.mat[2]) * var4;
                this.mat[6] = -(var1.mat[0] * var1.mat[6] - var1.mat[4] * var1.mat[2]) * var4;
                this.mat[8] = (var1.mat[4] * var1.mat[9] - var1.mat[8] * var1.mat[5]) * var4;
                this.mat[9] = -(var1.mat[0] * var1.mat[9] - var1.mat[8] * var1.mat[1]) * var4;
                this.mat[10] = (var1.mat[0] * var1.mat[5] - var1.mat[4] * var1.mat[1]) * var4;
                this.mat[3] = -(var1.mat[3] * this.mat[0] + var1.mat[7] * this.mat[1] + var1.mat[11] * this.mat[2]);
                this.mat[7] = -(var1.mat[3] * this.mat[4] + var1.mat[7] * this.mat[5] + var1.mat[11] * this.mat[6]);
                this.mat[11] = -(var1.mat[3] * this.mat[8] + var1.mat[7] * this.mat[9] + var1.mat[11] * this.mat[10]);
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                this.dirtyBits = var1.dirtyBits | 0xE0 | 0x10 | 2;
                this.type = var1.type;
            }
        }
    }

    private void fallbackInverse(Transform3D transform) {
        LOG.warning("Attempted to invert singular matrix, using fallback inverse method.");
        Matrix4d matrix = new Matrix4d();
        transform.get(matrix);
        Matrix3d rotation = new Matrix3d();
        matrix.getRotationScale(rotation);
        rotation.transpose();
        Vector3d translation = new Vector3d();
        matrix.get(translation);
        Vector3d newTranslation = new Vector3d();
        rotation.transform((Tuple3d)translation, (Tuple3d)newTranslation);
        newTranslation.negate();
        matrix.setRotationScale(rotation);
        matrix.setTranslation(newTranslation);
        transform.set(matrix);
    }

    final void invertAffine() {
        double var1 = this.affineDeterminant();
        if (var1 == 0.0) {
            this.fallbackInverse(this);
        } else {
            double var3 = (this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3]) * (this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7]) * (this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11]);
            if (var1 * var1 < 1.110223024E-16 * var3) {
                this.invertGeneral(this);
            } else {
                var3 = 1.0 / var1;
                double var5 = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * var3;
                double var7 = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * var3;
                double var9 = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * var3;
                double var11 = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * var3;
                double var13 = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * var3;
                double var15 = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * var3;
                double var17 = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * var3;
                double var19 = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * var3;
                double var21 = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * var3;
                double var23 = -(this.mat[3] * var5 + this.mat[7] * var7 + this.mat[11] * var9);
                double var25 = -(this.mat[3] * var11 + this.mat[7] * var13 + this.mat[11] * var15);
                this.mat[11] = -(this.mat[3] * var17 + this.mat[7] * var19 + this.mat[11] * var21);
                this.mat[0] = var5;
                this.mat[1] = var7;
                this.mat[2] = var9;
                this.mat[3] = var23;
                this.mat[4] = var11;
                this.mat[5] = var13;
                this.mat[6] = var15;
                this.mat[7] = var25;
                this.mat[8] = var17;
                this.mat[9] = var19;
                this.mat[10] = var21;
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                this.dirtyBits |= 0xF2;
            }
        }
    }

    final void invertGeneral(Transform3D var1) {
        double[] var2 = new double[16];
        int[] var3 = new int[4];
        System.arraycopy(var1.mat, 0, var2, 0, var2.length);
        if (!Transform3D.luDecomposition(var2, var3)) {
            this.fallbackInverse(var1);
        } else {
            this.mat[0] = 1.0;
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[3] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = 1.0;
            this.mat[6] = 0.0;
            this.mat[7] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = 1.0;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            Transform3D.luBacksubstitution(var2, var3, this.mat);
            this.type = 0;
            this.dirtyBits = 255;
        }
    }

    static boolean luDecomposition(double[] var0, int[] var1) {
        double[] var2 = new double[4];
        int var5 = 0;
        int var6 = 0;
        int var3 = 4;
        while (var3-- != 0) {
            double var7 = 0.0;
            int var4 = 4;
            while (var4-- != 0) {
                double var9 = var0[var5++];
                if (!((var9 = Math.abs(var9)) > var7)) continue;
                var7 = var9;
            }
            if (var7 == 0.0) {
                return false;
            }
            var2[var6++] = 1.0 / var7;
        }
        int var18 = 0;
        for (int var17 = 0; var17 < 4; ++var17) {
            for (int var19 = 0; var19 < var17; ++var19) {
                int var8 = var18 + 4 * var19 + var17;
                double var11 = var0[var8];
                int var23 = var19;
                int var29 = var18 + 4 * var19;
                int var10 = var18 + var17;
                while (var23-- != 0) {
                    var11 -= var0[var29] * var0[var10];
                    ++var29;
                    var10 += 4;
                }
                var0[var8] = var11;
            }
            double var13 = 0.0;
            var6 = -1;
            for (int var20 = var17; var20 < 4; ++var20) {
                double d;
                int var26 = var18 + 4 * var20 + var17;
                double var34 = var0[var26];
                int var24 = var17;
                int var30 = var18 + 4 * var20;
                int var32 = var18 + var17;
                while (var24-- != 0) {
                    var34 -= var0[var30] * var0[var32];
                    ++var30;
                    var32 += 4;
                }
                var0[var26] = var34;
                double var15 = var2[var20] * Math.abs(var34);
                if (!(d >= var13)) continue;
                var13 = var15;
                var6 = var20;
            }
            if (var6 < 0) {
                return false;
            }
            if (var17 != var6) {
                int var25 = 4;
                int var31 = var18 + 4 * var6;
                int var33 = var18 + 4 * var17;
                while (var25-- != 0) {
                    double var35 = var0[var31];
                    var0[var31++] = var0[var33];
                    var0[var33++] = var35;
                }
                var2[var6] = var2[var17];
            }
            var1[var17] = var6;
            if (var0[var18 + 4 * var17 + var17] == 0.0) {
                return false;
            }
            if (var17 == 3) continue;
            double var36 = 1.0 / var0[var18 + 4 * var17 + var17];
            int var27 = var18 + 4 * (var17 + 1) + var17;
            int var21 = 3 - var17;
            while (var21-- != 0) {
                int n = var27;
                var0[n] = var0[n] * var36;
                var27 += 4;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] var0, int[] var1, double[] var2) {
        int var8 = 0;
        for (int var7 = 0; var7 < 4; ++var7) {
            int var9 = var7;
            int var4 = -1;
            for (int var3 = 0; var3 < 4; ++var3) {
                int var5 = var1[var8 + var3];
                double var11 = var2[var9 + 4 * var5];
                var2[var9 + 4 * var5] = var2[var9 + 4 * var3];
                if (var4 >= 0) {
                    int var10 = var3 * 4;
                    for (int var6 = var4; var6 <= var3 - 1; ++var6) {
                        var11 -= var0[var10 + var6] * var2[var9 + 4 * var6];
                    }
                } else if (var11 != 0.0) {
                    var4 = var3;
                }
                var2[var9 + 4 * var3] = var11;
            }
            int var13 = 12;
            int n = var9 + 12;
            var2[n] = var2[n] / var0[var13 + 3];
            var2[var9 + 8] = (var2[var9 + 8] - var0[(var13 -= 4) + 3] * var2[var9 + 12]) / var0[var13 + 2];
            var2[var9 + 4] = (var2[var9 + 4] - var0[(var13 -= 4) + 2] * var2[var9 + 8] - var0[var13 + 3] * var2[var9 + 12]) / var0[var13 + 1];
            var2[var9 + 0] = (var2[var9 + 0] - var0[(var13 -= 4) + 1] * var2[var9 + 4] - var0[var13 + 2] * var2[var9 + 8] - var0[var13 + 3] * var2[var9 + 12]) / var0[var13 + 0];
        }
    }

    final double affineDeterminant() {
        return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
    }

    public final double determinant() {
        return this.isAffine() ? this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]) : this.mat[0] * (this.mat[5] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) + this.mat[7] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13])) - this.mat[1] * (this.mat[4] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12])) + this.mat[2] * (this.mat[4] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12])) - this.mat[3] * (this.mat[4] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12]) + this.mat[6] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12]));
    }

    public final void set(double var1) {
        this.setScaleTranslation(0.0, 0.0, 0.0, var1);
    }

    public final void set(double var1, Vector3d var3) {
        this.setScaleTranslation(var3.x, var3.y, var3.z, var1);
    }

    public final void set(float var1, Vector3f var2) {
        this.setScaleTranslation(var2.x, var2.y, var2.z, var1);
    }

    public final void set(Vector3d var1, double var2) {
        this.setScaleTranslation(var1.x * var2, var1.y * var2, var1.z * var2, var2);
    }

    public final void set(Vector3f var1, float var2) {
        this.setScaleTranslation(var1.x * var2, var1.y * var2, var1.z * var2, var2);
    }

    private final void setScaleTranslation(double var1, double var3, double var5, double var7) {
        this.mat[0] = var7;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = var1;
        this.mat[4] = 0.0;
        this.mat[5] = var7;
        this.mat[6] = 0.0;
        this.mat[7] = var3;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = var7;
        this.mat[11] = var5;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = var7;
        this.scales[0] = this.scales[2];
        if (!(this.isInfOrNaN(var1) || this.isInfOrNaN(var3) || this.isInfOrNaN(var5) || this.isInfOrNaN(var7))) {
            this.type = 0x400000C0;
            this.dirtyBits = 88;
        } else {
            this.dirtyBits = 255;
        }
    }

    public final void mul(double var1) {
        int var3 = 0;
        while (var3 < 16) {
            double[] var10000 = this.mat;
            int n = var3++;
            var10000[n] = var10000[n] * var1;
        }
        this.dirtyBits = 255;
    }

    public final void mul(double var1, Transform3D var3) {
        for (int var4 = 0; var4 < 16; ++var4) {
            this.mat[var4] = var3.mat[var4] * var1;
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D var1) {
        double var24;
        double var22;
        double var20;
        double var18;
        double var16;
        double var14;
        double var12;
        double var10;
        double var8;
        double var6;
        double var4;
        double var2;
        boolean var26 = false;
        if (var1.isAffine()) {
            var2 = this.mat[0] * var1.mat[0] + this.mat[1] * var1.mat[4] + this.mat[2] * var1.mat[8];
            var4 = this.mat[0] * var1.mat[1] + this.mat[1] * var1.mat[5] + this.mat[2] * var1.mat[9];
            var6 = this.mat[0] * var1.mat[2] + this.mat[1] * var1.mat[6] + this.mat[2] * var1.mat[10];
            var8 = this.mat[0] * var1.mat[3] + this.mat[1] * var1.mat[7] + this.mat[2] * var1.mat[11] + this.mat[3];
            var10 = this.mat[4] * var1.mat[0] + this.mat[5] * var1.mat[4] + this.mat[6] * var1.mat[8];
            var12 = this.mat[4] * var1.mat[1] + this.mat[5] * var1.mat[5] + this.mat[6] * var1.mat[9];
            var14 = this.mat[4] * var1.mat[2] + this.mat[5] * var1.mat[6] + this.mat[6] * var1.mat[10];
            var16 = this.mat[4] * var1.mat[3] + this.mat[5] * var1.mat[7] + this.mat[6] * var1.mat[11] + this.mat[7];
            var18 = this.mat[8] * var1.mat[0] + this.mat[9] * var1.mat[4] + this.mat[10] * var1.mat[8];
            var20 = this.mat[8] * var1.mat[1] + this.mat[9] * var1.mat[5] + this.mat[10] * var1.mat[9];
            var22 = this.mat[8] * var1.mat[2] + this.mat[9] * var1.mat[6] + this.mat[10] * var1.mat[10];
            var24 = this.mat[8] * var1.mat[3] + this.mat[9] * var1.mat[7] + this.mat[10] * var1.mat[11] + this.mat[11];
            if (this.isAffine()) {
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                var26 = true;
            } else {
                double var27 = this.mat[12] * var1.mat[0] + this.mat[13] * var1.mat[4] + this.mat[14] * var1.mat[8];
                double var29 = this.mat[12] * var1.mat[1] + this.mat[13] * var1.mat[5] + this.mat[14] * var1.mat[9];
                double var31 = this.mat[12] * var1.mat[2] + this.mat[13] * var1.mat[6] + this.mat[14] * var1.mat[10];
                double var33 = this.mat[12] * var1.mat[3] + this.mat[13] * var1.mat[7] + this.mat[14] * var1.mat[11] + this.mat[15];
                this.mat[12] = var27;
                this.mat[13] = var29;
                this.mat[14] = var31;
                this.mat[15] = var33;
            }
        } else {
            var2 = this.mat[0] * var1.mat[0] + this.mat[1] * var1.mat[4] + this.mat[2] * var1.mat[8] + this.mat[3] * var1.mat[12];
            var4 = this.mat[0] * var1.mat[1] + this.mat[1] * var1.mat[5] + this.mat[2] * var1.mat[9] + this.mat[3] * var1.mat[13];
            var6 = this.mat[0] * var1.mat[2] + this.mat[1] * var1.mat[6] + this.mat[2] * var1.mat[10] + this.mat[3] * var1.mat[14];
            var8 = this.mat[0] * var1.mat[3] + this.mat[1] * var1.mat[7] + this.mat[2] * var1.mat[11] + this.mat[3] * var1.mat[15];
            var10 = this.mat[4] * var1.mat[0] + this.mat[5] * var1.mat[4] + this.mat[6] * var1.mat[8] + this.mat[7] * var1.mat[12];
            var12 = this.mat[4] * var1.mat[1] + this.mat[5] * var1.mat[5] + this.mat[6] * var1.mat[9] + this.mat[7] * var1.mat[13];
            var14 = this.mat[4] * var1.mat[2] + this.mat[5] * var1.mat[6] + this.mat[6] * var1.mat[10] + this.mat[7] * var1.mat[14];
            var16 = this.mat[4] * var1.mat[3] + this.mat[5] * var1.mat[7] + this.mat[6] * var1.mat[11] + this.mat[7] * var1.mat[15];
            var18 = this.mat[8] * var1.mat[0] + this.mat[9] * var1.mat[4] + this.mat[10] * var1.mat[8] + this.mat[11] * var1.mat[12];
            var20 = this.mat[8] * var1.mat[1] + this.mat[9] * var1.mat[5] + this.mat[10] * var1.mat[9] + this.mat[11] * var1.mat[13];
            var22 = this.mat[8] * var1.mat[2] + this.mat[9] * var1.mat[6] + this.mat[10] * var1.mat[10] + this.mat[11] * var1.mat[14];
            var24 = this.mat[8] * var1.mat[3] + this.mat[9] * var1.mat[7] + this.mat[10] * var1.mat[11] + this.mat[11] * var1.mat[15];
            if (this.isAffine()) {
                this.mat[12] = var1.mat[12];
                this.mat[13] = var1.mat[13];
                this.mat[14] = var1.mat[14];
                this.mat[15] = var1.mat[15];
            } else {
                double var35 = this.mat[12] * var1.mat[0] + this.mat[13] * var1.mat[4] + this.mat[14] * var1.mat[8] + this.mat[15] * var1.mat[12];
                double var36 = this.mat[12] * var1.mat[1] + this.mat[13] * var1.mat[5] + this.mat[14] * var1.mat[9] + this.mat[15] * var1.mat[13];
                double var37 = this.mat[12] * var1.mat[2] + this.mat[13] * var1.mat[6] + this.mat[14] * var1.mat[10] + this.mat[15] * var1.mat[14];
                double var38 = this.mat[12] * var1.mat[3] + this.mat[13] * var1.mat[7] + this.mat[14] * var1.mat[11] + this.mat[15] * var1.mat[15];
                this.mat[12] = var35;
                this.mat[13] = var36;
                this.mat[14] = var37;
                this.mat[15] = var38;
            }
        }
        this.mat[0] = var2;
        this.mat[1] = var4;
        this.mat[2] = var6;
        this.mat[3] = var8;
        this.mat[4] = var10;
        this.mat[5] = var12;
        this.mat[6] = var14;
        this.mat[7] = var16;
        this.mat[8] = var18;
        this.mat[9] = var20;
        this.mat[10] = var22;
        this.mat[11] = var24;
        if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0 && (var1.dirtyBits & 4) == 0 && (var1.type & 0x40) != 0) {
            this.type &= var1.type;
            this.dirtyBits |= var1.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = var26 ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D var1, Transform3D var2) {
        boolean var3 = false;
        if (this != var1 && this != var2) {
            if (var2.isAffine()) {
                this.mat[0] = var1.mat[0] * var2.mat[0] + var1.mat[1] * var2.mat[4] + var1.mat[2] * var2.mat[8];
                this.mat[1] = var1.mat[0] * var2.mat[1] + var1.mat[1] * var2.mat[5] + var1.mat[2] * var2.mat[9];
                this.mat[2] = var1.mat[0] * var2.mat[2] + var1.mat[1] * var2.mat[6] + var1.mat[2] * var2.mat[10];
                this.mat[3] = var1.mat[0] * var2.mat[3] + var1.mat[1] * var2.mat[7] + var1.mat[2] * var2.mat[11] + var1.mat[3];
                this.mat[4] = var1.mat[4] * var2.mat[0] + var1.mat[5] * var2.mat[4] + var1.mat[6] * var2.mat[8];
                this.mat[5] = var1.mat[4] * var2.mat[1] + var1.mat[5] * var2.mat[5] + var1.mat[6] * var2.mat[9];
                this.mat[6] = var1.mat[4] * var2.mat[2] + var1.mat[5] * var2.mat[6] + var1.mat[6] * var2.mat[10];
                this.mat[7] = var1.mat[4] * var2.mat[3] + var1.mat[5] * var2.mat[7] + var1.mat[6] * var2.mat[11] + var1.mat[7];
                this.mat[8] = var1.mat[8] * var2.mat[0] + var1.mat[9] * var2.mat[4] + var1.mat[10] * var2.mat[8];
                this.mat[9] = var1.mat[8] * var2.mat[1] + var1.mat[9] * var2.mat[5] + var1.mat[10] * var2.mat[9];
                this.mat[10] = var1.mat[8] * var2.mat[2] + var1.mat[9] * var2.mat[6] + var1.mat[10] * var2.mat[10];
                this.mat[11] = var1.mat[8] * var2.mat[3] + var1.mat[9] * var2.mat[7] + var1.mat[10] * var2.mat[11] + var1.mat[11];
                if (var1.isAffine()) {
                    var3 = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    this.mat[12] = var1.mat[12] * var2.mat[0] + var1.mat[13] * var2.mat[4] + var1.mat[14] * var2.mat[8];
                    this.mat[13] = var1.mat[12] * var2.mat[1] + var1.mat[13] * var2.mat[5] + var1.mat[14] * var2.mat[9];
                    this.mat[14] = var1.mat[12] * var2.mat[2] + var1.mat[13] * var2.mat[6] + var1.mat[14] * var2.mat[10];
                    this.mat[15] = var1.mat[12] * var2.mat[3] + var1.mat[13] * var2.mat[7] + var1.mat[14] * var2.mat[11] + var1.mat[15];
                }
            } else {
                this.mat[0] = var1.mat[0] * var2.mat[0] + var1.mat[1] * var2.mat[4] + var1.mat[2] * var2.mat[8] + var1.mat[3] * var2.mat[12];
                this.mat[1] = var1.mat[0] * var2.mat[1] + var1.mat[1] * var2.mat[5] + var1.mat[2] * var2.mat[9] + var1.mat[3] * var2.mat[13];
                this.mat[2] = var1.mat[0] * var2.mat[2] + var1.mat[1] * var2.mat[6] + var1.mat[2] * var2.mat[10] + var1.mat[3] * var2.mat[14];
                this.mat[3] = var1.mat[0] * var2.mat[3] + var1.mat[1] * var2.mat[7] + var1.mat[2] * var2.mat[11] + var1.mat[3] * var2.mat[15];
                this.mat[4] = var1.mat[4] * var2.mat[0] + var1.mat[5] * var2.mat[4] + var1.mat[6] * var2.mat[8] + var1.mat[7] * var2.mat[12];
                this.mat[5] = var1.mat[4] * var2.mat[1] + var1.mat[5] * var2.mat[5] + var1.mat[6] * var2.mat[9] + var1.mat[7] * var2.mat[13];
                this.mat[6] = var1.mat[4] * var2.mat[2] + var1.mat[5] * var2.mat[6] + var1.mat[6] * var2.mat[10] + var1.mat[7] * var2.mat[14];
                this.mat[7] = var1.mat[4] * var2.mat[3] + var1.mat[5] * var2.mat[7] + var1.mat[6] * var2.mat[11] + var1.mat[7] * var2.mat[15];
                this.mat[8] = var1.mat[8] * var2.mat[0] + var1.mat[9] * var2.mat[4] + var1.mat[10] * var2.mat[8] + var1.mat[11] * var2.mat[12];
                this.mat[9] = var1.mat[8] * var2.mat[1] + var1.mat[9] * var2.mat[5] + var1.mat[10] * var2.mat[9] + var1.mat[11] * var2.mat[13];
                this.mat[10] = var1.mat[8] * var2.mat[2] + var1.mat[9] * var2.mat[6] + var1.mat[10] * var2.mat[10] + var1.mat[11] * var2.mat[14];
                this.mat[11] = var1.mat[8] * var2.mat[3] + var1.mat[9] * var2.mat[7] + var1.mat[10] * var2.mat[11] + var1.mat[11] * var2.mat[15];
                if (var1.isAffine()) {
                    this.mat[12] = var2.mat[12];
                    this.mat[13] = var2.mat[13];
                    this.mat[14] = var2.mat[14];
                    this.mat[15] = var2.mat[15];
                } else {
                    this.mat[12] = var1.mat[12] * var2.mat[0] + var1.mat[13] * var2.mat[4] + var1.mat[14] * var2.mat[8] + var1.mat[15] * var2.mat[12];
                    this.mat[13] = var1.mat[12] * var2.mat[1] + var1.mat[13] * var2.mat[5] + var1.mat[14] * var2.mat[9] + var1.mat[15] * var2.mat[13];
                    this.mat[14] = var1.mat[12] * var2.mat[2] + var1.mat[13] * var2.mat[6] + var1.mat[14] * var2.mat[10] + var1.mat[15] * var2.mat[14];
                    this.mat[15] = var1.mat[12] * var2.mat[3] + var1.mat[13] * var2.mat[7] + var1.mat[14] * var2.mat[11] + var1.mat[15] * var2.mat[15];
                }
            }
        } else {
            double var26;
            double var24;
            double var22;
            double var20;
            double var18;
            double var16;
            double var14;
            double var12;
            double var10;
            double var8;
            double var6;
            double var4;
            if (var2.isAffine()) {
                var4 = var1.mat[0] * var2.mat[0] + var1.mat[1] * var2.mat[4] + var1.mat[2] * var2.mat[8];
                var6 = var1.mat[0] * var2.mat[1] + var1.mat[1] * var2.mat[5] + var1.mat[2] * var2.mat[9];
                var8 = var1.mat[0] * var2.mat[2] + var1.mat[1] * var2.mat[6] + var1.mat[2] * var2.mat[10];
                var10 = var1.mat[0] * var2.mat[3] + var1.mat[1] * var2.mat[7] + var1.mat[2] * var2.mat[11] + var1.mat[3];
                var12 = var1.mat[4] * var2.mat[0] + var1.mat[5] * var2.mat[4] + var1.mat[6] * var2.mat[8];
                var14 = var1.mat[4] * var2.mat[1] + var1.mat[5] * var2.mat[5] + var1.mat[6] * var2.mat[9];
                var16 = var1.mat[4] * var2.mat[2] + var1.mat[5] * var2.mat[6] + var1.mat[6] * var2.mat[10];
                var18 = var1.mat[4] * var2.mat[3] + var1.mat[5] * var2.mat[7] + var1.mat[6] * var2.mat[11] + var1.mat[7];
                var20 = var1.mat[8] * var2.mat[0] + var1.mat[9] * var2.mat[4] + var1.mat[10] * var2.mat[8];
                var22 = var1.mat[8] * var2.mat[1] + var1.mat[9] * var2.mat[5] + var1.mat[10] * var2.mat[9];
                var24 = var1.mat[8] * var2.mat[2] + var1.mat[9] * var2.mat[6] + var1.mat[10] * var2.mat[10];
                var26 = var1.mat[8] * var2.mat[3] + var1.mat[9] * var2.mat[7] + var1.mat[10] * var2.mat[11] + var1.mat[11];
                if (var1.isAffine()) {
                    var3 = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    double var28 = var1.mat[12] * var2.mat[0] + var1.mat[13] * var2.mat[4] + var1.mat[14] * var2.mat[8];
                    double var30 = var1.mat[12] * var2.mat[1] + var1.mat[13] * var2.mat[5] + var1.mat[14] * var2.mat[9];
                    double var32 = var1.mat[12] * var2.mat[2] + var1.mat[13] * var2.mat[6] + var1.mat[14] * var2.mat[10];
                    double var34 = var1.mat[12] * var2.mat[3] + var1.mat[13] * var2.mat[7] + var1.mat[14] * var2.mat[11] + var1.mat[15];
                    this.mat[12] = var28;
                    this.mat[13] = var30;
                    this.mat[14] = var32;
                    this.mat[15] = var34;
                }
            } else {
                var4 = var1.mat[0] * var2.mat[0] + var1.mat[1] * var2.mat[4] + var1.mat[2] * var2.mat[8] + var1.mat[3] * var2.mat[12];
                var6 = var1.mat[0] * var2.mat[1] + var1.mat[1] * var2.mat[5] + var1.mat[2] * var2.mat[9] + var1.mat[3] * var2.mat[13];
                var8 = var1.mat[0] * var2.mat[2] + var1.mat[1] * var2.mat[6] + var1.mat[2] * var2.mat[10] + var1.mat[3] * var2.mat[14];
                var10 = var1.mat[0] * var2.mat[3] + var1.mat[1] * var2.mat[7] + var1.mat[2] * var2.mat[11] + var1.mat[3] * var2.mat[15];
                var12 = var1.mat[4] * var2.mat[0] + var1.mat[5] * var2.mat[4] + var1.mat[6] * var2.mat[8] + var1.mat[7] * var2.mat[12];
                var14 = var1.mat[4] * var2.mat[1] + var1.mat[5] * var2.mat[5] + var1.mat[6] * var2.mat[9] + var1.mat[7] * var2.mat[13];
                var16 = var1.mat[4] * var2.mat[2] + var1.mat[5] * var2.mat[6] + var1.mat[6] * var2.mat[10] + var1.mat[7] * var2.mat[14];
                var18 = var1.mat[4] * var2.mat[3] + var1.mat[5] * var2.mat[7] + var1.mat[6] * var2.mat[11] + var1.mat[7] * var2.mat[15];
                var20 = var1.mat[8] * var2.mat[0] + var1.mat[9] * var2.mat[4] + var1.mat[10] * var2.mat[8] + var1.mat[11] * var2.mat[12];
                var22 = var1.mat[8] * var2.mat[1] + var1.mat[9] * var2.mat[5] + var1.mat[10] * var2.mat[9] + var1.mat[11] * var2.mat[13];
                var24 = var1.mat[8] * var2.mat[2] + var1.mat[9] * var2.mat[6] + var1.mat[10] * var2.mat[10] + var1.mat[11] * var2.mat[14];
                var26 = var1.mat[8] * var2.mat[3] + var1.mat[9] * var2.mat[7] + var1.mat[10] * var2.mat[11] + var1.mat[11] * var2.mat[15];
                if (var1.isAffine()) {
                    this.mat[12] = var2.mat[12];
                    this.mat[13] = var2.mat[13];
                    this.mat[14] = var2.mat[14];
                    this.mat[15] = var2.mat[15];
                } else {
                    double var36 = var1.mat[12] * var2.mat[0] + var1.mat[13] * var2.mat[4] + var1.mat[14] * var2.mat[8] + var1.mat[15] * var2.mat[12];
                    double var37 = var1.mat[12] * var2.mat[1] + var1.mat[13] * var2.mat[5] + var1.mat[14] * var2.mat[9] + var1.mat[15] * var2.mat[13];
                    double var38 = var1.mat[12] * var2.mat[2] + var1.mat[13] * var2.mat[6] + var1.mat[14] * var2.mat[10] + var1.mat[15] * var2.mat[14];
                    double var39 = var1.mat[12] * var2.mat[3] + var1.mat[13] * var2.mat[7] + var1.mat[14] * var2.mat[11] + var1.mat[15] * var2.mat[15];
                    this.mat[12] = var36;
                    this.mat[13] = var37;
                    this.mat[14] = var38;
                    this.mat[15] = var39;
                }
            }
            this.mat[0] = var4;
            this.mat[1] = var6;
            this.mat[2] = var8;
            this.mat[3] = var10;
            this.mat[4] = var12;
            this.mat[5] = var14;
            this.mat[6] = var16;
            this.mat[7] = var18;
            this.mat[8] = var20;
            this.mat[9] = var22;
            this.mat[10] = var24;
            this.mat[11] = var26;
        }
        if ((var1.dirtyBits & 4) == 0 && (var1.type & 0x40) != 0 && (var2.dirtyBits & 4) == 0 && (var2.type & 0x40) != 0) {
            this.type = var1.type & var2.type;
            this.dirtyBits = var1.dirtyBits | var2.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = var3 ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mulInverse(Transform3D var1) {
        Transform3D var2 = new Transform3D();
        var2.autoNormalize = false;
        var2.invert(var1);
        this.mul(var2);
    }

    public final void mulInverse(Transform3D var1, Transform3D var2) {
        Transform3D var3 = new Transform3D();
        var3.autoNormalize = false;
        var3.invert(var2);
        this.mul(var1, var3);
    }

    public final void mulTransposeRight(Transform3D var1, Transform3D var2) {
        Transform3D var3 = new Transform3D();
        var3.autoNormalize = false;
        var3.transpose(var2);
        this.mul(var1, var3);
    }

    public final void mulTransposeLeft(Transform3D var1, Transform3D var2) {
        Transform3D var3 = new Transform3D();
        var3.autoNormalize = false;
        var3.transpose(var1);
        this.mul(var3, var2);
    }

    public final void mulTransposeBoth(Transform3D var1, Transform3D var2) {
        Transform3D var3 = new Transform3D();
        Transform3D var4 = new Transform3D();
        var3.autoNormalize = false;
        var4.autoNormalize = false;
        var3.transpose(var1);
        var4.transpose(var2);
        this.mul(var3, var4);
    }

    public final void normalize() {
        if (this.isAffine() || !this.isInfOrNaN()) {
            if ((this.dirtyBits & 0xC0) != 0) {
                this.computeScaleRotation(true);
            } else if ((this.dirtyBits & 0xA0) != 0) {
                this.computeScales(true);
            }
            this.mat[0] = this.rot[0] * this.scales[0];
            this.mat[1] = this.rot[1] * this.scales[1];
            this.mat[2] = this.rot[2] * this.scales[2];
            this.mat[4] = this.rot[3] * this.scales[0];
            this.mat[5] = this.rot[4] * this.scales[1];
            this.mat[6] = this.rot[5] * this.scales[2];
            this.mat[8] = this.rot[6] * this.scales[0];
            this.mat[9] = this.rot[7] * this.scales[1];
            this.mat[10] = this.rot[8] * this.scales[2];
            this.dirtyBits |= 0x10;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
        }
    }

    public final void normalize(Transform3D var1) {
        this.set(var1);
        this.normalize();
    }

    public final void normalizeCP() {
        if (this.isAffine() || !this.isInfOrNaN()) {
            double var1;
            if ((this.dirtyBits & 0x20) != 0) {
                this.computeScales(false);
            }
            if ((var1 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]) != 0.0) {
                var1 = 1.0 / Math.sqrt(var1);
                this.mat[0] = this.mat[0] * var1;
                this.mat[4] = this.mat[4] * var1;
                this.mat[8] = this.mat[8] * var1;
            }
            if ((var1 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]) != 0.0) {
                var1 = 1.0 / Math.sqrt(var1);
                this.mat[1] = this.mat[1] * var1;
                this.mat[5] = this.mat[5] * var1;
                this.mat[9] = this.mat[9] * var1;
            }
            this.mat[2] = (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]) * this.scales[0];
            this.mat[6] = (this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9]) * this.scales[1];
            this.mat[10] = (this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4]) * this.scales[2];
            double[] var10000 = this.mat;
            var10000[0] = var10000[0] * this.scales[0];
            var10000 = this.mat;
            var10000[1] = var10000[1] * this.scales[0];
            var10000 = this.mat;
            var10000[4] = var10000[4] * this.scales[1];
            var10000 = this.mat;
            var10000[5] = var10000[5] * this.scales[1];
            var10000 = this.mat;
            var10000[8] = var10000[8] * this.scales[2];
            var10000 = this.mat;
            var10000[9] = var10000[9] * this.scales[2];
            this.dirtyBits |= 0xDC;
            this.dirtyBits &= 0xFFFFFFFD;
            this.type |= 0x40000000;
        }
    }

    public final void normalizeCP(Transform3D var1) {
        this.set(var1);
        this.normalizeCP();
    }

    public boolean equals(Transform3D var1) {
        return var1 != null && this.mat[0] == var1.mat[0] && this.mat[1] == var1.mat[1] && this.mat[2] == var1.mat[2] && this.mat[3] == var1.mat[3] && this.mat[4] == var1.mat[4] && this.mat[5] == var1.mat[5] && this.mat[6] == var1.mat[6] && this.mat[7] == var1.mat[7] && this.mat[8] == var1.mat[8] && this.mat[9] == var1.mat[9] && this.mat[10] == var1.mat[10] && this.mat[11] == var1.mat[11] && this.mat[12] == var1.mat[12] && this.mat[13] == var1.mat[13] && this.mat[14] == var1.mat[14] && this.mat[15] == var1.mat[15];
    }

    public boolean equals(Object var1) {
        return var1 instanceof Transform3D && this.equals((Transform3D)var1);
    }

    public boolean epsilonEquals(Transform3D var1, double var2) {
        for (int var6 = 0; var6 < 16; ++var6) {
            double var4 = this.mat[var6] - var1.mat[var6];
            double d = var4 < 0.0 ? -var4 : var4;
            if (!(d > var2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long var1 = 1L;
        for (int var3 = 0; var3 < 16; ++var3) {
            var1 = 31L * var1 + HashCodeUtil.doubleToLongBits((double)this.mat[var3]);
        }
        return (int)(var1 ^ var1 >> 32);
    }

    public final void transform(Vector4d var1, Vector4d var2) {
        if (var1 != var2) {
            var2.x = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z + this.mat[3] * var1.w;
            var2.y = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z + this.mat[7] * var1.w;
            var2.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z + this.mat[11] * var1.w;
            var2.w = this.mat[12] * var1.x + this.mat[13] * var1.y + this.mat[14] * var1.z + this.mat[15] * var1.w;
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Vector4d var1) {
        double var2 = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z + this.mat[3] * var1.w;
        double var4 = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z + this.mat[7] * var1.w;
        double var6 = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z + this.mat[11] * var1.w;
        var1.w = this.mat[12] * var1.x + this.mat[13] * var1.y + this.mat[14] * var1.z + this.mat[15] * var1.w;
        var1.x = var2;
        var1.y = var4;
        var1.z = var6;
    }

    public final void transform(Vector4f var1, Vector4f var2) {
        if (var2 != var1) {
            var2.x = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z + this.mat[3] * (double)var1.w);
            var2.y = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z + this.mat[7] * (double)var1.w);
            var2.z = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z + this.mat[11] * (double)var1.w);
            var2.w = (float)(this.mat[12] * (double)var1.x + this.mat[13] * (double)var1.y + this.mat[14] * (double)var1.z + this.mat[15] * (double)var1.w);
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Vector4f var1) {
        float var2 = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z + this.mat[3] * (double)var1.w);
        float var3 = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z + this.mat[7] * (double)var1.w);
        float var4 = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z + this.mat[11] * (double)var1.w);
        var1.w = (float)(this.mat[12] * (double)var1.x + this.mat[13] * (double)var1.y + this.mat[14] * (double)var1.z + this.mat[15] * (double)var1.w);
        var1.x = var2;
        var1.y = var3;
        var1.z = var4;
    }

    public final void transform(Point3d var1, Point3d var2) {
        if (var1 != var2) {
            var2.x = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z + this.mat[3];
            var2.y = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z + this.mat[7];
            var2.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z + this.mat[11];
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Point3d var1) {
        double var2 = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z + this.mat[3];
        double var4 = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z + this.mat[7];
        var1.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z + this.mat[11];
        var1.x = var2;
        var1.y = var4;
    }

    public final void transform(Vector3d var1, Vector3d var2) {
        if (var2 != var1) {
            var2.x = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z;
            var2.y = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z;
            var2.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z;
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Vector3d var1) {
        double var2 = this.mat[0] * var1.x + this.mat[1] * var1.y + this.mat[2] * var1.z;
        double var4 = this.mat[4] * var1.x + this.mat[5] * var1.y + this.mat[6] * var1.z;
        var1.z = this.mat[8] * var1.x + this.mat[9] * var1.y + this.mat[10] * var1.z;
        var1.x = var2;
        var1.y = var4;
    }

    public final void transform(Point3f var1, Point3f var2) {
        if (var1 != var2) {
            var2.x = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z + this.mat[3]);
            var2.y = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z + this.mat[7]);
            var2.z = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z + this.mat[11]);
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Point3f var1) {
        float var2 = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z + this.mat[3]);
        float var3 = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z + this.mat[7]);
        var1.z = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z + this.mat[11]);
        var1.x = var2;
        var1.y = var3;
    }

    public final void transform(Vector3f var1, Vector3f var2) {
        if (var1 != var2) {
            var2.x = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z);
            var2.y = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z);
            var2.z = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z);
        } else {
            this.transform(var1);
        }
    }

    public final void transform(Vector3f var1) {
        float var2 = (float)(this.mat[0] * (double)var1.x + this.mat[1] * (double)var1.y + this.mat[2] * (double)var1.z);
        float var3 = (float)(this.mat[4] * (double)var1.x + this.mat[5] * (double)var1.y + this.mat[6] * (double)var1.z);
        var1.z = (float)(this.mat[8] * (double)var1.x + this.mat[9] * (double)var1.y + this.mat[10] * (double)var1.z);
        var1.x = var2;
        var1.y = var3;
    }

    public final void setRotationScale(Matrix3f var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotationScale(Matrix3d var1) {
        this.mat[0] = var1.m00;
        this.mat[1] = var1.m01;
        this.mat[2] = var1.m02;
        this.mat[4] = var1.m10;
        this.mat[5] = var1.m11;
        this.mat[6] = var1.m12;
        this.mat[8] = var1.m20;
        this.mat[9] = var1.m21;
        this.mat[10] = var1.m22;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double var1, Transform3D var3, Transform3D var4) {
        for (int var5 = 0; var5 < 16; ++var5) {
            this.mat[var5] = var1 * var3.mat[var5] + var4.mat[var5];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double var1, Transform3D var3) {
        for (int var4 = 0; var4 < 16; ++var4) {
            this.mat[var4] = var1 * this.mat[var4] + var3.mat[var4];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void getRotationScale(Matrix3f var1) {
        var1.m00 = (float)this.mat[0];
        var1.m01 = (float)this.mat[1];
        var1.m02 = (float)this.mat[2];
        var1.m10 = (float)this.mat[4];
        var1.m11 = (float)this.mat[5];
        var1.m12 = (float)this.mat[6];
        var1.m20 = (float)this.mat[8];
        var1.m21 = (float)this.mat[9];
        var1.m22 = (float)this.mat[10];
    }

    public final void getRotationScale(Matrix3d var1) {
        var1.m00 = this.mat[0];
        var1.m01 = this.mat[1];
        var1.m02 = this.mat[2];
        var1.m10 = this.mat[4];
        var1.m11 = this.mat[5];
        var1.m12 = this.mat[6];
        var1.m20 = this.mat[8];
        var1.m21 = this.mat[9];
        var1.m22 = this.mat[10];
    }

    public void lookAt(Point3d var1, Point3d var2, Vector3d var3) {
        double var4 = var1.x - var2.x;
        double var6 = var1.y - var2.y;
        double var8 = var1.z - var2.z;
        double var10 = 1.0 / Math.sqrt(var4 * var4 + var6 * var6 + var8 * var8);
        var4 *= var10;
        var6 *= var10;
        var8 *= var10;
        var10 = 1.0 / Math.sqrt(var3.x * var3.x + var3.y * var3.y + var3.z * var3.z);
        double var12 = var3.x * var10;
        double var14 = var3.y * var10;
        double var16 = var3.z * var10;
        double var18 = var14 * var8 - var6 * var16;
        double var20 = var16 * var4 - var12 * var8;
        double var22 = var12 * var6 - var14 * var4;
        var10 = 1.0 / Math.sqrt(var18 * var18 + var20 * var20 + var22 * var22);
        var12 = var6 * (var22 *= var10) - (var20 *= var10) * var8;
        var14 = var8 * (var18 *= var10) - var4 * var22;
        var16 = var4 * var20 - var6 * var18;
        this.mat[0] = var18;
        this.mat[1] = var20;
        this.mat[2] = var22;
        this.mat[4] = var12;
        this.mat[5] = var14;
        this.mat[6] = var16;
        this.mat[8] = var4;
        this.mat[9] = var6;
        this.mat[10] = var8;
        this.mat[3] = -var1.x * this.mat[0] + -var1.y * this.mat[1] + -var1.z * this.mat[2];
        this.mat[7] = -var1.x * this.mat[4] + -var1.y * this.mat[5] + -var1.z * this.mat[6];
        this.mat[11] = -var1.x * this.mat[8] + -var1.y * this.mat[9] + -var1.z * this.mat[10];
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public void frustum(double var1, double var3, double var5, double var7, double var9, double var11) {
        double var13 = 1.0 / (var3 - var1);
        double var15 = 1.0 / (var7 - var5);
        double var17 = 1.0 / (var11 - var9);
        this.mat[0] = 2.0 * var9 * var13;
        this.mat[5] = 2.0 * var9 * var15;
        this.mat[10] = (var11 + var9) * var17;
        this.mat[2] = (var3 + var1) * var13;
        this.mat[6] = (var7 + var5) * var15;
        this.mat[11] = 2.0 * var11 * var9 * var17;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void perspective(double var1, double var3, double var5, double var7) {
        double var11;
        double var15 = var1 * 0.5;
        new Vector3d();
        double var13 = var7 - var5;
        double var9 = Math.sin(var15);
        this.mat[0] = var11 = Math.cos(var15) / var9;
        this.mat[5] = var11 * var3;
        this.mat[10] = (var7 + var5) / var13;
        this.mat[11] = 2.0 * var5 * var7 / var13;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void ortho(double var1, double var3, double var5, double var7, double var9, double var11) {
        double var13 = 1.0 / (var3 - var1);
        double var15 = 1.0 / (var7 - var5);
        double var17 = 1.0 / (var11 - var9);
        this.mat[0] = 2.0 * var13;
        this.mat[3] = -(var3 + var1) * var13;
        this.mat[5] = 2.0 * var15;
        this.mat[7] = -(var7 + var5) * var15;
        this.mat[10] = 2.0 * var17;
        this.mat[11] = (var11 + var9) * var17;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    double getDistanceScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            double var1 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
            if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0) {
                return Math.sqrt(var1);
            }
            double var3 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
            if (var3 > var1) {
                var1 = var3;
            }
            return Math.sqrt((var3 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]) > var1 ? var3 : var1);
        }
        return Transform3D.max3(this.scales);
    }

    private static void mat_mul(double[] var0, double[] var1, double[] var2) {
        double[] var3 = var2;
        if (var0 == var2 || var1 == var2) {
            var3 = new double[]{var0[0] * var1[0] + var0[1] * var1[3] + var0[2] * var1[6], var0[0] * var1[1] + var0[1] * var1[4] + var0[2] * var1[7], var0[0] * var1[2] + var0[1] * var1[5] + var0[2] * var1[8], var0[3] * var1[0] + var0[4] * var1[3] + var0[5] * var1[6], var0[3] * var1[1] + var0[4] * var1[4] + var0[5] * var1[7], var0[3] * var1[2] + var0[4] * var1[5] + var0[5] * var1[8], var0[6] * var1[0] + var0[7] * var1[3] + var0[8] * var1[6], var0[6] * var1[1] + var0[7] * var1[4] + var0[8] * var1[7], var0[6] * var1[2] + var0[7] * var1[5] + var0[8] * var1[8]};
        }
        if (var3 != var2) {
            for (int var4 = 0; var4 < 9; ++var4) {
                var2[var4] = var3[var4];
            }
        }
    }

    private static void transpose_mat(double[] var0, double[] var1) {
        var1[0] = var0[0];
        var1[1] = var0[3];
        var1[2] = var0[6];
        var1[3] = var0[1];
        var1[4] = var0[4];
        var1[5] = var0[7];
        var1[6] = var0[2];
        var1[7] = var0[5];
        var1[8] = var0[8];
    }

    private static final void multipleScale(double[] var0, double[] var1) {
        var0[0] = var0[0] * var1[0];
        var0[1] = var0[1] * var1[0];
        var0[2] = var0[2] * var1[0];
        var0[4] = var0[4] * var1[1];
        var0[5] = var0[5] * var1[1];
        var0[6] = var0[6] * var1[1];
        var0[8] = var0[8] * var1[2];
        var0[9] = var0[9] * var1[2];
        var0[10] = var0[10] * var1[2];
    }

    private void compute_svd(Transform3D var1, double[] var2, double[] var3) {
        double[] var10 = new double[9];
        double[] var11 = new double[9];
        double[] var12 = new double[9];
        double[] var13 = new double[9];
        double[] var14 = new double[9];
        double[] var15 = new double[9];
        double[] var16 = new double[3];
        double[] var17 = new double[3];
        int var19 = 0;
        var15[0] = var10[0] = var1.mat[0];
        var15[1] = var10[1] = var1.mat[1];
        var15[2] = var10[2] = var1.mat[2];
        var15[3] = var10[3] = var1.mat[4];
        var15[4] = var10[4] = var1.mat[5];
        var15[5] = var10[5] = var1.mat[6];
        var15[6] = var10[6] = var1.mat[8];
        var15[7] = var10[7] = var1.mat[9];
        var15[8] = var10[8] = var1.mat[10];
        if (var10[3] * var10[3] < 1.110223024E-16) {
            var11[0] = 1.0;
            var11[1] = 0.0;
            var11[2] = 0.0;
            var11[3] = 0.0;
            var11[4] = 1.0;
            var11[5] = 0.0;
            var11[6] = 0.0;
            var11[7] = 0.0;
            var11[8] = 1.0;
        } else if (var10[0] * var10[0] < 1.110223024E-16) {
            var13[0] = var10[0];
            var13[1] = var10[1];
            var13[2] = var10[2];
            var10[0] = var10[3];
            var10[1] = var10[4];
            var10[2] = var10[5];
            var10[3] = -var13[0];
            var10[4] = -var13[1];
            var10[5] = -var13[2];
            var11[0] = 0.0;
            var11[1] = 1.0;
            var11[2] = 0.0;
            var11[3] = -1.0;
            var11[4] = 0.0;
            var11[5] = 0.0;
            var11[6] = 0.0;
            var11[7] = 0.0;
            var11[8] = 1.0;
        } else {
            double var6 = 1.0 / Math.sqrt(var10[0] * var10[0] + var10[3] * var10[3]);
            double var24 = var10[0] * var6;
            double var32 = var10[3] * var6;
            var13[0] = var24 * var10[0] + var32 * var10[3];
            var13[1] = var24 * var10[1] + var32 * var10[4];
            var13[2] = var24 * var10[2] + var32 * var10[5];
            var10[3] = -var32 * var10[0] + var24 * var10[3];
            var10[4] = -var32 * var10[1] + var24 * var10[4];
            var10[5] = -var32 * var10[2] + var24 * var10[5];
            var10[0] = var13[0];
            var10[1] = var13[1];
            var10[2] = var13[2];
            var11[0] = var24;
            var11[1] = var32;
            var11[2] = 0.0;
            var11[3] = -var32;
            var11[4] = var24;
            var11[5] = 0.0;
            var11[6] = 0.0;
            var11[7] = 0.0;
            var11[8] = 1.0;
        }
        if (!(var10[6] * var10[6] < 1.110223024E-16)) {
            if (var10[0] * var10[0] < 1.110223024E-16) {
                var13[0] = var10[0];
                var13[1] = var10[1];
                var13[2] = var10[2];
                var10[0] = var10[6];
                var10[1] = var10[7];
                var10[2] = var10[8];
                var10[6] = -var13[0];
                var10[7] = -var13[1];
                var10[8] = -var13[2];
                var13[0] = var11[0];
                var13[1] = var11[1];
                var13[2] = var11[2];
                var11[0] = var11[6];
                var11[1] = var11[7];
                var11[2] = var11[8];
                var11[6] = -var13[0];
                var11[7] = -var13[1];
                var11[8] = -var13[2];
            } else {
                double var47 = 1.0 / Math.sqrt(var10[0] * var10[0] + var10[6] * var10[6]);
                double var26 = var10[0] * var47;
                double var34 = var10[6] * var47;
                var13[0] = var26 * var10[0] + var34 * var10[6];
                var13[1] = var26 * var10[1] + var34 * var10[7];
                var13[2] = var26 * var10[2] + var34 * var10[8];
                var10[6] = -var34 * var10[0] + var26 * var10[6];
                var10[7] = -var34 * var10[1] + var26 * var10[7];
                var10[8] = -var34 * var10[2] + var26 * var10[8];
                var10[0] = var13[0];
                var10[1] = var13[1];
                var10[2] = var13[2];
                var13[0] = var26 * var11[0];
                var13[1] = var26 * var11[1];
                var11[2] = var34;
                var13[6] = -var11[0] * var34;
                var13[7] = -var11[1] * var34;
                var11[8] = var26;
                var11[0] = var13[0];
                var11[1] = var13[1];
                var11[6] = var13[6];
                var11[7] = var13[7];
            }
        }
        if (var10[2] * var10[2] < 1.110223024E-16) {
            var12[0] = 1.0;
            var12[1] = 0.0;
            var12[2] = 0.0;
            var12[3] = 0.0;
            var12[4] = 1.0;
            var12[5] = 0.0;
            var12[6] = 0.0;
            var12[7] = 0.0;
            var12[8] = 1.0;
        } else if (var10[1] * var10[1] < 1.110223024E-16) {
            var13[2] = var10[2];
            var13[5] = var10[5];
            var13[8] = var10[8];
            var10[2] = -var10[1];
            var10[5] = -var10[4];
            var10[8] = -var10[7];
            var10[1] = var13[2];
            var10[4] = var13[5];
            var10[7] = var13[8];
            var12[0] = 1.0;
            var12[1] = 0.0;
            var12[2] = 0.0;
            var12[3] = 0.0;
            var12[4] = 0.0;
            var12[5] = -1.0;
            var12[6] = 0.0;
            var12[7] = 1.0;
            var12[8] = 0.0;
        } else {
            double var48 = 1.0 / Math.sqrt(var10[1] * var10[1] + var10[2] * var10[2]);
            double var28 = var10[1] * var48;
            double var36 = var10[2] * var48;
            var13[1] = var28 * var10[1] + var36 * var10[2];
            var10[2] = -var36 * var10[1] + var28 * var10[2];
            var10[1] = var13[1];
            var13[4] = var28 * var10[4] + var36 * var10[5];
            var10[5] = -var36 * var10[4] + var28 * var10[5];
            var10[4] = var13[4];
            var13[7] = var28 * var10[7] + var36 * var10[8];
            var10[8] = -var36 * var10[7] + var28 * var10[8];
            var10[7] = var13[7];
            var12[0] = 1.0;
            var12[1] = 0.0;
            var12[2] = 0.0;
            var12[3] = 0.0;
            var12[4] = var28;
            var12[5] = -var36;
            var12[6] = 0.0;
            var12[7] = var36;
            var12[8] = var28;
        }
        if (!(var10[7] * var10[7] < 1.110223024E-16)) {
            if (var10[4] * var10[4] < 1.110223024E-16) {
                var13[3] = var10[3];
                var13[4] = var10[4];
                var13[5] = var10[5];
                var10[3] = var10[6];
                var10[4] = var10[7];
                var10[5] = var10[8];
                var10[6] = -var13[3];
                var10[7] = -var13[4];
                var10[8] = -var13[5];
                var13[3] = var11[3];
                var13[4] = var11[4];
                var13[5] = var11[5];
                var11[3] = var11[6];
                var11[4] = var11[7];
                var11[5] = var11[8];
                var11[6] = -var13[3];
                var11[7] = -var13[4];
                var11[8] = -var13[5];
            } else {
                double var49 = 1.0 / Math.sqrt(var10[4] * var10[4] + var10[7] * var10[7]);
                double var30 = var10[4] * var49;
                double var38 = var10[7] * var49;
                var13[3] = var30 * var10[3] + var38 * var10[6];
                var10[6] = -var38 * var10[3] + var30 * var10[6];
                var10[3] = var13[3];
                var13[4] = var30 * var10[4] + var38 * var10[7];
                var10[7] = -var38 * var10[4] + var30 * var10[7];
                var10[4] = var13[4];
                var13[5] = var30 * var10[5] + var38 * var10[8];
                var10[8] = -var38 * var10[5] + var30 * var10[8];
                var10[5] = var13[5];
                var13[3] = var30 * var11[3] + var38 * var11[6];
                var11[6] = -var38 * var11[3] + var30 * var11[6];
                var11[3] = var13[3];
                var13[4] = var30 * var11[4] + var38 * var11[7];
                var11[7] = -var38 * var11[4] + var30 * var11[7];
                var11[4] = var13[4];
                var13[5] = var30 * var11[5] + var38 * var11[8];
                var11[8] = -var38 * var11[5] + var30 * var11[8];
                var11[5] = var13[5];
            }
        }
        var14[0] = var10[0];
        var14[1] = var10[4];
        var14[2] = var10[8];
        var16[0] = var10[1];
        var16[1] = var10[5];
        if (var16[0] * var16[0] > 1.110223024E-16 || var16[1] * var16[1] > 1.110223024E-16) {
            this.compute_qr(var14, var16, var11, var12);
        }
        var17[0] = var14[0];
        var17[1] = var14[1];
        var17[2] = var14[2];
        if (Transform3D.almostOne(Math.abs(var17[0])) && Transform3D.almostOne(Math.abs(var17[1])) && Transform3D.almostOne(Math.abs(var17[2]))) {
            for (int var4 = 0; var4 < 3; ++var4) {
                if (!(var17[var4] < 0.0)) continue;
                ++var19;
            }
            if (var19 == 0 || var19 == 2) {
                var2[2] = 1.0;
                var2[1] = 1.0;
                var2[0] = 1.0;
                for (int var46 = 0; var46 < 9; ++var46) {
                    var3[var46] = var15[var46];
                }
                return;
            }
        }
        Transform3D.transpose_mat(var11, var13);
        Transform3D.transpose_mat(var12, var14);
        this.svdReorder(var10, var13, var14, var15, var17, var3, var2);
    }

    private void svdReorder(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, double[] var7) {
        int[] var13 = new int[3];
        double[] var14 = new double[3];
        if (var5[0] < 0.0) {
            var5[0] = -var5[0];
            var3[0] = -var3[0];
            var3[1] = -var3[1];
            var3[2] = -var3[2];
        }
        if (var5[1] < 0.0) {
            var5[1] = -var5[1];
            var3[3] = -var3[3];
            var3[4] = -var3[4];
            var3[5] = -var3[5];
        }
        if (var5[2] < 0.0) {
            var5[2] = -var5[2];
            var3[6] = -var3[6];
            var3[7] = -var3[7];
            var3[8] = -var3[8];
        }
        Transform3D.mat_mul(var2, var3, var4);
        if (Transform3D.almostEqual(Math.abs(var5[0]), Math.abs(var5[1])) && Transform3D.almostEqual(Math.abs(var5[1]), Math.abs(var5[2]))) {
            for (int var12 = 0; var12 < 9; ++var12) {
                var6[var12] = var4[var12];
            }
            for (int var26 = 0; var26 < 3; ++var26) {
                var7[var26] = var5[var26];
            }
        } else {
            int var9;
            int var10;
            int var8;
            if (var5[0] > var5[1]) {
                if (var5[0] > var5[2]) {
                    if (var5[2] > var5[1]) {
                        var13[0] = 0;
                        var13[1] = 2;
                        var13[2] = 1;
                    } else {
                        var13[0] = 0;
                        var13[1] = 1;
                        var13[2] = 2;
                    }
                } else {
                    var13[0] = 2;
                    var13[1] = 0;
                    var13[2] = 1;
                }
            } else if (var5[1] > var5[2]) {
                if (var5[2] > var5[0]) {
                    var13[0] = 1;
                    var13[1] = 2;
                    var13[2] = 0;
                } else {
                    var13[0] = 1;
                    var13[1] = 0;
                    var13[2] = 2;
                }
            } else {
                var13[0] = 2;
                var13[1] = 1;
                var13[2] = 0;
            }
            var14[0] = var1[0] * var1[0] + var1[1] * var1[1] + var1[2] * var1[2];
            var14[1] = var1[3] * var1[3] + var1[4] * var1[4] + var1[5] * var1[5];
            var14[2] = var1[6] * var1[6] + var1[7] * var1[7] + var1[8] * var1[8];
            if (var14[0] > var14[1]) {
                if (var14[0] > var14[2]) {
                    if (var14[2] > var14[1]) {
                        var8 = 0;
                        var10 = 1;
                        var9 = 2;
                    } else {
                        var8 = 0;
                        var9 = 1;
                        var10 = 2;
                    }
                } else {
                    var10 = 0;
                    var8 = 1;
                    var9 = 2;
                }
            } else if (var14[1] > var14[2]) {
                if (var14[2] > var14[0]) {
                    var9 = 0;
                    var10 = 1;
                    var8 = 2;
                } else {
                    var9 = 0;
                    var8 = 1;
                    var10 = 2;
                }
            } else {
                var10 = 0;
                var9 = 1;
                var8 = 2;
            }
            int var11 = var13[var8];
            var7[0] = var5[var11];
            var11 = var13[var9];
            var7[1] = var5[var11];
            var11 = var13[var10];
            var7[2] = var5[var11];
            var11 = var13[var8];
            if (var6 == null) {
                MasterControl.getCoreLogger().severe("outRot == null");
            }
            if (var4 == null) {
                MasterControl.getCoreLogger().severe("rot == null");
            }
            var6[0] = var4[var11];
            var11 = var13[var8] + 3;
            var6[3] = var4[var11];
            var11 = var13[var8] + 6;
            var6[6] = var4[var11];
            var11 = var13[var9];
            var6[1] = var4[var11];
            var11 = var13[var9] + 3;
            var6[4] = var4[var11];
            var11 = var13[var9] + 6;
            var6[7] = var4[var11];
            var11 = var13[var10];
            var6[2] = var4[var11];
            var11 = var13[var10] + 3;
            var6[5] = var4[var11];
            var11 = var13[var10] + 6;
            var6[8] = var4[var11];
        }
    }

    private int compute_qr(double[] var1, double[] var2, double[] var3, double[] var4) {
        double[] var28 = new double[2];
        double[] var29 = new double[2];
        double[] var30 = new double[2];
        double[] var31 = new double[2];
        double[] var32 = new double[9];
        double var33 = 1.0;
        double var35 = -1.0;
        boolean var8 = false;
        int var37 = 1;
        if (Math.abs(var2[1]) < 4.89E-15 || Math.abs(var2[0]) < 4.89E-15) {
            var8 = true;
        }
        for (int var7 = 0; var7 < 10 && !var8; ++var7) {
            double var9 = Transform3D.compute_shift(var1[1], var2[1], var1[2]);
            double var21 = (Math.abs(var1[0]) - var9) * (Transform3D.d_sign(var33, var1[0]) + var9 / var1[0]);
            double var23 = var2[0];
            Transform3D.compute_rot(var21, var23, var31, var29, 0, var37);
            var21 = var29[0] * var1[0] + var31[0] * var2[0];
            var2[0] = var29[0] * var2[0] - var31[0] * var1[0];
            var23 = var31[0] * var1[1];
            var1[1] = var29[0] * var1[1];
            double var15 = Transform3D.compute_rot(var21, var23, var30, var28, 0, var37);
            var37 = 0;
            var1[0] = var15;
            var21 = var28[0] * var2[0] + var30[0] * var1[1];
            var1[1] = var28[0] * var1[1] - var30[0] * var2[0];
            var23 = var30[0] * var2[1];
            var2[1] = var28[0] * var2[1];
            var2[0] = var15 = Transform3D.compute_rot(var21, var23, var31, var29, 1, var37);
            var21 = var29[1] * var1[1] + var31[1] * var2[1];
            var2[1] = var29[1] * var2[1] - var31[1] * var1[1];
            var23 = var31[1] * var1[2];
            var1[2] = var29[1] * var1[2];
            var1[1] = var15 = Transform3D.compute_rot(var21, var23, var30, var28, 1, var37);
            var21 = var28[1] * var2[1] + var30[1] * var1[2];
            var1[2] = var28[1] * var1[2] - var30[1] * var2[1];
            var2[1] = var21;
            double var17 = var3[0];
            var3[0] = var28[0] * var17 + var30[0] * var3[3];
            var3[3] = -var30[0] * var17 + var28[0] * var3[3];
            var17 = var3[1];
            var3[1] = var28[0] * var17 + var30[0] * var3[4];
            var3[4] = -var30[0] * var17 + var28[0] * var3[4];
            var17 = var3[2];
            var3[2] = var28[0] * var17 + var30[0] * var3[5];
            var3[5] = -var30[0] * var17 + var28[0] * var3[5];
            var17 = var3[3];
            var3[3] = var28[1] * var17 + var30[1] * var3[6];
            var3[6] = -var30[1] * var17 + var28[1] * var3[6];
            var17 = var3[4];
            var3[4] = var28[1] * var17 + var30[1] * var3[7];
            var3[7] = -var30[1] * var17 + var28[1] * var3[7];
            var17 = var3[5];
            var3[5] = var28[1] * var17 + var30[1] * var3[8];
            var3[8] = -var30[1] * var17 + var28[1] * var3[8];
            double var19 = var4[0];
            var4[0] = var29[0] * var19 + var31[0] * var4[1];
            var4[1] = -var31[0] * var19 + var29[0] * var4[1];
            var19 = var4[3];
            var4[3] = var29[0] * var19 + var31[0] * var4[4];
            var4[4] = -var31[0] * var19 + var29[0] * var4[4];
            var19 = var4[6];
            var4[6] = var29[0] * var19 + var31[0] * var4[7];
            var4[7] = -var31[0] * var19 + var29[0] * var4[7];
            var19 = var4[1];
            var4[1] = var29[1] * var19 + var31[1] * var4[2];
            var4[2] = -var31[1] * var19 + var29[1] * var4[2];
            var19 = var4[4];
            var4[4] = var29[1] * var19 + var31[1] * var4[5];
            var4[5] = -var31[1] * var19 + var29[1] * var4[5];
            var19 = var4[7];
            var4[7] = var29[1] * var19 + var31[1] * var4[8];
            var4[8] = -var31[1] * var19 + var29[1] * var4[8];
            var32[0] = var1[0];
            var32[1] = var2[0];
            var32[2] = 0.0;
            var32[3] = 0.0;
            var32[4] = var1[1];
            var32[5] = var2[1];
            var32[6] = 0.0;
            var32[7] = 0.0;
            var32[8] = var1[2];
            if (!(Math.abs(var2[1]) < 4.89E-15) && !(Math.abs(var2[0]) < 4.89E-15)) continue;
            var8 = true;
        }
        if (Math.abs(var2[1]) < 4.89E-15) {
            Transform3D.compute_2X2(var1[0], var2[0], var1[1], var1, var30, var28, var31, var29, 0);
            double var45 = var3[0];
            var3[0] = var28[0] * var45 + var30[0] * var3[3];
            var3[3] = -var30[0] * var45 + var28[0] * var3[3];
            var45 = var3[1];
            var3[1] = var28[0] * var45 + var30[0] * var3[4];
            var3[4] = -var30[0] * var45 + var28[0] * var3[4];
            var45 = var3[2];
            var3[2] = var28[0] * var45 + var30[0] * var3[5];
            var3[5] = -var30[0] * var45 + var28[0] * var3[5];
            double var56 = var4[0];
            var4[0] = var29[0] * var56 + var31[0] * var4[1];
            var4[1] = -var31[0] * var56 + var29[0] * var4[1];
            var56 = var4[3];
            var4[3] = var29[0] * var56 + var31[0] * var4[4];
            var4[4] = -var31[0] * var56 + var29[0] * var4[4];
            var56 = var4[6];
            var4[6] = var29[0] * var56 + var31[0] * var4[7];
            var4[7] = -var31[0] * var56 + var29[0] * var4[7];
        } else {
            Transform3D.compute_2X2(var1[1], var2[1], var1[2], var1, var30, var28, var31, var29, 1);
            double var48 = var3[3];
            var3[3] = var28[0] * var48 + var30[0] * var3[6];
            var3[6] = -var30[0] * var48 + var28[0] * var3[6];
            var48 = var3[4];
            var3[4] = var28[0] * var48 + var30[0] * var3[7];
            var3[7] = -var30[0] * var48 + var28[0] * var3[7];
            var48 = var3[5];
            var3[5] = var28[0] * var48 + var30[0] * var3[8];
            var3[8] = -var30[0] * var48 + var28[0] * var3[8];
            double var59 = var4[1];
            var4[1] = var29[0] * var59 + var31[0] * var4[2];
            var4[2] = -var31[0] * var59 + var29[0] * var4[2];
            var59 = var4[4];
            var4[4] = var29[0] * var59 + var31[0] * var4[5];
            var4[5] = -var31[0] * var59 + var29[0] * var4[5];
            var59 = var4[7];
            var4[7] = var29[0] * var59 + var31[0] * var4[8];
            var4[8] = -var31[0] * var59 + var29[0] * var4[8];
        }
        return 0;
    }

    static final double max(double var0, double var2) {
        return var0 > var2 ? var0 : var2;
    }

    static final double min(double var0, double var2) {
        return var0 < var2 ? var0 : var2;
    }

    static final double d_sign(double var0, double var2) {
        double var4 = var0 >= 0.0 ? var0 : -var0;
        return var2 >= 0.0 ? var4 : -var4;
    }

    static final double compute_shift(double var0, double var2, double var4) {
        double var28;
        double var16 = Math.abs(var0);
        double var18 = Math.abs(var2);
        double var20 = Math.abs(var4);
        double var10 = Transform3D.min(var16, var20);
        double var12 = Transform3D.max(var16, var20);
        if (var10 == 0.0) {
            var28 = 0.0;
            if (var12 != 0.0) {
                double d = Transform3D.min(var12, var18) / Transform3D.max(var12, var18);
            }
        } else if (var18 < var12) {
            double var22 = var10 / var12 + 1.0;
            double var24 = (var12 - var10) / var12;
            double var30 = var18 / var12;
            double var26 = var30 * var30;
            double var14 = 2.0 / (Math.sqrt(var22 * var22 + var26) + Math.sqrt(var24 * var24 + var26));
            var28 = var10 * var14;
        } else {
            double var35 = var12 / var18;
            if (var35 == 0.0) {
                var28 = var10 * var12 / var18;
            } else {
                double var33 = var10 / var12 + 1.0;
                double var34 = (var12 - var10) / var12;
                double var31 = var33 * var35;
                double var8 = var34 * var35;
                double var32 = 1.0 / (Math.sqrt(var31 * var31 + 1.0) + Math.sqrt(var8 * var8 + 1.0));
                var28 = var10 * var32 * var35;
                var28 += var28;
            }
        }
        return var28;
    }

    static int compute_2X2(double var0, double var2, double var4, double[] var6, double[] var7, double[] var8, double[] var9, double[] var10, int var11) {
        double var40;
        double var12 = 2.0;
        double var14 = 1.0;
        double var65 = var6[0];
        double var63 = var6[1];
        double var55 = 0.0;
        double var57 = 0.0;
        double var59 = 0.0;
        double var61 = 0.0;
        double var36 = 0.0;
        double var44 = var0;
        double var38 = Math.abs(var0);
        double var48 = var4;
        double var42 = Math.abs(var4);
        int var18 = 1;
        boolean var21 = var42 > var38;
        if (var21) {
            var18 = 3;
            var44 = var4;
            var48 = var0;
            double var19 = var38;
            var38 = var42;
            var42 = var19;
        }
        if ((var40 = Math.abs(var2)) == 0.0) {
            var6[1] = var42;
            var6[0] = var38;
            var55 = 1.0;
            var57 = 1.0;
            var59 = 0.0;
            var61 = 0.0;
        } else {
            boolean var52 = true;
            if (var40 > var38) {
                var18 = 2;
                if (var38 / var40 < 1.110223024E-16) {
                    var52 = false;
                    var65 = var40;
                    var63 = var42 > 1.0 ? var38 / (var40 / var42) : var38 / var40 * var42;
                    var55 = 1.0;
                    var59 = var48 / var2;
                    var61 = 1.0;
                    var57 = var44 / var2;
                }
            }
            if (var52) {
                double var24 = var38 - var42;
                double var26 = var24 == var38 ? 1.0 : var24 / var38;
                double var28 = var2 / var44;
                double var34 = 2.0 - var26;
                double var50 = var28 * var28;
                double var53 = var34 * var34;
                double var32 = Math.sqrt(var53 + var50);
                double var30 = var26 == 0.0 ? Math.abs(var28) : Math.sqrt(var26 * var26 + var50);
                double var22 = (var32 + var30) * 0.5;
                if (var40 > var38) {
                    var18 = 2;
                    if (var38 / var40 < 1.110223024E-16) {
                        var52 = false;
                        var65 = var40;
                        var63 = var42 > 1.0 ? var38 / (var40 / var42) : var38 / var40 * var42;
                        var55 = 1.0;
                        var59 = var48 / var2;
                        var61 = 1.0;
                        var57 = var44 / var2;
                    }
                }
                if (var52) {
                    var24 = var38 - var42;
                    var26 = var24 == var38 ? 1.0 : var24 / var38;
                    var28 = var2 / var44;
                    var34 = 2.0 - var26;
                    var50 = var28 * var28;
                    var53 = var34 * var34;
                    var32 = Math.sqrt(var53 + var50);
                    var30 = var26 == 0.0 ? Math.abs(var28) : Math.sqrt(var26 * var26 + var50);
                    var22 = (var32 + var30) * 0.5;
                    var63 = var42 / var22;
                    var65 = var38 * var22;
                    var34 = var50 == 0.0 ? (var26 == 0.0 ? Transform3D.d_sign(var12, var44) * Transform3D.d_sign(var14, var2) : var2 / Transform3D.d_sign(var24, var44) + var28 / var34) : (var28 / (var32 + var34) + var28 / (var30 + var26)) * (var22 + 1.0);
                    var26 = Math.sqrt(var34 * var34 + 4.0);
                    var57 = 2.0 / var26;
                    var61 = var34 / var26;
                    var55 = (var57 + var61 * var28) / var22;
                    var59 = var48 / var44 * var61 / var22;
                }
            }
            if (var21) {
                var8[0] = var61;
                var7[0] = var57;
                var10[0] = var59;
                var9[0] = var55;
            } else {
                var8[0] = var55;
                var7[0] = var59;
                var10[0] = var57;
                var9[0] = var61;
            }
            if (var18 == 1) {
                var36 = Transform3D.d_sign(var14, var10[0]) * Transform3D.d_sign(var14, var8[0]) * Transform3D.d_sign(var14, var0);
            }
            if (var18 == 2) {
                var36 = Transform3D.d_sign(var14, var9[0]) * Transform3D.d_sign(var14, var8[0]) * Transform3D.d_sign(var14, var2);
            }
            if (var18 == 3) {
                var36 = Transform3D.d_sign(var14, var9[0]) * Transform3D.d_sign(var14, var7[0]) * Transform3D.d_sign(var14, var4);
            }
            var6[var11] = Transform3D.d_sign(var65, var36);
            double var16 = var36 * Transform3D.d_sign(var14, var0) * Transform3D.d_sign(var14, var4);
            var6[var11 + 1] = Transform3D.d_sign(var63, var16);
        }
        return 0;
    }

    static double compute_rot(double var0, double var2, double[] var4, double[] var5, int var6, int var7) {
        double var25;
        double var15;
        double var13;
        if (var2 == 0.0) {
            var13 = 1.0;
            var15 = 0.0;
            var25 = var0;
        } else if (var0 == 0.0) {
            var13 = 0.0;
            var15 = 1.0;
            var25 = var2;
        } else {
            double var21 = var0;
            double var23 = var2;
            double var18 = Transform3D.max(Math.abs(var0), Math.abs(var2));
            if (var18 >= 4.994797680505588E145) {
                int var32 = 0;
                while (var18 >= 4.994797680505588E145) {
                    ++var32;
                    var18 = Transform3D.max(Math.abs(var21 *= 2.002083095183101E-146), Math.abs(var23 *= 2.002083095183101E-146));
                }
                var25 = Math.sqrt(var21 * var21 + var23 * var23);
                var13 = var21 / var25;
                var15 = var23 / var25;
                for (int var31 = 1; var31 <= var32; ++var31) {
                    var25 *= 4.994797680505588E145;
                }
            } else if (!(var18 <= 2.002083095183101E-146)) {
                var25 = Math.sqrt(var0 * var0 + var2 * var2);
                var13 = var0 / var25;
                var15 = var2 / var25;
            } else {
                int var20 = 0;
                while (var18 <= 2.002083095183101E-146) {
                    ++var20;
                    var18 = Transform3D.max(Math.abs(var21 *= 4.994797680505588E145), Math.abs(var23 *= 4.994797680505588E145));
                }
                var25 = Math.sqrt(var21 * var21 + var23 * var23);
                var13 = var21 / var25;
                var15 = var23 / var25;
                for (int var17 = 1; var17 <= var20; ++var17) {
                    var25 *= 2.002083095183101E-146;
                }
            }
            if (Math.abs(var0) > Math.abs(var2) && var13 < 0.0) {
                var13 = -var13;
                var15 = -var15;
                var25 = -var25;
            }
        }
        var4[var6] = var15;
        var5[var6] = var13;
        return var25;
    }

    private static final double max3(double[] var0) {
        if (var0[0] > var0[1]) {
            return var0[0] > var0[2] ? var0[0] : var0[2];
        }
        return var0[1] > var0[2] ? var0[1] : var0[2];
    }

    private final void computeScales(boolean var1) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!var1 || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFDF;
                    return;
                }
                this.scales[1] = this.scales[2] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[0] = this.scales[2];
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
        }
        if (this.rot == null) {
            this.rot = new double[9];
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    private final void computeScaleRotation(boolean var1) {
        if (this.rot == null) {
            this.rot = new double[9];
        }
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!var1 || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.rot[0] = this.mat[0];
                    this.rot[1] = this.mat[1];
                    this.rot[2] = this.mat[2];
                    this.rot[3] = this.mat[4];
                    this.rot[4] = this.mat[5];
                    this.rot[5] = this.mat[6];
                    this.rot[6] = this.mat[8];
                    this.rot[7] = this.mat[9];
                    this.rot[8] = this.mat[10];
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFFF;
                    return;
                }
                double var6 = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                if (var6 == 0.0) {
                    this.compute_svd(this, this.scales, this.rot);
                    return;
                }
                this.scales[1] = this.scales[2] = var6;
                this.scales[0] = this.scales[2];
                var6 = 1.0 / var6;
                this.rot[0] = this.mat[0] * var6;
                this.rot[1] = this.mat[1] * var6;
                this.rot[2] = this.mat[2] * var6;
                this.rot[3] = this.mat[4] * var6;
                this.rot[4] = this.mat[5] * var6;
                this.rot[5] = this.mat[6] * var6;
                this.rot[6] = this.mat[8] * var6;
                this.rot[7] = this.mat[9] * var6;
                this.rot[8] = this.mat[10] * var6;
                this.dirtyBits &= 0xFFFFFFFF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                if (this.scales[0] != 0.0 && this.scales[1] != 0.0 && this.scales[2] != 0.0) {
                    double var2 = 1.0 / this.scales[0];
                    this.rot[0] = this.mat[0] * var2;
                    this.rot[3] = this.mat[4] * var2;
                    this.rot[6] = this.mat[8] * var2;
                    var2 = 1.0 / this.scales[1];
                    this.rot[1] = this.mat[1] * var2;
                    this.rot[4] = this.mat[5] * var2;
                    this.rot[7] = this.mat[9] * var2;
                    var2 = 1.0 / this.scales[2];
                    this.rot[2] = this.mat[2] * var2;
                    this.rot[5] = this.mat[6] * var2;
                    this.rot[8] = this.mat[10] * var2;
                    this.dirtyBits &= 0xFFFFFFFF;
                    return;
                }
                this.compute_svd(this, this.scales, this.rot);
                return;
            }
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    final void getRotation(Transform3D var1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        var1.mat[14] = 0.0;
        var1.mat[13] = 0.0;
        var1.mat[12] = 0.0;
        var1.mat[11] = 0.0;
        var1.mat[7] = 0.0;
        var1.mat[3] = 0.0;
        var1.mat[15] = 1.0;
        var1.mat[0] = this.rot[0];
        var1.mat[1] = this.rot[1];
        var1.mat[2] = this.rot[2];
        var1.mat[4] = this.rot[3];
        var1.mat[5] = this.rot[4];
        var1.mat[6] = this.rot[5];
        var1.mat[8] = this.rot[6];
        var1.mat[9] = this.rot[7];
        var1.mat[10] = this.rot[8];
        var1.dirtyBits = 255;
    }

    final void setOrthoDirtyBit() {
        this.dirtyBits = 255;
        this.type = 0;
    }

    private final boolean isInfOrNaN() {
        double var1 = 0.0;
        for (int var3 = 0; var3 < 16; ++var3) {
            var1 *= this.mat[var3];
        }
        return var1 != 0.0;
    }

    private final boolean isInfOrNaN(Quat4f var1) {
        return Float.isNaN(var1.x) || Float.isInfinite(var1.x) || Float.isNaN(var1.y) || Float.isInfinite(var1.y) || Float.isNaN(var1.z) || Float.isInfinite(var1.z) || Float.isNaN(var1.w) || Float.isInfinite(var1.w);
    }

    private boolean isInfOrNaN(Quat4d var1) {
        return Double.isNaN(var1.x) || Double.isInfinite(var1.x) || Double.isNaN(var1.y) || Double.isInfinite(var1.y) || Double.isNaN(var1.z) || Double.isInfinite(var1.z) || Double.isNaN(var1.w) || Double.isInfinite(var1.w);
    }

    private boolean isInfOrNaN(AxisAngle4f var1) {
        return Float.isNaN(var1.x) || Float.isInfinite(var1.x) || Float.isNaN(var1.y) || Float.isInfinite(var1.y) || Float.isNaN(var1.z) || Float.isInfinite(var1.z) || Float.isNaN(var1.angle) || Float.isInfinite(var1.angle);
    }

    private boolean isInfOrNaN(AxisAngle4d var1) {
        return Double.isNaN(var1.x) || Double.isInfinite(var1.x) || Double.isNaN(var1.y) || Double.isInfinite(var1.y) || Double.isNaN(var1.z) || Double.isInfinite(var1.z) || Double.isNaN(var1.angle) || Double.isInfinite(var1.angle);
    }

    private boolean isInfOrNaN(double var1) {
        return Double.isNaN(var1) || Double.isInfinite(var1);
    }

    private boolean isInfOrNaN(Vector3f var1) {
        return Float.isNaN(var1.x) || Float.isInfinite(var1.x) || Float.isNaN(var1.y) || Float.isInfinite(var1.y) || Float.isNaN(var1.z) || Float.isInfinite(var1.z);
    }

    private boolean isInfOrNaN(Vector3d var1) {
        return Double.isNaN(var1.x) || Double.isInfinite(var1.x) || Double.isNaN(var1.y) || Double.isInfinite(var1.y) || Double.isNaN(var1.z) || Double.isInfinite(var1.z);
    }
}

