/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.pallet.impl.internal.InternalTypeConversion;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.domain.value.Pose;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class FeaturePosition {
    private Point3d toolPosition;
    private Point3d toolAxisAngle;
    private Pose6d baseToFeature;
    private final String palletFeatureName;

    public FeaturePosition(String palletFeatureName, Pose baseToFeature, Pose refPose) {
        this.palletFeatureName = palletFeatureName;
        if (baseToFeature != null && refPose != null) {
            this.baseToFeature = InternalTypeConversion.getPolyScopePose(baseToFeature);
            Pose6d pose = InternalTypeConversion.getPolyScopePose(refPose);
            this.toolPosition = new Point3d((Tuple3d)pose.getPos());
            this.toolAxisAngle = new Point3d((Tuple3d)pose.getRot());
        }
    }

    public FeaturePosition(String palletFeatureName, Point3d toolPosition, Point3d toolAxisAngle, Pose6d baseToFeature) {
        this.palletFeatureName = palletFeatureName;
        this.toolPosition = toolPosition;
        this.toolAxisAngle = toolAxisAngle;
        this.baseToFeature = baseToFeature;
    }

    public Point3d getActualToolPosition() {
        Pose6d pose6d = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.toolPosition, (Tuple3d)this.toolAxisAngle));
        return new Point3d((Tuple3d)pose6d.getPos());
    }

    public Point3d getActualToolAxisAngle() {
        Pose6d pose6d = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.toolPosition, (Tuple3d)this.toolAxisAngle));
        return new Point3d((Tuple3d)pose6d.getRot());
    }

    public Point3d getToolPosition() {
        return this.toolPosition;
    }

    public Point3d getToolAxisAngle() {
        return this.toolAxisAngle;
    }

    private Pose6d applyRelativeFeatureTransformToToolPose(Pose6d baseToTool) {
        GeomFeature geomFeature = InternalTypeConversion.getFeature(this.palletFeatureName);
        if (geomFeature == null) {
            return baseToTool;
        }
        Transform3D tBaseNewFeature = geomFeature.getTransform();
        Transform3D tFeatureTool = this.getWaypointInFeatureCoordinates(baseToTool);
        Transform3D tFeatureTransformedBaseToTool = new Transform3D();
        tFeatureTransformedBaseToTool.mul(tBaseNewFeature, tFeatureTool);
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)tFeatureTransformedBaseToTool);
    }

    private Transform3D getWaypointInFeatureCoordinates(Pose6d poseInBase) {
        Transform3D tBaseTool = Pose6dTransformUtils.getTransform3D((Pose6d)poseInBase);
        Pose6d baseToFeatureTransform = this.baseToFeature;
        Transform3D tFeatureTool = new Transform3D();
        Transform3D tFeatureBase = new Transform3D();
        tFeatureBase.invert(Pose6dTransformUtils.getTransform3D((Pose6d)baseToFeatureTransform));
        tFeatureTool.mul(tFeatureBase, tBaseTool);
        return tFeatureTool;
    }

    public boolean isDefined() {
        return this.toolPosition != null && this.toolAxisAngle != null && this.baseToFeature != null;
    }

    public Pose6d getBaseToFeature() {
        return this.baseToFeature;
    }

    public String toString() {
        return "FeaturePosition{palletFeature=" + this.palletFeatureName + ", toolPosition=" + this.toolPosition + ", toolAxisAngle=" + this.toolAxisAngle + ", baseToFeature=" + this.baseToFeature + '}';
    }
}

