/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.UpdateChildrenStrategy;
import com.ur.polyscope.urcaps.programnodes.ProgramNodeProxy;
import com.ur.swing.SwingUtil;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.builder.MoveLConfigBuilder;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import gui.program.MoveNode;
import gui.program.services.geom.GeomFeatureReferenceBase;

final class FeatureUpdateVisitor
extends ProgramNodeVisitor {
    private final UpdateChildrenStrategy updateStrategy;
    private final Feature feature;
    private final boolean undoable;
    private final String featureName;
    private final UndoRedoManager undoRedoManager;
    private final PalletFeatureService palletFeatureService;
    private final SimpleValueFactory valueFactory;

    FeatureUpdateVisitor(UpdateChildrenStrategy updateStrategy, Feature feature, boolean undoable, String featureName, UndoRedoManager undoRedoManager, PalletFeatureService palletFeatureService, SimpleValueFactory valueFactory) {
        this.updateStrategy = updateStrategy;
        this.feature = feature;
        this.undoable = undoable;
        this.featureName = featureName;
        this.undoRedoManager = undoRedoManager;
        this.palletFeatureService = palletFeatureService;
        this.valueFactory = valueFactory;
    }

    public void visit(com.ur.urcap.api.domain.program.nodes.builtin.MoveNode moveNode, int index, int depth) {
        ProgramNodeProxy mn = (ProgramNodeProxy)moveNode;
        MoveNode realProgramNode = (MoveNode)mn.getRealProgramNode();
        GeomFeatureReferenceBase featureReference = realProgramNode.getFeatureReference();
        if (featureReference != null) {
            boolean isUsingFeature;
            int commonPrefixLength = this.commonPrefixLength(featureReference.toString(), this.featureName);
            boolean bl = isUsingFeature = commonPrefixLength >= 13;
            if (isUsingFeature || this.updateStrategy == UpdateChildrenStrategy.FORCE_UPDATE) {
                this.updateMoveNode(isUsingFeature, moveNode);
            }
        }
    }

    private void updateMoveNode(boolean isUsingFeature, com.ur.urcap.api.domain.program.nodes.builtin.MoveNode moveNode) {
        if (!isUsingFeature) {
            MoveNodeConfig config = moveNode.getConfig();
            if (this.undoable) {
                SwingUtil.invokeAndWait(() -> this.undoRedoManager.recordChanges(() -> moveNode.setConfig(config)));
            } else {
                moveNode.setConfig(config);
            }
            return;
        }
        MoveNodeConfig.ConfigType moveType = moveNode.getConfig().getConfigType();
        if (moveType == MoveNodeConfig.ConfigType.MOVE_J) {
            this.palletFeatureService.setFeatureOnMoveJHack(this.feature, moveNode);
        } else if (moveType == MoveNodeConfig.ConfigType.MOVE_L) {
            MoveLMoveNodeConfig moveLConfig = this.createMoveLConfig(this.feature, moveNode);
            if (this.undoable) {
                SwingUtil.invokeAndWait(() -> this.undoRedoManager.recordChanges(() -> moveNode.setConfig((MoveNodeConfig)moveLConfig)));
            } else {
                moveNode.setConfig((MoveNodeConfig)moveLConfig);
            }
        }
    }

    private MoveLMoveNodeConfig createMoveLConfig(Feature feature, com.ur.urcap.api.domain.program.nodes.builtin.MoveNode moveNode) {
        Acceleration toolAcceleration;
        Speed toolSpeed;
        MoveNodeConfig existingConfig = moveNode.getConfig();
        if (existingConfig != null && existingConfig.getConfigType() == MoveNodeConfig.ConfigType.MOVE_L) {
            MoveLMotionParameters motionParameters = ((MoveLMoveNodeConfig)existingConfig).getMotionParameters();
            toolSpeed = motionParameters.getToolSpeed();
            toolAcceleration = motionParameters.getToolAcceleration();
        } else {
            toolSpeed = this.valueFactory.createSpeed(250.0, Speed.Unit.MM_S);
            toolAcceleration = this.valueFactory.createAcceleration(1200.0, Acceleration.Unit.MM_S2);
        }
        MoveLConfigBuilder builder = moveNode.getConfigBuilders().createMoveLConfigBuilder().setToolSpeed(toolSpeed, ErrorHandler.AUTO_CORRECT).setToolAcceleration(toolAcceleration, ErrorHandler.AUTO_CORRECT);
        if (feature != null) {
            builder.setFeature(feature);
        }
        return builder.build();
    }

    private int commonPrefixLength(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return minLength;
    }
}

