/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Collection;
import javax.inject.Inject;

public final class InternalTypeConversion {
    private static final String BASE_VIEW_NAME = "Joint_0_name";
    private static final String TOOL_VIEW_NAME = "Joint_6_name";
    private static final Pose6d ZERO_POSE_6D = new Pose6d();
    private static FeatureModel featureModel;
    private static FeatureWrapService featureWrapService;

    private InternalTypeConversion() {
    }

    @Inject
    public static void setFeatureWrapService(FeatureWrapService featureWrapService) {
        InternalTypeConversion.featureWrapService = featureWrapService;
    }

    @Inject
    public static void setFeatureModel(FeatureModel featureModel) {
        InternalTypeConversion.featureModel = featureModel;
    }

    public static JointPositionVector getPolyScopeJPV(JointPositions jointPositions) {
        JointPosition[] allJointPositions = jointPositions.getAllJointPositions();
        return new JointPositionVector(allJointPositions[0].getPosition(Angle.Unit.RAD), allJointPositions[1].getPosition(Angle.Unit.RAD), allJointPositions[2].getPosition(Angle.Unit.RAD), allJointPositions[3].getPosition(Angle.Unit.RAD), allJointPositions[4].getPosition(Angle.Unit.RAD), allJointPositions[5].getPosition(Angle.Unit.RAD));
    }

    public static GeomFeature getFeature(String f) {
        Collection geomFeatures = featureModel.getGeomFeatures(feat -> feat.getName().equals(f));
        Object feature = !geomFeatures.isEmpty() ? (Feature)geomFeatures.iterator().next() : (featureModel.getBaseFeature().getName().equals(f) ? featureModel.getBaseFeature() : featureModel.getToolFeature());
        return (GeomFeature)featureWrapService.unwrapFeature(feature);
    }

    public static String getFeatureScriptPose(String featureName) {
        GeomFeature geomFeature = InternalTypeConversion.getFeature(featureName);
        String geomFeatureName = geomFeature.getName();
        String featureStr = geomFeature.toString();
        if (geomFeatureName.equals(BASE_VIEW_NAME)) {
            featureStr = ZERO_POSE_6D.toString();
        } else if (geomFeatureName.equals(TOOL_VIEW_NAME)) {
            featureStr = "get_forward_kin()";
        }
        return featureStr;
    }

    public static Pose6d getPolyScopePose(Pose pose) {
        double[] doubles = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        return new Pose6d(doubles);
    }
}

