/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.ProgramFeature;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.UpdateChildrenStrategy;
import com.ur.polyscope.pallet.impl.internal.FeatureUpdateVisitor;
import com.ur.polyscope.pallet.impl.internal.InternalTypeConversion;
import com.ur.polyscope.pallet.impl.internal.PalletProgramFeatureImpl;
import com.ur.polyscope.urcaps.programnodes.ProgramNodeProxy;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.domain.feature.BaseFeature;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureModel;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.program.MoveNode;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReferenceBase;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class PalletFeatureServiceImpl
implements PalletFeatureService {
    private final FeatureWrapService featureWrapService;
    private final NamingService namingService;
    private final ProgramFeatureService programFeatureService;
    private final FeatureModel featureModel;
    private final RobotInstallationLookupService installationLookupService;
    private final SimpleValueFactory valueFactory;
    private final ProgramReferenceService programReferenceService;

    @Inject
    public PalletFeatureServiceImpl(FeatureWrapService featureWrapService, NamingService namingService, ProgramFeatureService programFeatureService, FeatureModel featureModel, RobotInstallationLookupService installationLookupService, SimpleValueFactory valueFactory, ProgramReferenceService programReferenceService) {
        this.featureWrapService = featureWrapService;
        this.namingService = namingService;
        this.programFeatureService = programFeatureService;
        this.featureModel = featureModel;
        this.installationLookupService = installationLookupService;
        this.valueFactory = valueFactory;
        this.programReferenceService = programReferenceService;
    }

    public ProgramNodeVisitor createFeatureUpdateVisitor(UpdateChildrenStrategy updateStrategy, Feature feature, boolean undoable, String featureName, UndoRedoManager undoRedoManager) {
        return new FeatureUpdateVisitor(updateStrategy, feature, undoable, featureName, undoRedoManager, this, this.valueFactory);
    }

    public Feature wrapFeature(SpatialFeature spatialFeature) {
        return this.featureWrapService.wrapFeature(spatialFeature);
    }

    public SpatialFeature unwrapFeature(Feature feature) {
        return this.featureWrapService.unwrapFeature(feature);
    }

    public PalletProgramFeature getFeature(String featureName) {
        GeomFeature feature = InternalTypeConversion.getFeature(featureName);
        return feature instanceof PalletProgramFeature ? (PalletProgramFeature)feature : null;
    }

    public String getFeatureScriptPose(String featureName) {
        return InternalTypeConversion.getFeatureScriptPose(featureName);
    }

    public PalletProgramFeature getFeature(Variable featureVariable) {
        if (featureVariable != null) {
            String displayName = featureVariable.getDisplayName();
            List entitiesWithName = this.namingService.getEntitiesWithName(displayName);
            return entitiesWithName.isEmpty() ? null : (PalletProgramFeature)entitiesWithName.get(0);
        }
        return null;
    }

    public PalletProgramFeature createProgramFeature() {
        return new PalletProgramFeatureImpl(this.namingService);
    }

    public void addProgramFeature(PalletProgramFeature palletProgramFeature) {
        this.programFeatureService.addProgramFeature((ProgramFeature)palletProgramFeature);
    }

    public String getMoveNodeFeatureName(com.ur.urcap.api.domain.program.nodes.builtin.MoveNode moveNode) {
        ProgramNodeProxy mn = (ProgramNodeProxy)moveNode;
        MoveNode realMoveNode = (MoveNode)mn.getRealProgramNode();
        return realMoveNode.getFeatureReference().toString();
    }

    public Collection<Feature> getApplicablePalletFeatures() {
        Collection features = this.featureModel.getGeomFeatures(feature -> {
            if (!feature.isDefined()) {
                return false;
            }
            SpatialFeature spatialFeature = this.unwrapFeature((Feature)feature);
            if (spatialFeature instanceof ProgramFeature) {
                return false;
            }
            return !(spatialFeature instanceof GeomFeature) || spatialFeature.isFirstLevelFeature();
        });
        BaseFeature baseFeature = this.featureModel.getBaseFeature();
        features.add(baseFeature);
        return features;
    }

    public double getMountingTiltAngle() {
        return ((SetupFeatureContainerNode)this.installationLookupService.getInstallation().getComponent(SetupFeatureContainerNode.class)).getWorldTransform().getMountingTiltAngle();
    }

    public void setFeatureOnMoveJHack(Feature feature, com.ur.urcap.api.domain.program.nodes.builtin.MoveNode moveNode) {
        ProgramNodeProxy mn = (ProgramNodeProxy)moveNode;
        MoveNode realProgramNode = (MoveNode)mn.getRealProgramNode();
        realProgramNode.setFeatureReference((GeomFeatureReferenceBase)this.programReferenceService.getGeomFeatureReference(feature.getName()));
    }
}

