/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.impl.internal.InternalTypeConversion;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.polyscope.urcaps.programnodes.ProgramNodeProxy;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.CalibrationStatus;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredWaypointNode;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PalletMotionServiceImpl
implements PalletMotionService {
    private final KinematicsFactory kinematicsFactory;
    private final Recipe<KinematicsCalibration> calibrationRecipe;
    private final InverseKinematicProviderExt rpc;

    @Inject
    public PalletMotionServiceImpl(KinematicsFactory kinematicsFactory, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, InverseKinematicProviderExt rpc) {
        this.kinematicsFactory = kinematicsFactory;
        this.calibrationRecipe = calibrationRecipe;
        this.rpc = rpc;
    }

    public Pose6d getInternalPoseFromDataModel(DataModel dataModel, String s) {
        MeasuredPosition position = this.getMeasuredPosition(dataModel, s);
        if (position != null) {
            return new Pose6d((Tuple3d)position.getToolPosition(), (Tuple3d)position.getToolAxisAngle());
        }
        return null;
    }

    public JointPositionVector getJointPositionVectorFromDataModel(DataModel model, String keyPrefix) {
        MeasuredPosition position = this.getMeasuredPosition(model, keyPrefix);
        if (position != null) {
            return position.getJointPositionVector();
        }
        return null;
    }

    public void setPositionInDataModel(Pose pose, JointPositions jointPositions, DataModel model, String palletFeatureName, String keyPrefix) {
        GeomFeature geomFeature = InternalTypeConversion.getFeature(palletFeatureName);
        Transform3D baseToFeatureTransform = geomFeature.getTransform();
        Pose6d featurePose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)baseToFeatureTransform);
        KinematicsCalibration kinematicsCalibration = (KinematicsCalibration)this.calibrationRecipe.lastProvider().get();
        Transform3D tcpOffset = PalletMotionServiceImpl.calculateTCPOffset(pose, jointPositions, kinematicsCalibration);
        Pose6d tcpPose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)tcpOffset);
        PalletMotionServiceImpl.kinematicsToModel(kinematicsCalibration, model, keyPrefix);
        model.set(PalletMotionServiceImpl.getKey("jointpositions", keyPrefix), jointPositions);
        model.set(PalletMotionServiceImpl.getKey("baseToFeature", keyPrefix), featurePose.toArray());
        model.set(PalletMotionServiceImpl.getKey("TCPOffset", keyPrefix), tcpPose.toArray());
    }

    public Pose6d getPose6dEquivalentOfTransform3D(Transform3D transform) {
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)transform);
    }

    public Pose6d getWaypointPointPoseInFeatureCoordinates(WaypointNode waypointNode) {
        ProgramNodeProxy mwpn = (ProgramNodeProxy)waypointNode;
        MeasuredWaypointNode measuredWaypointNode = (MeasuredWaypointNode)mwpn.getRealProgramNode();
        return measuredWaypointNode.getWaypointPoseInFeatureCoordinates();
    }

    public Transform3D getBaseToFeatureTransform(WaypointNode waypointNode) {
        ProgramNodeProxy mwpn = (ProgramNodeProxy)waypointNode;
        MeasuredWaypointNode measuredWaypointNode = (MeasuredWaypointNode)mwpn.getRealProgramNode();
        return measuredWaypointNode.getBaseToFeatureTransform();
    }

    public JointPositionVector getInverseKinematics(Point3d position, Point3d angle, JointPositionVector qNear) {
        return this.rpc.getInverseKinematics(position, angle, qNear);
    }

    public JointPositionVector getInverseKinematics(Pose6d targetPose, JointPositionVector qNear) {
        return this.rpc.getInverseKinematics(targetPose, qNear);
    }

    public Set<Vector3d> displacePoses(Set<Vector3d> positionsAsVector3d, double displacementForLayer, String palletFeatureName) {
        GeomFeature palletGeomFeature = InternalTypeConversion.getFeature(palletFeatureName);
        Vector3d translationVector = PalletMotionServiceImpl.createTranslationVector(displacementForLayer, palletGeomFeature);
        for (Vector3d vector3d : positionsAsVector3d) {
            vector3d.add((Tuple3d)translationVector);
        }
        return positionsAsVector3d;
    }

    public Tuple3d displacePose(Tuple3d toolPosition, double displacement, String palletFeatureName) {
        GeomFeature palletGeomFeature = InternalTypeConversion.getFeature(palletFeatureName);
        toolPosition.add((Tuple3d)PalletMotionServiceImpl.createTranslationVector(displacement, palletGeomFeature));
        return toolPosition;
    }

    private static Vector3d createTranslationVector(double displacement, GeomFeature palletGeomFeature) {
        Transform3D featureTransform = palletGeomFeature.getTransform();
        featureTransform.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        Transform3D directionTransform = new Transform3D();
        directionTransform.setTranslation(new Vector3d(0.0, 0.0, 1.0));
        featureTransform.mul(directionTransform);
        Vector3d translationVector = new Vector3d();
        featureTransform.get(translationVector);
        translationVector.scale(displacement * 0.001);
        return translationVector;
    }

    private KinematicsCalibration modelToKinematics(DataModel model, String keyPrefix) {
        double[] deltaTheta = model.get(PalletMotionServiceImpl.getKey("calibrationDeltaTheta", keyPrefix), (double[])null);
        double[] a = model.get(PalletMotionServiceImpl.getKey("calibrationA", keyPrefix), (double[])null);
        double[] d = model.get(PalletMotionServiceImpl.getKey("calibrationD", keyPrefix), (double[])null);
        double[] alpha = model.get(PalletMotionServiceImpl.getKey("calibrationAlpha", keyPrefix), (double[])null);
        if (deltaTheta != null && a != null && d != null && alpha != null) {
            return this.kinematicsFactory.createKinematicsCalibration(deltaTheta, a, d, alpha, model.get(PalletMotionServiceImpl.getKey("calibrationJointChecksum", keyPrefix), (int[])null), CalibrationStatus.byId((int)model.get(PalletMotionServiceImpl.getKey("calibrationStatus", keyPrefix), 0)), model.get(PalletMotionServiceImpl.getKey("calibrationValidChecksum", keyPrefix), false));
        }
        return null;
    }

    private static Transform3D calculateTCPOffset(Pose pose, JointPositions jointPositions, KinematicsCalibration kinematicsCalibration) {
        Transform3D tcpOffset;
        Pose6d polyScopePose = InternalTypeConversion.getPolyScopePose(pose);
        Transform3D baseToTcpPose = Pose6dTransformUtils.getTransform3D((Pose6d)polyScopePose);
        JointPositionVector polyScopeJPV = InternalTypeConversion.getPolyScopeJPV(jointPositions);
        Transform3D baseToOutputFlange = kinematicsCalibration.getBaseToEnd(polyScopeJPV);
        try {
            tcpOffset = new Transform3D(baseToOutputFlange);
            tcpOffset.invert();
            tcpOffset.mul(baseToTcpPose);
        }
        catch (Exception e) {
            Log.error((String)"Inversion of baseToOutputFlange transform failed in TCP computation", (Throwable)e);
            tcpOffset = new Transform3D();
        }
        return tcpOffset;
    }

    private MeasuredPosition getMeasuredPosition(DataModel model, String keyPrefix) {
        JointPositions jointPositions = model.get(PalletMotionServiceImpl.getKey("jointpositions", keyPrefix), (JointPositions)null);
        double[] doubles = PalletMotionServiceImpl.getTCPOffset(model, keyPrefix);
        if (jointPositions != null && doubles != null) {
            Pose6d offset = new Pose6d(doubles);
            Transform3D tcpOffset = Pose6dTransformUtils.getTransform3D((Pose6d)offset);
            KinematicsCalibration kinematicsCalibration = this.modelToKinematics(model, keyPrefix);
            return new MeasuredPosition(InternalTypeConversion.getPolyScopeJPV(jointPositions), tcpOffset, kinematicsCalibration);
        }
        return null;
    }

    private static double[] getTCPOffset(DataModel model, String keyPrefix) {
        return model.get(PalletMotionServiceImpl.getKey("TCPOffset", keyPrefix), (double[])null);
    }

    private static void kinematicsToModel(KinematicsCalibration kinematicsCalibration, DataModel model, String keyPrefix) {
        model.set(PalletMotionServiceImpl.getKey("calibrationDeltaTheta", keyPrefix), kinematicsCalibration.getDeltaTheta());
        model.set(PalletMotionServiceImpl.getKey("calibrationA", keyPrefix), kinematicsCalibration.getA());
        model.set(PalletMotionServiceImpl.getKey("calibrationD", keyPrefix), kinematicsCalibration.getD());
        model.set(PalletMotionServiceImpl.getKey("calibrationAlpha", keyPrefix), kinematicsCalibration.getAlpha());
        model.set(PalletMotionServiceImpl.getKey("calibrationJointChecksum", keyPrefix), kinematicsCalibration.getJointChecksum());
        model.set(PalletMotionServiceImpl.getKey("calibrationStatus", keyPrefix), kinematicsCalibration.getStatus().getId());
        model.set(PalletMotionServiceImpl.getKey("calibrationValidChecksum", keyPrefix), kinematicsCalibration.isValidChecksum());
    }

    private static String getKey(String baseKey, String keyPrefix) {
        if (!keyPrefix.isEmpty()) {
            return keyPrefix + "_" + baseKey;
        }
        return baseKey;
    }
}

