/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pallet.PalletNamingService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableModel;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.domain.InstallationVariables;
import gui.program.position.WaypointNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import gui.tools.LanguagePack;
import java.util.Collection;
import javax.inject.Inject;

public class PalletNamingServiceImpl
implements PalletNamingService {
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    private final NamingService namingService;
    private final InstallationComponentLookup installationComponentLookup;

    @Inject
    public PalletNamingServiceImpl(WaypointNodeValidationStrategyProvider validationStrategyProvider, NamingService namingService, InstallationComponentLookup installationComponentLookup) {
        this.validationStrategyProvider = validationStrategyProvider;
        this.namingService = namingService;
        this.installationComponentLookup = installationComponentLookup;
    }

    public ValidationStrategy getWaypointNameValidator() {
        return this.validationStrategyProvider.getWaypointNameValidator();
    }

    public boolean isWaypointNameValid(String nameCandidate) {
        return !this.namingService.isNameUsed(WaypointNode.class, nameCandidate);
    }

    public String getUniqueFeatureName(String nameCandidate) {
        String result = nameCandidate;
        if (this.namingService.isNameUsed(GeomFeature.class, result)) {
            result = this.namingService.makeUniqueName(GeomFeature.class, nameCandidate);
        }
        return result;
    }

    public String getVariableAlreadyExistsMessage() {
        return LanguagePack.getTextResource().variableNameAlreadyExists();
    }

    public Variable getFeatureVariable(PalletProgramFeature palletProgramFeature, VariableModel variableModel) {
        Collection all = variableModel.get(variable -> {
            String scriptName = ((AbstractVariable)variable).getScriptName();
            return scriptName.equals(palletProgramFeature.getName());
        });
        return (Variable)all.iterator().next();
    }

    public Variable createInstallationVariable(String name, VariableModel variableModel) {
        InstallationVariables variables = (InstallationVariables)this.installationComponentLookup.get(InstallationVariables.class).get();
        InstallationVariable variable = variables.addInstallationVariable(name, "1");
        this.namingService.registerNamedEntity((NamedEntity)variable);
        Variable[] result = new Variable[1];
        variableModel.get(v -> v.getType() == Variable.Type.VALUE_PERSISTED && v.getDisplayName().equals(variable.getName())).stream().findFirst().ifPresent(v -> {
            result[0] = v;
        });
        return result[0];
    }

    public void updateInstallationVariableName(String oldName, String newName) {
        InstallationVariable installVar = this.getInstallationVariableByName(oldName);
        this.namingService.updateName((NamedEntity)installVar, installVar.getName(), newName);
        installVar.setName(newName);
    }

    public void updateInstallationVariableValue(String variableName, String value) {
        InstallationVariable installVar = this.getInstallationVariableByName(variableName);
        installVar.setValue(value);
    }

    public String getInstallationVariableValue(String variableName) {
        InstallationVariable installVar = this.getInstallationVariableByName(variableName);
        return installVar != null ? installVar.getValue() : null;
    }

    public void removeInstallationVariable(String variableName) {
        InstallationVariables variables = (InstallationVariables)this.installationComponentLookup.get(InstallationVariables.class).get();
        this.namingService.deregisterNamedEntity((NamedEntity)variables.getInstallationVariableByName(variableName));
        variables.removeInstallationVariable(variableName);
    }

    private InstallationVariable getInstallationVariableByName(String variableName) {
        return ((InstallationVariables)this.installationComponentLookup.get(InstallationVariables.class).get()).getInstallationVariableByName(variableName);
    }
}

