/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.internal;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.impl.internal.FeaturePosition;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.domain.value.Pose;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PalletProgramFeatureImpl
extends GeomFeature
implements PalletProgramFeature {
    private boolean defined = false;
    private FeaturePosition featurePosition;
    private final NamingService namingService;

    public PalletProgramFeatureImpl(NamingService namingService) {
        this.namingService = namingService;
    }

    public void recalculateTransform() {
        if (this.featurePosition == null || !this.featurePosition.isDefined()) {
            return;
        }
        Transform3D t3d = new Transform3D();
        Vector3d axisAnglePoint = new Vector3d((Tuple3d)this.featurePosition.getActualToolAxisAngle());
        AxisAngle4d aaPoint = new AxisAngle4d(axisAnglePoint, axisAnglePoint.length());
        t3d.set(aaPoint);
        Vector3d posv = new Vector3d((Tuple3d)this.featurePosition.getActualToolPosition());
        t3d.setTranslation(posv);
        this.setNewTransform(t3d);
    }

    public Transform3D getTransform() {
        this.recalculateTransform();
        return super.getTransform();
    }

    public boolean isFirstLevelFeature() {
        return true;
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        boolean returnValue = false;
        if (entityToCompareTo instanceof PalletProgramFeatureImpl) {
            PalletProgramFeatureImpl node = (PalletProgramFeatureImpl)entityToCompareTo;
            if (!this.isUndefined() && !node.isUndefined() && node.featurePosition == this.featurePosition) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public ToolPosition getSpatialPose() {
        double[] p = this.getPoseAsArray();
        return new ToolPosition(p[0], p[1], p[2], p[3], p[4], p[5]);
    }

    private double[] getPoseAsArray() {
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)this.getTransform()).toArray();
    }

    public void setPosition(String palletFeatureName, Point3d toolPosition, Point3d toolAxisAngle, Pose6d baseToFeature) {
        this.featurePosition = new FeaturePosition(palletFeatureName, toolPosition, toolAxisAngle, baseToFeature);
        this.recalculateTransform();
        this.defined = this.featurePosition.isDefined();
    }

    public void setPosition(Pose baseToFeature, Pose refPose, String palletFeatureName) {
        this.featurePosition = new FeaturePosition(palletFeatureName, baseToFeature, refPose);
        this.recalculateTransform();
        this.defined = this.featurePosition.isDefined();
    }

    public void resetPosition() {
        this.featurePosition = null;
        this.defined = false;
    }

    protected void featureViewNeedsToBeUpdated() {
    }

    public void environmentChange() {
    }

    public boolean isHiddenSubFeature() {
        return false;
    }

    public boolean isUndefined() {
        return !this.defined;
    }

    public boolean isVariable() {
        return true;
    }

    public Pose6d getBaseToFeature() {
        return this.featurePosition.getBaseToFeature();
    }

    public Point3d getToolPosition() {
        return this.featurePosition.getToolPosition();
    }

    public Point3d getToolAxisAngle() {
        return this.featurePosition.getToolAxisAngle();
    }

    public void setSpatialPose(ToolPosition pose) {
    }

    public void setName(String newName) {
        super.setName(newName);
        this.namingService.registerNamedEntity((NamedEntity)this);
    }
}

