/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="step2.png")
    public static Icon step2() {
        return ImageResource.tryGetImage("step2.png");
    }

    @Key(value="step1.png")
    public static Icon step1() {
        return ImageResource.tryGetImage("step1.png");
    }

    @Key(value="info_icon_20x20.png")
    public static Icon infoIcon20x20() {
        return ImageResource.tryGetImage("info_icon_20x20.png");
    }

    @Key(value="next_step_horizontal.png")
    public static Icon nextStepHorizontal() {
        return ImageResource.tryGetImage("next_step_horizontal.png");
    }

    @Key(value="next_step.png")
    public static Icon nextStep() {
        return ImageResource.tryGetImage("next_step.png");
    }

    @Key(value="remove.png")
    public static Icon remove() {
        return ImageResource.tryGetImage("remove.png");
    }

    @Key(value="step2small.png")
    public static Icon step2small() {
        return ImageResource.tryGetImage("step2small.png");
    }

    @Key(value="step1small.png")
    public static Icon step1small() {
        return ImageResource.tryGetImage("step1small.png");
    }

    @Key(value="approve.png")
    public static Icon approve() {
        return ImageResource.tryGetImage("approve.png");
    }

    @Key(value="step3.png")
    public static Icon step3() {
        return ImageResource.tryGetImage("step3.png");
    }

    @Key(value="step3small.png")
    public static Icon step3small() {
        return ImageResource.tryGetImage("step3small.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ImageResource.tryGetImage("step2.png");
            ImageResource.tryGetImage("step1.png");
            ImageResource.tryGetImage("info_icon_20x20.png");
            ImageResource.tryGetImage("next_step_horizontal.png");
            ImageResource.tryGetImage("next_step.png");
            ImageResource.tryGetImage("remove.png");
            ImageResource.tryGetImage("step2small.png");
            ImageResource.tryGetImage("step1small.png");
            ImageResource.tryGetImage("approve.png");
            ImageResource.tryGetImage("step3.png");
            ImageResource.tryGetImage("step3small.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

