/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.content.LicenseRepository;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.legacy.LegacyLicense;
import com.ur.polyscope.license.internal.content.model.legacy.UrcapEntryContent;
import com.ur.polyscope.license.internal.content.model.v1.Feature;
import com.ur.polyscope.license.internal.content.model.v1.LicenseContent;
import com.ur.polyscope.license.internal.content.model.v1.LicenseV1;
import com.ur.polyscope.license.internal.util.DateVerifier;
import com.ur.util.logging.Log;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.io.File;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

@Singleton
public class LicenseManagerImpl
implements LicenseManagerInternal {
    private final LicenseRepository licenseRepository;
    private RobotMessageProducer robotMessageProducer;

    @Inject
    public LicenseManagerImpl(LicenseRepository licenseRepository, RobotMessageProducer robotMessageProducer) {
        this.licenseRepository = licenseRepository;
        this.robotMessageProducer = robotMessageProducer;
        this.initLicense();
    }

    public void initLicense() {
        this.licenseRepository.initLicense();
    }

    public boolean hasLicense() {
        return this.licenseRepository.getLicense() != null;
    }

    @Override
    public License getLicense() {
        return this.licenseRepository.getLicense();
    }

    public boolean isFeatureActive(String featureId) {
        if (this.isLicenseValid()) {
            if (this.getLicenseVersion() == License.LicenseVersion.V1) {
                return this.validateV1License((LicenseV1)this.licenseRepository.getLicense(), featureId);
            }
            if (this.getLicenseVersion() == License.LicenseVersion.LEGACY) {
                return this.validateLegacyLicense((LegacyLicense)this.licenseRepository.getLicense(), featureId);
            }
        }
        return false;
    }

    public boolean isLicenseValid() {
        return this.hasLicense() && this.licenseRepository.getLicense().valid();
    }

    private License.LicenseVersion getLicenseVersion() {
        return this.licenseRepository.getLicense().getLicenseVersion();
    }

    public boolean loadLicenseFile(File licenseFile) {
        return LicenseManagerInternal.Status.OK.equals((Object)this.loadLicenseFileWithStatus(licenseFile));
    }

    @Override
    public LicenseManagerInternal.Status loadLicenseFileWithStatus(File licenseFile) {
        return this.licenseRepository.setLicenseFile(licenseFile);
    }

    public boolean unloadLicense() {
        return this.licenseRepository.removeLicense();
    }

    private boolean validateLegacyLicense(LegacyLicense license, String featureId) {
        UrcapEntryContent[] urcaps;
        for (UrcapEntryContent entry : urcaps = license.getUrcaps()) {
            if (!entry.getId().equals(featureId)) continue;
            if (entry.getExpire() == null || entry.getExpire().isEmpty()) {
                return true;
            }
            return !DateVerifier.isDateExpired(entry.getExpire());
        }
        return false;
    }

    private boolean validateV1License(LicenseV1 license, String featureId) {
        for (LicenseContent licenseContent : license.getLicenses()) {
            for (Feature feature : licenseContent.getFeatures()) {
                if (!feature.getId().equals(featureId)) continue;
                boolean dateOutsideValidRange = DateVerifier.isDateOutsideValidRange(licenseContent.getValidFrom(), licenseContent.getValidTo());
                if (dateOutsideValidRange) {
                    this.logDateOutsideValidRangeWarning(feature.getName(), licenseContent.getValidFrom(), licenseContent.getValidTo());
                }
                return !dateOutsideValidRange;
            }
        }
        return false;
    }

    private void logDateOutsideValidRangeWarning(String feature, String fromDate, String toDate) {
        try {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MINUTES);
            String logMessage = "Invalid License: License for [" + feature + "] has expired. Current UTC Time: " + now + " Valid from: " + ZonedDateTime.parse(fromDate).truncatedTo(ChronoUnit.MINUTES) + " Valid to: " + ZonedDateTime.parse(toDate).truncatedTo(ChronoUnit.MINUTES);
            Log.warning((String)logMessage);
            this.robotMessageProducer.generateAndNotify(ReportLevel.INFO, logMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

