/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content;

import com.ur.disk.Directories;
import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.license.internal.LicenseException;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.LicenseRuntimeException;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.parser.LicenseParser;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class LicenseRepository {
    private final LicenseParser licenseParser;
    private final Provider<RobotIdentification> robotIdentificationProvider;
    private final EventManager eventManager;
    private final File licenseFile;
    private License license;

    @Inject
    public LicenseRepository(LicenseParser licenseParser, Provider<RobotIdentification> robotIdentificationProvider, EventManager eventManager) {
        this.licenseParser = licenseParser;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.eventManager = eventManager;
        this.licenseFile = new File(Directories.home(), ".polyscope/license.p7b");
    }

    public void initLicense() {
        if (this.licenseFile.exists()) {
            this.setLicenseFile(this.licenseFile);
        }
    }

    private License parseLicenseFile(File licenseFile) throws LicenseException {
        if (licenseFile.exists()) {
            return this.licenseParser.parseLicenseFile(licenseFile);
        }
        throw new LicenseException("License file does not exist");
    }

    public LicenseManagerInternal.Status setLicenseFile(File licenseFile) {
        LicenseManagerInternal.Status status = this.parseVerifyAndSetLicense(licenseFile);
        if (status == LicenseManagerInternal.Status.OK) {
            this.copyLicenseFile(licenseFile);
            this.eventManager.fireEvent(LicenseUpdatedListener.class, LicenseUpdatedListener::onLicenseUpdated);
        }
        return status;
    }

    private LicenseManagerInternal.Status parseVerifyAndSetLicense(File licenseFile) {
        LicenseManagerInternal.Status status = LicenseManagerInternal.Status.VALIDATION_FAILED;
        try {
            License newLicense = this.parseLicenseFile(licenseFile);
            status = this.verifyLicense(newLicense);
            this.license = status == LicenseManagerInternal.Status.OK ? newLicense : null;
        }
        catch (LicenseException e) {
            Log.warning((String)"License verification failed", (Throwable)e);
        }
        return status;
    }

    private void copyLicenseFile(File licenseFile) {
        try {
            if (!this.isLicenseDirectoryUsable()) {
                throw new LicenseRuntimeException("Cannot save license file into " + this.licenseFile.getParent());
            }
            Files.copy(licenseFile.toPath(), this.licenseFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Log.warning((String)"Couldn't write license file location", (Throwable)e);
        }
    }

    public boolean removeLicense() {
        if (this.deleteLicenseFile()) {
            this.license = null;
            this.eventManager.fireEvent(LicenseUpdatedListener.class, LicenseUpdatedListener::onLicenseUpdated);
            return true;
        }
        return false;
    }

    private boolean deleteLicenseFile() {
        try {
            Files.delete(this.licenseFile.toPath());
        }
        catch (IOException e) {
            Log.error((String)"Could not delete the license file", (Throwable)e);
        }
        return !this.licenseFile.exists();
    }

    public License getLicense() {
        return this.license;
    }

    private boolean isLicenseDirectoryUsable() {
        return this.licenseFile.getParentFile().exists() || this.licenseFile.getParentFile().mkdirs();
    }

    private LicenseManagerInternal.Status verifyLicense(License newLicense) {
        if (newLicense != null && newLicense.valid()) {
            if (this.verifyLicenseMatchesSerial(newLicense)) {
                return LicenseManagerInternal.Status.OK;
            }
            return LicenseManagerInternal.Status.WRONG_SERIAL_NUMBER;
        }
        return LicenseManagerInternal.Status.VALIDATION_FAILED;
    }

    private boolean verifyLicenseMatchesSerial(License license) {
        String robotSerialNumber = ((RobotIdentification)this.robotIdentificationProvider.get()).getSerialNumber().getSerialNumber();
        if (robotSerialNumber.equals(license.getSerialNumber())) {
            return true;
        }
        Log.warning((String)String.format("License does not match robot serial number %s. License valid for: %s", robotSerialNumber, license.getSerialNumber()));
        return false;
    }
}

