/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content.model.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.legacy.UrcapEntryContent;
import java.util.Arrays;

public class LegacyLicense
implements License {
    private final String serial;
    private final String company;
    private final UrcapEntryContent[] urcaps;

    @JsonCreator
    public LegacyLicense(@JsonProperty(value="serial") String serial, @JsonProperty(value="company") String company, @JsonProperty(value="urcaps") UrcapEntryContent[] urcaps) {
        this.serial = serial;
        this.company = company;
        this.urcaps = urcaps != null ? Arrays.copyOf(urcaps, urcaps.length) : new UrcapEntryContent[]{};
    }

    @Override
    public String getSerialNumber() {
        return this.serial;
    }

    public String getCompany() {
        return this.company;
    }

    public UrcapEntryContent[] getUrcaps() {
        return (UrcapEntryContent[])this.urcaps.clone();
    }

    @Override
    public boolean valid() {
        return this.serial != null && !this.serial.isEmpty();
    }

    @Override
    public License.LicenseVersion getLicenseVersion() {
        return License.LicenseVersion.LEGACY;
    }
}

