/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content.model.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ur.polyscope.license.internal.content.model.v1.Feature;
import com.ur.polyscope.license.internal.util.DateVerifier;
import java.util.Arrays;

public class LicenseContent {
    private final String licenseId;
    private final String createdAt;
    private final String issuedAt;
    private final String validFrom;
    private final String validTo;
    private final Feature[] features;
    private final String namespace;
    private final String productName;
    private String ownerId;

    @JsonCreator
    public LicenseContent(@JsonProperty(value="licenseId", required=true) String licenseId, @JsonProperty(value="createdAt", required=true) String createdAt, @JsonProperty(value="issuedAt", required=true) String issuedAt, @JsonProperty(value="validFrom", required=true) String validFrom, @JsonProperty(value="validTo", required=true) String validTo, @JsonProperty(value="features", required=true) Feature[] features, @JsonProperty(value="namespace", required=true) String namespace, @JsonProperty(value="productName", required=true) String productName) {
        this.licenseId = licenseId;
        this.createdAt = createdAt;
        this.issuedAt = issuedAt;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.features = Arrays.copyOf(features, features.length);
        this.namespace = namespace;
        this.productName = productName;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Feature[] getFeatures() {
        return Arrays.copyOf(this.features, this.features.length);
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getIssuedAt() {
        return this.issuedAt;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public String getProductName() {
        return this.productName;
    }

    public String toString() {
        return "License{id='" + this.licenseId + '\'' + ", ownerId='" + this.ownerId + '\'' + ", namespace='" + this.namespace + '\'' + ", features=" + Arrays.toString(this.features) + ", createdAt='" + this.createdAt + '\'' + ", issuedAt='" + this.issuedAt + '\'' + ", validFrom='" + this.validFrom + '\'' + ", validTo='" + this.validTo + '\'' + ", productName='" + this.productName + '\'' + '}';
    }

    public boolean isValid() {
        return !DateVerifier.isDateOutsideValidRange(this.validFrom, this.validTo);
    }
}

