/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content.model.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.v1.LicenseContent;
import java.util.Arrays;

public class LicenseV1
implements License {
    private final String majorVersion;
    private final String created;
    private final String robotSerialNumber;
    private final LicenseContent[] licenses;

    @JsonCreator
    public LicenseV1(@JsonProperty(value="majorVersion", required=true) String majorVersion, @JsonProperty(value="created", required=true) String created, @JsonProperty(value="robotSerialNumber", required=true) String robotSerialNumber, @JsonProperty(value="licenses", required=true) LicenseContent[] licenses) {
        this.majorVersion = majorVersion;
        this.created = created;
        this.robotSerialNumber = robotSerialNumber;
        this.licenses = Arrays.copyOf(licenses, licenses.length);
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getCreated() {
        return this.created;
    }

    public LicenseContent[] getLicenses() {
        return Arrays.copyOf(this.licenses, this.licenses.length);
    }

    @Override
    public String getSerialNumber() {
        return this.robotSerialNumber;
    }

    @Override
    public boolean valid() {
        return this.robotSerialNumber != null && !this.robotSerialNumber.isEmpty();
    }

    @Override
    public License.LicenseVersion getLicenseVersion() {
        return License.LicenseVersion.V1;
    }

    public String toString() {
        return "LicenseContent{majorVersion='" + this.majorVersion + '\'' + ", created='" + this.created + '\'' + ", robotSerialNumber='" + this.robotSerialNumber + '\'' + ", licenses=" + Arrays.toString(this.licenses) + '}';
    }
}

