/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content.parser;

import com.ur.polyscope.license.internal.LicenseException;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

@Singleton
class CertificateService {
    private static final String SHA1_ALGORITHM = "SHA-1";

    CertificateService() {
    }

    byte[] getSignedData(File file) throws LicenseException {
        byte[] signedData;
        try {
            signedData = CertificateService.readContent(file);
        }
        catch (IOException e) {
            throw new LicenseException("Cannot read license file", e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signedData);
        ASN1InputStream asnInputStream = new ASN1InputStream((InputStream)inputStream);
        CMSSignedData cmsSignedData = CertificateService.getCmsSignedData(asnInputStream);
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        CertificateService.verifySigningTime(signers);
        Store certStore = cmsSignedData.getCertificates();
        SignerInformation signer = (SignerInformation)signers.getSigners().iterator().next();
        Collection certCollection = certStore.getMatches((Selector)signer.getSID());
        X509CertificateHolder certHolder = (X509CertificateHolder)certCollection.iterator().next();
        X509Certificate signingCertificate = CertificateService.getSigningCertificate(certHolder);
        if (!this.verifyCertificateCA(signingCertificate)) {
            return new byte[0];
        }
        if (!CertificateService.isLicenseValid(signer, certHolder)) {
            Log.warning((String)"License content mismatch with signature");
            return new byte[0];
        }
        return (byte[])cmsSignedData.getSignedContent().getContent();
    }

    boolean verifyCertificateCA(X509Certificate signingCertificate) {
        KeyStore keystore = this.getKeyStore();
        if (keystore != null) {
            try {
                X509Certificate caCertificate = (X509Certificate)keystore.getCertificate("ur_robot_root_certificate");
                if (caCertificate != null) {
                    ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                    certList.add(caCertificate);
                    certList.add(signingCertificate);
                    CollectionCertStoreParameters params = new CollectionCertStoreParameters(certList);
                    CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)params, "BC");
                    ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                    certChain.add(signingCertificate);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                    CertPath certPath = cf.generateCertPath(certChain);
                    Set<TrustAnchor> trust = Collections.singleton(new TrustAnchor(caCertificate, null));
                    CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");
                    PKIXParameters param = new PKIXParameters(trust);
                    param.setRevocationEnabled(false);
                    param.addCertStore(store);
                    param.setDate(Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    validator.validate(certPath, param);
                    Log.warning((String)("License certificate with fingerprint " + this.getFingerprint(signingCertificate) + " validated against root certificate " + this.getFingerprint(caCertificate)));
                    return true;
                }
                Log.warning((String)"License verification failed on CA verification. No UR Robot Certificate found.");
                return false;
            }
            catch (CertPathValidatorException e) {
                Log.warning((String)("License verification failed on CA verification: " + e.getMessage()), (Throwable)e);
            }
            catch (GeneralSecurityException e) {
                Log.warning((String)"License verification failed", (Throwable)e);
            }
        }
        return false;
    }

    KeyStore getKeyStore() {
        KeyStore keystore = null;
        File caCerts = new File(System.getProperty("java.home") + "/lib/security", "cacerts");
        try (FileInputStream caCertInputStream = new FileInputStream(caCerts);){
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = "changeit".toCharArray();
            keystore.load(caCertInputStream, password);
        }
        catch (IOException e) {
            Log.warning((String)"Unable to load KeyStore due to I/O error.", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            Log.warning((String)"Unable to load KeyStore.", (Throwable)e);
        }
        return keystore;
    }

    private String getFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        return String.format("%032x", new BigInteger(1, MessageDigest.getInstance(SHA1_ALGORITHM).digest(certificate.getEncoded())));
    }

    private static byte[] readContent(File file) throws IOException {
        byte[] content = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytes = ((InputStream)fis).read(content);
            if (bytes < content.length) {
                Log.warning((String)("Read " + bytes + " bytes from " + file.getAbsolutePath() + ", which is less than its size " + content.length));
            }
        }
        return content;
    }

    private static X509Certificate getSigningCertificate(X509CertificateHolder certHolder) throws LicenseException {
        X509Certificate signingCertificate;
        try {
            signingCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        }
        catch (CertificateException e) {
            throw new LicenseException(e);
        }
        return signingCertificate;
    }

    private static void verifySigningTime(SignerInformationStore signers) throws LicenseException {
        for (SignerInformation signerInformation : signers) {
            AttributeTable signedAttr = signerInformation.getSignedAttributes();
            Attribute signingTime = signedAttr.get(CMSAttributes.signingTime);
            if (signingTime != null) continue;
            Log.warning((String)"License missing signing time");
            throw new LicenseException("License missing signing time");
        }
    }

    private static CMSSignedData getCmsSignedData(ASN1InputStream asnInputStream) throws LicenseException {
        try {
            return new CMSSignedData(ContentInfo.getInstance((Object)asnInputStream.readObject()));
        }
        catch (CMSException e) {
            throw new LicenseException("License CMS exception", e);
        }
        catch (IOException e) {
            throw new LicenseException("I/O error reading license file", e);
        }
        catch (Exception e) {
            throw new LicenseException(e);
        }
    }

    private static boolean isLicenseValid(SignerInformation signer, X509CertificateHolder certHolder) throws LicenseException {
        boolean licenseValid;
        try {
            licenseValid = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(certHolder));
        }
        catch (CertificateException | CMSException | OperatorCreationException e) {
            throw new LicenseException(e);
        }
        return licenseValid;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

