/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.content.parser;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.polyscope.license.internal.LicenseException;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.legacy.LegacyLicense;
import com.ur.polyscope.license.internal.content.model.v1.LicenseContent;
import com.ur.polyscope.license.internal.content.model.v1.LicenseV1;
import com.ur.polyscope.license.internal.content.parser.CertificateService;
import com.ur.polyscope.license.internal.util.DateVerifier;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LicenseParser {
    private final CertificateService certificateService;
    private final ObjectMapper objectMapper;

    @Inject
    public LicenseParser(CertificateService certificateService) {
        this.certificateService = certificateService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public License parseLicenseFile(File file) throws LicenseException {
        byte[] data = this.certificateService.getSignedData(file);
        if (data.length == 0) {
            return null;
        }
        String strData = new String(data, StandardCharsets.UTF_8);
        return this.loadFromJson(strData);
    }

    private License loadFromJson(String jsonString) throws LicenseException {
        License.LicenseVersion version = this.getLicenseVersion(jsonString);
        License result = version == License.LicenseVersion.LEGACY ? this.fromLegacyJson(jsonString) : this.fromJsonV1(jsonString);
        return result;
    }

    private License fromLegacyJson(String jsonString) throws LicenseException {
        License licenseContent;
        try {
            licenseContent = (License)this.objectMapper.readValue(jsonString, LegacyLicense.class);
        }
        catch (IOException e) {
            throw new LicenseException("Unable to read license content", e);
        }
        return licenseContent;
    }

    private License fromJsonV1(String jsonString) throws LicenseException {
        LicenseV1 licenseV1;
        try {
            licenseV1 = (LicenseV1)this.objectMapper.readValue(jsonString, LicenseV1.class);
            this.verifyTimestampFormat(licenseV1);
        }
        catch (IOException e) {
            throw new LicenseException("Unable to read license content", e);
        }
        return licenseV1;
    }

    private License.LicenseVersion getLicenseVersion(String jsonString) throws LicenseException {
        License.LicenseVersion licenseVersion;
        try {
            Map fields = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
            licenseVersion = fields.containsKey("majorVersion") ? License.LicenseVersion.V1 : License.LicenseVersion.LEGACY;
        }
        catch (IOException e) {
            throw new LicenseException("Unable to read license content", e);
        }
        return licenseVersion;
    }

    private void verifyTimestampFormat(LicenseV1 licenseV1) throws LicenseException {
        if (!DateVerifier.isValidDateFormat(licenseV1.getCreated())) {
            this.throwInvalidTimestampException("LicenseContent.created", licenseV1.getCreated());
        }
        for (LicenseContent license : licenseV1.getLicenses()) {
            if (!DateVerifier.isValidDateFormat(license.getCreatedAt())) {
                this.throwInvalidTimestampException("License.createdAt", license.getCreatedAt());
            }
            if (!DateVerifier.isValidDateFormat(license.getIssuedAt())) {
                this.throwInvalidTimestampException("License.issuedAt", license.getIssuedAt());
            }
            if (!DateVerifier.isValidDateFormat(license.getValidFrom())) {
                this.throwInvalidTimestampException("License.validFrom", license.getValidFrom());
            }
            if (DateVerifier.isValidDateFormat(license.getValidTo())) continue;
            this.throwInvalidTimestampException("License.validTo", license.getValidTo());
        }
    }

    private void throwInvalidTimestampException(String field, String value) throws LicenseException {
        throw new LicenseException(String.format("Field '%s' not a valid timestamp (value = %s)", field, value));
    }
}

