/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing;

import com.ur.polyscope.license.LicenseManager;
import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.license.internal.TextResource;
import com.ur.polyscope.license.internal.swing.action.LoadButtonAction;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.AddToViewExtension;
import com.ur.swing.extensible.Extension;
import com.ur.util.event.EventManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

@Singleton
@Extension(value="URCapSettingsFooter")
public class ActivateURCapButton
implements AddToViewExtension,
LicenseUpdatedListener {
    private final transient WidgetFactory widgetFactory;
    private final transient LoadButtonAction loadButtonAction;
    private final transient TextResource textResource;
    private final LicenseManager licenseManager;
    JButton activateButton;

    @Inject
    public ActivateURCapButton(WidgetFactory widgetFactory, LoadButtonAction loadButtonAction, TextResource textResource, EventManager eventManager, LicenseManager licenseManager) {
        this.widgetFactory = widgetFactory;
        this.loadButtonAction = loadButtonAction;
        this.textResource = textResource;
        this.licenseManager = licenseManager;
        this.initComponents();
        eventManager.addStrongListener(LicenseUpdatedListener.class, (Object)this);
    }

    private void initComponents() {
        this.loadButtonAction.putValue("HelpId", "gui:licensed_urcap_activate_button");
        this.loadButtonAction.putValue("Name", this.textResource.urcapActivateLicense());
        this.loadButtonAction.putValue("InternalName", "urcapactivate.RobotRegistrationSettingsView");
        this.activateButton = this.widgetFactory.createButton((Action)this.loadButtonAction);
        this.updateButtonState();
    }

    public void onLicenseUpdated() {
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.activateButton.setVisible(!this.licenseManager.isFeatureActive("com.energid.urcap.remotetcp"));
    }

    public JComponent create() {
        return this.activateButton;
    }
}

