/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing;

import com.ur.polyscope.license.internal.ImageResource;
import com.ur.polyscope.license.internal.swing.action.LoadButtonAction;
import com.ur.polyscope.license.internal.swing.common.AbstractLicensePanel;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

@Singleton
class RobotRegistrationSettingsOfflineView
extends AbstractLicensePanel
implements AdminLockListener {
    private static final Border STEP_BORDER = BorderFactory.createMatteBorder(0, 0, 2, 0, UIManager.getColor("CardPanel.background"));
    private static final Border HEADER_BORDER = BorderFactory.createEmptyBorder(10, 15, 30, 0);
    private final AdminLock adminLock;
    protected final LoadButtonAction loadButtonAction;
    protected JButton loadButton;

    @Inject
    RobotRegistrationSettingsOfflineView(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, LoadButtonAction loadButtonAction) {
        super(passwordFooter, viewContext);
        this.adminLock = adminLock;
        this.loadButtonAction = loadButtonAction;
        this.initComponents();
        if (this.isAdminPasswordProtected()) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    private void initComponents() {
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        Font stepHeaderFont = fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE);
        JLabel step1Header = this.createStepHeader(this.textResource.registrationStep1(), stepHeaderFont);
        JLabel step2Header = this.createStepHeader(this.textResource.registrationStep2(), stepHeaderFont);
        JLabel step3Header = this.createStepHeader(this.textResource.registrationStep3(), stepHeaderFont);
        Icon nextIcon = ImageResource.nextStep();
        Icon step1Icon = ImageResource.step1();
        Icon step2Icon = ImageResource.step2();
        Icon step3Icon = ImageResource.step3();
        JPanel step1TextPanel = this.createStep1Panel(fontFactory);
        JPanel registrationPanel = this.createRegistrationPanel(fontFactory);
        String step2Text = this.textResource.registrationStep2Text();
        JPanel buttonPanel = this.createLoadButtonPanel();
        FormBuilder.PanelConstraints iconRowHeight = FormBuilder.PanelConstraints.SPAN_8_ROWS;
        FormBuilder.PanelConstraints stepWidth = FormBuilder.PanelConstraints.SPAN_4_COLUMNS;
        JPanel stepsPanel = this.viewContext.createFormBuilder().label(step1Header, new FormBuilder.PanelConstraints[]{stepWidth}).label("", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).label(step2Header, new FormBuilder.PanelConstraints[]{stepWidth}).label("", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).label(step3Header, new FormBuilder.PanelConstraints[]{stepWidth}).end().label(step1Icon, "", new FormBuilder.PanelConstraints[]{stepWidth, iconRowHeight, FormBuilder.PanelConstraints.CENTER}).label(nextIcon, "", new FormBuilder.PanelConstraints[]{iconRowHeight, FormBuilder.PanelConstraints.CENTER}).label(step2Icon, "", new FormBuilder.PanelConstraints[]{stepWidth, iconRowHeight, FormBuilder.PanelConstraints.CENTER}).label(nextIcon, "", new FormBuilder.PanelConstraints[]{iconRowHeight, FormBuilder.PanelConstraints.CENTER}).label(step3Icon, "", new FormBuilder.PanelConstraints[]{stepWidth, iconRowHeight, FormBuilder.PanelConstraints.CENTER}).end(8).component((JComponent)step1TextPanel, new FormBuilder.PanelConstraints[]{stepWidth, FormBuilder.PanelConstraints.SPAN_2_ROWS}).label("", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_2_ROWS}).label(step2Text, new FormBuilder.PanelConstraints[]{stepWidth, FormBuilder.PanelConstraints.SPAN_2_ROWS}).label("", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_2_ROWS}).component((JComponent)buttonPanel, new FormBuilder.PanelConstraints[]{stepWidth, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(4).component((JComponent)registrationPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_12_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new CardBorder(this.textResource.licensesSettingsItem()));
        this.add(this.createHeader(), "First");
        this.add(stepsPanel, "Center");
        super.addPasswordFooter();
    }

    private JPanel createLoadButtonPanel() {
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.loadButtonAction.putValue("HelpId", "gui:settingstab_offline_register_robot");
        this.loadButtonAction.putValue("Name", this.textResource.registrationLoadFile());
        this.loadButtonAction.putValue("InternalName", "load.RobotRegistrationSettingsView");
        this.loadButton = widgetFactory.createButton((Action)this.loadButtonAction);
        this.loadButton.setPreferredSize(new Dimension(265, 40));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        buttonPanel.add(this.loadButton);
        if (this.isAdminPasswordProtected() && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
        return buttonPanel;
    }

    private JPanel createStep1Panel(URFontFactory fontFactory) {
        JLabel step1Text = new JLabel(this.textResource.registrationStep1Text());
        JLabel step1Url = new JLabel(this.textResource.licenseUrl() + " *");
        this.changeFont(step1Url, fontFactory);
        JPanel step1TextPanel = new JPanel();
        step1TextPanel.setLayout(new BoxLayout(step1TextPanel, 1));
        step1TextPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        step1TextPanel.add(step1Text);
        step1TextPanel.add(step1Url);
        return step1TextPanel;
    }

    private JPanel createRegistrationPanel(URFontFactory fontFactory) {
        JLabel registrationText = new JLabel("* " + this.textResource.registrationUrl("Remote TCP & Toolpath"));
        JLabel registrationUrl = new JLabel("www.universal-robots.com/activate");
        this.changeFont(registrationText, fontFactory);
        this.changeFont(registrationUrl, fontFactory);
        JPanel registrationPanel = new JPanel();
        registrationPanel.setLayout(new BoxLayout(registrationPanel, 1));
        registrationPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        registrationPanel.add(registrationText);
        registrationPanel.add(registrationUrl);
        return registrationPanel;
    }

    private JLabel createStepHeader(String text, Font font) {
        JLabel stepHeader = new JLabel(text);
        stepHeader.setFont(font);
        stepHeader.setBorder(STEP_BORDER);
        return stepHeader;
    }

    private void changeFont(JLabel jlabel, URFontFactory fontFactory) {
        jlabel.setFont(new Font(fontFactory.getDefaultFont().getFontName(), fontFactory.getDefaultFont().getStyle(), 12));
    }

    private JLabel createHeader() {
        JLabel headerText = new JLabel(HTML.html((String)this.textResource.registrationGuideText()));
        headerText.setBorder(HEADER_BORDER);
        return headerText;
    }

    public void doUnlock() {
        this.loadButton.setForeground(Color.BLACK);
        this.loadButton.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        this.loadButton.setEnabled(true);
    }

    public void doLock() {
        this.loadButton.setForeground(Color.BLACK);
        this.loadButton.setBackground(Color.WHITE);
        this.loadButton.setEnabled(false);
    }
}

