/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing;

import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.swing.RobotRegistrationSettingsOfflineView;
import com.ur.polyscope.license.internal.swing.legacy.LegacyRobotRegistrationSettingsCompletedView;
import com.ur.polyscope.license.internal.swing.v1.RobotRegistrationSettingsCompletedViewV1;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.event.EventManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RobotRegistrationSettingsView
extends CardPanel
implements LicenseUpdatedListener {
    private final FlippablePanel flippablePanel;
    private LicenseManagerInternal licenseManager;

    @Inject
    RobotRegistrationSettingsView(RobotRegistrationSettingsCompletedViewV1 completedViewV1, LegacyRobotRegistrationSettingsCompletedView legacyCompletedView, RobotRegistrationSettingsOfflineView offlineView, EventManager eventManager, LicenseManagerInternal licenseManager) {
        this.licenseManager = licenseManager;
        this.flippablePanel = new FlippablePanel();
        this.flippablePanel.setCardParent((CardPanel)this);
        this.flippablePanel.addCardPanel(RobotRegistrationSettingsOfflineView.class, (CardPanel)offlineView);
        this.flippablePanel.addCardPanel(RobotRegistrationSettingsCompletedViewV1.class, (CardPanel)completedViewV1);
        this.flippablePanel.addCardPanel(LegacyRobotRegistrationSettingsCompletedView.class, (CardPanel)legacyCompletedView);
        this.initComponents();
        eventManager.addStrongListener(LicenseUpdatedListener.class, (Object)this);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.flippablePanel, "Center");
    }

    public void enter(Object o) {
        super.enter(o);
        this.switchCard();
        this.flippablePanel.enterActiveChild(o);
    }

    public Object exit() {
        this.flippablePanel.exitActiveChild();
        return super.exit();
    }

    public void onLicenseUpdated() {
        this.switchCard();
    }

    private void switchCard() {
        boolean isCompletedView = this.isCurrentlyOnCompletedView();
        if (this.licenseManager.hasLicense()) {
            if (!isCompletedView) {
                this.emptyStack();
                if (this.licenseManager.getLicense().getLicenseVersion() == License.LicenseVersion.V1) {
                    this.flippablePanel.switchTo(RobotRegistrationSettingsCompletedViewV1.class);
                } else {
                    this.flippablePanel.switchTo(LegacyRobotRegistrationSettingsCompletedView.class);
                }
            }
        } else if (isCompletedView) {
            this.emptyStack();
            this.flippablePanel.switchTo(RobotRegistrationSettingsOfflineView.class);
        }
    }

    private boolean isCurrentlyOnCompletedView() {
        CardPanel currentCard = this.flippablePanel.getCurrentCard();
        return currentCard instanceof RobotRegistrationSettingsCompletedViewV1 || currentCard instanceof LegacyRobotRegistrationSettingsCompletedView;
    }

    private void emptyStack() {
        while (!this.flippablePanel.isCardStackEmpty()) {
            this.flippablePanel.navigateBack();
        }
    }
}

