/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing;

import com.ur.polyscope.license.internal.ImageResource;
import com.ur.polyscope.license.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.extensible.AddToViewExtension;
import com.ur.swing.extensible.Extension;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Extension(value="URCapSettingsRegistrationPane")
@Singleton
public class URCapActivationView
extends JPanel
implements AddToViewExtension {
    private final transient ViewContext viewContext;
    private final transient TextResource textResource;
    private final HelpIdAssigner helpIdAssigner;

    @Inject
    public URCapActivationView(ViewContext viewContext, HelpIdAssigner helpIdAssigner) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.helpIdAssigner = helpIdAssigner;
        this.helpIdAssigner.assignHelpId((JComponent)this, "gui:license_urcap_offline_register");
        this.initComponents();
    }

    private void initComponents() {
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        Font stepHeaderFont = fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.DEFAULT);
        JPanel step1TextPanel = this.createStep1Panel(fontFactory, stepHeaderFont);
        JPanel registrationPanel = this.createRegristraionPanel(fontFactory);
        JPanel step2TextPanel = this.createStep2Or3Panel(stepHeaderFont, this.textResource.registrationStep2(), this.textResource.registrationStep2Text());
        JPanel step3TextPanel = this.createStep2Or3Panel(stepHeaderFont, this.textResource.registrationStep3(), this.textResource.registrationLoadFile());
        Icon nextIcon = ImageResource.nextStepHorizontal();
        Icon step1Icon = ImageResource.step1small();
        Icon step2Icon = ImageResource.step2small();
        Icon step3Icon = ImageResource.step3small();
        JPanel stepsPanel = this.viewContext.createFormBuilder().component((JComponent)step1TextPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS}).label(step1Icon, "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS, FormBuilder.PanelConstraints.CENTER}).end(4).spacer(9).end().component((JComponent)registrationPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).label(nextIcon, "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.CENTER}).end(2).component((JComponent)step2TextPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS}).label(step2Icon, "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS, FormBuilder.PanelConstraints.CENTER}).end(4).label(nextIcon, "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.CENTER}).end(3).component((JComponent)step3TextPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS}).label(step3Icon, "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS, FormBuilder.PanelConstraints.CENTER}).end(4).fixedSizeColumnAndWidthPairs(new int[]{1, 16, 2, 16, 3, 16, 4, 16, 5, 16, 6, 16, 7, 16, 8, 16, 9, 16}).getPanel();
        stepsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)stepsPanel, "Center");
    }

    private JPanel createStep1Panel(URFontFactory fontFactory, Font stepHeaderFont) {
        JLabel step1Header = new JLabel(this.textResource.registrationStep1());
        step1Header.setFont(stepHeaderFont);
        step1Header.setBorder(BorderFactory.createEmptyBorder(0, 0, 40, 0));
        JLabel step1Text = new JLabel(this.textResource.registrationStep1Text());
        JLabel step1Url = new JLabel(this.textResource.licenseUrl() + " *");
        this.changeFont(step1Url, fontFactory);
        JPanel step1TextPanel = new JPanel();
        step1TextPanel.setLayout(new BoxLayout(step1TextPanel, 1));
        step1TextPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        step1TextPanel.add(step1Header);
        step1TextPanel.add(step1Text);
        step1TextPanel.add(step1Url);
        return step1TextPanel;
    }

    private JPanel createStep2Or3Panel(Font stepHeaderFont, String headerText, String commentText) {
        JLabel step3Header = new JLabel(headerText);
        step3Header.setFont(stepHeaderFont);
        step3Header.setBorder(BorderFactory.createEmptyBorder(0, 0, 40, 0));
        JPanel step3TextPanel = new JPanel();
        step3TextPanel.setLayout(new BoxLayout(step3TextPanel, 1));
        step3TextPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        step3TextPanel.add(step3Header);
        step3TextPanel.add(new JLabel(HTML.html((String)commentText)));
        return step3TextPanel;
    }

    private JPanel createRegristraionPanel(URFontFactory fontFactory) {
        JLabel registrationText = new JLabel(HTML.html((String)("* " + this.textResource.registrationUrl("Remote TCP & Toolpath"))));
        JLabel registrationUrl = new JLabel("www.universal-robots.com/activate");
        this.changeFont(registrationText, fontFactory);
        this.changeFont(registrationUrl, fontFactory);
        JPanel registrationPanel = new JPanel();
        registrationPanel.setLayout(new BoxLayout(registrationPanel, 1));
        registrationPanel.add(registrationText);
        registrationPanel.add(registrationUrl);
        return registrationPanel;
    }

    private void changeFont(JLabel jlabel, URFontFactory fontFactory) {
        jlabel.setFont(new Font(fontFactory.getDefaultFont().getFontName(), fontFactory.getDefaultFont().getStyle(), 12));
    }

    public JComponent create() {
        return this;
    }
}

