/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing.action;

import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.TextResource;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LicenseDialogHandler {
    private final ErrorDialogCreator errorDialogCreator;
    private final TextResource textResource;

    @Inject
    public LicenseDialogHandler(ErrorDialogCreator errorDialogCreator, TextResource textResource) {
        this.errorDialogCreator = errorDialogCreator;
        this.textResource = textResource;
    }

    public void showErrorDialog(LicenseManagerInternal.Status status) {
        if (status == LicenseManagerInternal.Status.WRONG_SERIAL_NUMBER) {
            this.errorDialogCreator.showErrorDialog(new ErrorMessage(this.textResource.failedToActivateLicenseTitle(), this.textResource.invalidSerialNumberMessage()), new OkDialogListener());
        } else if (status != LicenseManagerInternal.Status.OK) {
            this.errorDialogCreator.showErrorDialog(new ErrorMessage(this.textResource.failedToActivateLicenseTitle(), this.textResource.invalidLicenseFileMessage()), new OkDialogListener());
        }
    }
}

