/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing.action;

import com.ur.disk.Directories;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.TextResource;
import com.ur.polyscope.license.internal.swing.action.LicenseDialogHandler;
import com.ur.swing.ActionDefinition;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public class LoadButtonAction
extends AbstractAction {
    private final FilePersistence filePersistence;
    private final FileManagerConfiguration licenseFileSelector;
    private final LicenseDialogHandler licenseDialogHandler;
    private static final File AUTOLOAD_FILE = new File(Directories.programs(), "/usbdisk/license.p7b");
    private LicenseManagerInternal licenseManager;

    @Inject
    LoadButtonAction(LicenseManagerInternal licenseManager, FilePersistence filePersistence, TextResource textResource, LicenseDialogHandler licenseDialogHandler) {
        this.licenseManager = licenseManager;
        this.filePersistence = filePersistence;
        this.licenseFileSelector = new FileManagerConfiguration(textResource.registrationFileManagerTitle(), FileManagerConfiguration.Access.RESTRICTED, Directories.programs(), new URFileFilter[]{new RegistrationFileFilter(textResource)});
        this.licenseDialogHandler = licenseDialogHandler;
        this.initActionProperties();
    }

    private void initActionProperties() {
        this.putValue("Function", ActionDefinition.Function.PRIMARY);
    }

    File getAutoloadFile() {
        return AUTOLOAD_FILE;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File licenseFile = this.getAutoloadFile();
        if (!licenseFile.exists() || !this.licenseManager.loadLicenseFile(licenseFile)) {
            PerformingFileContainer fileContainer = new PerformingFileContainer(){

                public boolean perform() {
                    if (this.hasFileSelected()) {
                        LicenseManagerInternal.Status status = LoadButtonAction.this.licenseManager.loadLicenseFileWithStatus(this.getFile());
                        LoadButtonAction.this.licenseDialogHandler.showErrorDialog(status);
                    }
                    return super.perform();
                }
            };
            this.filePersistence.openFile((FileContainer)fileContainer, this.licenseFileSelector);
        }
    }

    private static class RegistrationFileFilter
    extends URFileFilter {
        private final TextResource textResource;

        RegistrationFileFilter(TextResource textResource) {
            this.textResource = textResource;
        }

        public String getFileExtension() {
            return "p7b";
        }

        public String getDescription() {
            return this.textResource.registrationFileFilterDescription();
        }
    }
}

