/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing.common;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.license.internal.TextResource;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractLicensePanel
extends CardPanel {
    private static final String SYSTEM_ADMIN_PASSWORD = "systemPassword";
    protected final transient TextResource textResource;
    protected final transient ViewContext viewContext;
    private final transient RequireAdminPasswordFooter passwordFooter;

    protected AbstractLicensePanel(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext) {
        this.passwordFooter = passwordFooter;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    public Object exit() {
        this.cleanup();
        return super.exit();
    }

    private void cleanup() {
        this.passwordFooter.resetPasswordField();
    }

    protected boolean isAdminPasswordProtected() {
        return FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD);
    }

    protected void addPasswordFooter() {
        JPanel footerPanel = this.passwordFooter.getFooterPanel();
        this.add(this.createCard(null, footerPanel), "South");
        if (!this.isAdminPasswordProtected()) {
            footerPanel.setVisible(false);
        }
    }

    protected JPanel createCard(String cardTitle, JComponent panel) {
        JPanel result = new JPanel(new BorderLayout());
        if (cardTitle != null) {
            result.setBorder((Border)new CardBorder(cardTitle));
        }
        result.add((Component)panel, "Center");
        return result;
    }
}

