/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing.legacy;

import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.license.internal.ImageResource;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.legacy.LegacyLicense;
import com.ur.polyscope.license.internal.swing.action.UnregisterButtonAction;
import com.ur.polyscope.license.internal.swing.common.AbstractLicensePanel;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Singleton
public class LegacyRobotRegistrationSettingsCompletedView
extends AbstractLicensePanel
implements LicenseUpdatedListener,
AdminLockListener {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private final transient URFontFactory fontFactory;
    private final transient UnregisterButtonAction unregisterButtonAction;
    private final LicenseManagerInternal licenseManager;
    private final AdminLock adminLock;
    private JLabel companyName;
    private JLabel robotSerialNumber;
    protected JButton unregisterButton;

    @Inject
    public LegacyRobotRegistrationSettingsCompletedView(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, HelpIdAssigner helpIdAssigner, UnregisterButtonAction unregisterButtonAction, EventManager eventManager, LicenseManagerInternal licenseManager) {
        super(passwordFooter, viewContext);
        this.fontFactory = viewContext.getFontFactory();
        this.adminLock = adminLock;
        this.unregisterButtonAction = unregisterButtonAction;
        this.licenseManager = licenseManager;
        this.initComponents(helpIdAssigner);
        if (this.isAdminPasswordProtected()) {
            adminLock.addListener((AdminLockListener)this);
        }
        eventManager.addStrongListener(LicenseUpdatedListener.class, (Object)this);
    }

    public void onLicenseUpdated() {
        if (this.licenseManager.isLicenseValid()) {
            this.handleValidLicense(this.licenseManager.getLicense());
        } else {
            this.handleInvalidLicense();
        }
    }

    private void handleValidLicense(License content) {
        if (content.getLicenseVersion() == License.LicenseVersion.LEGACY) {
            LegacyLicense license = (LegacyLicense)content;
            this.robotSerialNumber.setText(license.getSerialNumber());
            this.companyName.setText(license.getCompany());
        }
    }

    private void handleInvalidLicense() {
        this.companyName.setText("");
        this.robotSerialNumber.setText("");
    }

    private void initComponents(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:license_registration_information");
        JLabel isRegistered = new JLabel(this.textResource.profileIsRegistered());
        isRegistered.setIcon(ImageResource.approve());
        JLabel companyNameLabel = new JLabel(this.textResource.profileCompany() + ":");
        JLabel robotSerialNumberLabel = new JLabel(this.textResource.profileRobotSerialNumber() + ":");
        companyNameLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        robotSerialNumberLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.companyName = new JLabel("");
        this.robotSerialNumber = new JLabel("");
        JPanel centerPanel = this.viewContext.createFormBuilder().label(isRegistered, new FormBuilder.PanelConstraints[0]).end().spacer().end().headerLabel(this.textResource.profileHeader(), new FormBuilder.PanelConstraints[0]).end().label(companyNameLabel, new FormBuilder.PanelConstraints[0]).label(this.companyName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().label(robotSerialNumberLabel, new FormBuilder.PanelConstraints[0]).label(this.robotSerialNumber, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.unregisterButtonAction.putValue("HelpId", "gui:settingstab_unregister_robot");
        this.unregisterButtonAction.putValue("Name", this.textResource.profileUnregisterButton());
        this.unregisterButtonAction.putValue("InternalName", "unregister." + LegacyRobotRegistrationSettingsCompletedView.class.getName());
        this.unregisterButton = widgetFactory.createButton((Action)((Object)this.unregisterButtonAction));
        JPanel centerGroupPanel = new JPanel();
        centerGroupPanel.setLayout(new BoxLayout(centerGroupPanel, 3));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.unregisterButton);
        centerGroupPanel.add(centerPanel);
        centerGroupPanel.add(bottomPanel);
        this.setLayout(new BorderLayout());
        this.setBackground(BETWEEN_CARD_COLOR);
        this.add(centerGroupPanel, "Center");
        this.addPasswordFooter();
        if (this.isAdminPasswordProtected() && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
    }

    public void doUnlock() {
        this.unregisterButton.setForeground(Color.BLACK);
        this.unregisterButton.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        this.unregisterButton.setEnabled(true);
    }

    public void doLock() {
        this.unregisterButton.setForeground(Color.BLACK);
        this.unregisterButton.setBackground(Color.WHITE);
        this.unregisterButton.setEnabled(false);
    }
}

