/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.swing.v1;

import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.license.internal.ImageResource;
import com.ur.polyscope.license.internal.LicenseManagerInternal;
import com.ur.polyscope.license.internal.content.model.License;
import com.ur.polyscope.license.internal.content.model.v1.Feature;
import com.ur.polyscope.license.internal.content.model.v1.LicenseContent;
import com.ur.polyscope.license.internal.content.model.v1.LicenseV1;
import com.ur.polyscope.license.internal.swing.action.UnregisterButtonAction;
import com.ur.polyscope.license.internal.swing.common.AbstractLicensePanel;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

@Singleton
public class RobotRegistrationSettingsCompletedViewV1
extends AbstractLicensePanel
implements LicenseUpdatedListener,
AdminLockListener {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private static final String LABEL_VALUE_LINE = "%s: %s";
    private final transient URFontFactory fontFactory;
    private final transient UnregisterButtonAction unregisterButtonAction;
    private final AdminLock adminLock;
    private LicenseManagerInternal licenseManager;
    JLabel robotSerialNumber;
    JList<LicenseContent> licenseList;
    private JLabel selectedLicenseId;
    private JLabel selectedLicenseIssuedAt;
    private JLabel selectedLicenseValidFrom;
    private JLabel selectedLicenseValidTo;
    private JLabel selectedProductName;
    private JList<Feature> featureList;
    protected JButton unregisterButton;

    @Inject
    public RobotRegistrationSettingsCompletedViewV1(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, UnregisterButtonAction unregisterButtonAction, EventManager eventManager, LicenseManagerInternal licenseManager) {
        super(passwordFooter, viewContext);
        this.adminLock = adminLock;
        this.fontFactory = viewContext.getFontFactory();
        this.unregisterButtonAction = unregisterButtonAction;
        this.licenseManager = licenseManager;
        this.initComponents((HelpIdAssigner)viewContext.getHelpIdAssigner());
        if (this.isAdminPasswordProtected()) {
            adminLock.addListener((AdminLockListener)this);
        }
        eventManager.addStrongListener(LicenseUpdatedListener.class, (Object)this);
    }

    public void enter(Object o) {
        License license = this.licenseManager.getLicense();
        if (license.getLicenseVersion() == License.LicenseVersion.V1) {
            this.robotSerialNumber.setText(license.getSerialNumber());
            this.licenseList.setListData((LicenseContent[])((LicenseV1)license).getLicenses());
            this.setDetailPanel(null);
        }
        super.enter(o);
    }

    public void onLicenseUpdated() {
        if (this.licenseManager.isLicenseValid()) {
            this.handleValidLicense(this.licenseManager.getLicense());
        } else {
            this.handleInvalidLicense();
        }
    }

    private void handleValidLicense(License content) {
        if (content.getLicenseVersion() == License.LicenseVersion.V1) {
            this.robotSerialNumber.setText(content.getSerialNumber());
            this.licenseList.setListData((LicenseContent[])((LicenseV1)content).getLicenses());
            this.setDetailPanel(null);
        }
    }

    private void handleInvalidLicense() {
        this.robotSerialNumber.setText("");
        this.licenseList.setListData((LicenseContent[])new LicenseContent[0]);
        this.setDetailPanel(null);
    }

    private String formatHtmlLine(String label, String value) {
        return HTML.html((String)String.format(LABEL_VALUE_LINE, HTML.fontBold((String)label), value));
    }

    private String prettyDate(String date) {
        return date.substring(0, "2020-01-01".length());
    }

    private void setDetailPanel(LicenseContent license) {
        if (license != null) {
            this.selectedLicenseId.setText(this.formatHtmlLine(this.textResource.detailLicense(), license.getLicenseId()));
            this.selectedLicenseIssuedAt.setText(this.formatHtmlLine(this.textResource.detailIssuedAt(), this.prettyDate(license.getIssuedAt())));
            this.selectedLicenseValidFrom.setText(this.formatHtmlLine(this.textResource.detailValidFrom(), this.prettyDate(license.getValidFrom())));
            this.selectedLicenseValidTo.setText(this.formatHtmlLine(this.textResource.detailValidTo(), this.prettyDate(license.getValidTo())));
            if (license.getFeatures().length == 1) {
                this.selectedProductName.setText(this.formatHtmlLine(this.textResource.detailProductName(), ""));
            } else {
                this.selectedProductName.setText(this.formatHtmlLine(this.textResource.detailProductNames(), ""));
            }
            this.featureList.setListData((Feature[])license.getFeatures());
        } else {
            this.selectedLicenseId.setText("");
            this.selectedLicenseIssuedAt.setText("");
            this.selectedLicenseValidFrom.setText("");
            this.selectedLicenseValidFrom.setText("");
            this.selectedLicenseValidTo.setText("");
            this.selectedProductName.setText("");
            this.featureList.setListData((Feature[])new Feature[0]);
        }
    }

    private void initComponents(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:license_registration_information");
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        JLabel isRegistered = new JLabel(this.textResource.profileIsRegistered());
        isRegistered.setIcon(ImageResource.approve());
        JLabel robotSerialNumberLabel = new JLabel(this.textResource.profileRobotSerialNumber() + ":");
        robotSerialNumberLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.robotSerialNumber = new JLabel("");
        this.licenseList = widgetFactory.createList();
        this.licenseList.setCellRenderer(new LicenseListCellRenderer());
        this.licenseList.addListSelectionListener(e -> this.setDetailPanel(this.licenseList.getSelectedValue()));
        this.selectedLicenseId = new JLabel();
        this.selectedLicenseIssuedAt = new JLabel();
        this.selectedLicenseValidFrom = new JLabel();
        this.selectedLicenseValidTo = new JLabel();
        this.selectedProductName = new JLabel();
        this.featureList = widgetFactory.createList();
        this.featureList.setCellRenderer(new ProductNameListCellRenderer());
        this.setDetailPanel(null);
        JPanel northPanel = this.viewContext.createFormBuilder().label(isRegistered, new FormBuilder.PanelConstraints[0]).end().label(robotSerialNumberLabel, new FormBuilder.PanelConstraints[0]).label(this.robotSerialNumber, new FormBuilder.PanelConstraints[0]).end().getPanel();
        JPanel licenseListPanel = this.viewContext.createFormBuilder().component((JComponent)new JScrollPane(this.licenseList), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_ROWS}).end().end().end().end().end().end().end().end().getPanel();
        licenseListPanel.setBorder((Border)new CardBorder("Licenses"));
        JPanel licenseDetailPanel = this.viewContext.createFormBuilder().label(this.selectedLicenseId, new FormBuilder.PanelConstraints[0]).end().label(this.selectedLicenseIssuedAt, new FormBuilder.PanelConstraints[0]).end().label(this.selectedLicenseValidFrom, new FormBuilder.PanelConstraints[0]).end().label(this.selectedLicenseValidTo, new FormBuilder.PanelConstraints[0]).end().label(this.selectedProductName, new FormBuilder.PanelConstraints[0]).end().component((JComponent)new JScrollPane(this.featureList), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_ROWS}).end().end().end().end().getPanel();
        licenseDetailPanel.setBorder((Border)new CardBorder("License Detail"));
        this.unregisterButtonAction.putValue("HelpId", "gui:settingstab_unregister_robot");
        this.unregisterButtonAction.putValue("Name", this.textResource.profileUnregisterButton());
        this.unregisterButtonAction.putValue("InternalName", "unregister.RobotRegistrationSettingsView");
        this.unregisterButton = widgetFactory.createButton((Action)((Object)this.unregisterButtonAction));
        JPanel centerGroupPanel = new JPanel();
        centerGroupPanel.setLayout(new BoxLayout(centerGroupPanel, 3));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.unregisterButton);
        bottomPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        centerPanel.add(licenseListPanel);
        centerPanel.add(licenseDetailPanel);
        centerGroupPanel.add(centerPanel);
        centerGroupPanel.add(bottomPanel);
        this.setLayout(new BorderLayout());
        this.setBackground(BETWEEN_CARD_COLOR);
        this.add(northPanel, "North");
        this.add(centerGroupPanel, "Center");
        this.addPasswordFooter();
        if (this.isAdminPasswordProtected() && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
    }

    public void doUnlock() {
        this.unregisterButton.setForeground(Color.BLACK);
        this.unregisterButton.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        this.unregisterButton.setEnabled(true);
    }

    public void doLock() {
        this.unregisterButton.setForeground(Color.BLACK);
        this.unregisterButton.setBackground(Color.WHITE);
        this.unregisterButton.setEnabled(false);
    }

    private static class ProductNameListCellRenderer
    extends DefaultListCellRenderer {
        private ProductNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Feature) {
                Feature feature = (Feature)value;
                this.setText(feature.getName());
                this.setOpaque(true);
                this.setBackground(list.getBackground());
                return this;
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class LicenseListCellRenderer
    extends DefaultListCellRenderer {
        private LicenseListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof LicenseContent) {
                LicenseContent license = (LicenseContent)value;
                this.setIcon(license.isValid() ? ImageResource.approve() : ImageResource.remove());
                this.setText(license.getProductName());
                this.setOpaque(true);
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

