/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.urcap;

import com.ur.polyscope.license.LicenseManager;
import com.ur.polyscope.urcaps.URCapStartFilter;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class LicensedURCapStartFilter
implements URCapStartFilter {
    public static final String BUNDLE_REQUIRE_LICENSE = "Bundle-RequireLicense";
    private LicenseManager licenseManager;

    @Inject
    public LicensedURCapStartFilter(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean allowStart(Bundle bundle) {
        String requireLicense = (String)bundle.getHeaders().get(BUNDLE_REQUIRE_LICENSE);
        String id = bundle.getSymbolicName();
        if (Boolean.TRUE.toString().equalsIgnoreCase(requireLicense) && !this.licenseManager.isFeatureActive(id)) {
            Log.info((String)("Omitted licenced URCap: " + id + " due to missing license."));
            return false;
        }
        return true;
    }
}

