/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.license.internal.util;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateVerifier {
    private static final String DATE_PATTERN_PART = "\\d{4}-\\d{2}-\\d{2}";
    private static final String TIME_PATTERN_PART = "T\\d{2}:\\d{2}:\\d{2}(\\.\\d*)?";
    private static final String OFFSET_PATTERN_PART = "[+-]\\d{2}:\\d{2}";
    private static final Pattern localPattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern isoPattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d*)?[Zz]|\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d*)?[+-]\\d{2}:\\d{2}");

    private DateVerifier() {
    }

    public static boolean isDateOutsideValidRange(String validFrom, String validTo) {
        Matcher m = localPattern.matcher(validTo);
        if (m.matches()) {
            return DateVerifier.isDateOutsideValidRangeByLocalDateFormat(validFrom, validTo);
        }
        m = isoPattern.matcher(validTo);
        if (m.matches()) {
            return DateVerifier.isDateOutsideValidRangeByIsoDateFormat(validFrom, validTo);
        }
        return true;
    }

    private static boolean isDateOutsideValidRangeByIsoDateFormat(String validFrom, String validTo) {
        ZonedDateTime validFromIso = ZonedDateTime.parse(validFrom);
        ZonedDateTime validToIso = ZonedDateTime.parse(validTo);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return validFromIso.isAfter(now.truncatedTo(ChronoUnit.SECONDS)) || validToIso.isBefore(now.truncatedTo(ChronoUnit.SECONDS));
    }

    private static boolean isDateOutsideValidRangeByLocalDateFormat(String validFrom, String validTo) {
        LocalDate validFromLocalDate = LocalDate.parse(validFrom, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate validToLocalDate = LocalDate.parse(validTo, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate now = LocalDate.now();
        return validFromLocalDate.isAfter(now) || validToLocalDate.isBefore(now);
    }

    public static boolean isDateExpired(String expirationDate) {
        Matcher m = localPattern.matcher(expirationDate);
        if (m.matches()) {
            LocalDate expireLocalDate = LocalDate.parse(expirationDate, DateTimeFormatter.ISO_LOCAL_DATE);
            return expireLocalDate.isBefore(LocalDate.now());
        }
        m = isoPattern.matcher(expirationDate);
        if (m.matches()) {
            ZonedDateTime expireIso = ZonedDateTime.parse(expirationDate);
            return expireIso.isBefore(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS));
        }
        return true;
    }

    public static boolean isValidDateFormat(String date) {
        return localPattern.matcher(date).matches() || isoPattern.matcher(date).matches();
    }
}

