/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence;

import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CompositeConversionStrategy<T>
extends ConversionStrategyTemplate<T> {
    private final StrategyMap<T> strategyMap = new StrategyMap();

    public CompositeConversionStrategy(Class<T> supportedType) {
        super(supportedType);
    }

    public <S extends T> CompositeConversionStrategy<T> add(ConversionStrategy<S> strategy) {
        this.strategyMap.add(strategy);
        return this;
    }

    @Override
    public void marshal(T toMarshal, PersistWriter writer) {
        if (toMarshal == null) {
            return;
        }
        for (Class<T> each : this.strategyMap.getTypes()) {
            if (!each.isInstance(toMarshal)) continue;
            this.marshal(each, toMarshal, writer);
            break;
        }
    }

    private <S extends T> void marshal(Class<S> type, T toMarshal, PersistWriter writer) {
        this.strategyMap.get(type).get(0).marshal(type.cast(toMarshal), writer);
    }

    @Override
    public T unmarshal(PersistReader reader) {
        T result;
        Class candidate;
        Class<?> type = reader.getRequiredType();
        if (type != null) {
            for (Class<T> each : this.strategyMap.getTypes()) {
                T result2;
                if (!each.isAssignableFrom(type) || (result2 = this.tryUnmarshal(each, reader)) == null) continue;
                return result2;
            }
        }
        if ((candidate = ((StrategyMap)this.strategyMap).get(reader.getNodeName())) != null && (result = this.tryUnmarshal(candidate, reader)) != null) {
            return result;
        }
        for (Class<T> each : this.strategyMap.getTypes()) {
            T result3 = this.tryUnmarshal(each, reader);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    private <S extends T> T tryUnmarshal(Class<S> type, PersistReader reader) {
        List<ConversionStrategy<S>> strategies = this.strategyMap.get(type);
        for (ConversionStrategy<S> each : strategies) {
            if (!each.canUnmarshalFrom(reader)) continue;
            return (T)each.unmarshal(reader);
        }
        return null;
    }

    @Override
    public Map<String, Class<? extends T>> getClassAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends T>> result = new HashMap<String, Class<? extends T>>();
        for (Class<T> each : this.strategyMap.getTypes()) {
            this.addClassAliases(result, each, forMarshalling);
        }
        return result;
    }

    private <S extends T> void addClassAliases(Map<String, Class<? extends T>> result, Class<S> type, boolean forMarshalling) {
        List<ConversionStrategy<S>> strategies = this.strategyMap.get(type);
        for (ConversionStrategy<S> each : strategies) {
            for (Map.Entry<String, Class<S>> eachEntry : each.getClassAliases(forMarshalling).entrySet()) {
                if (result.get(eachEntry.getKey()) == null) {
                    result.put(eachEntry.getKey(), eachEntry.getValue());
                    continue;
                }
                throw new IllegalStateException("Aliasing clash on string \"" + eachEntry.getKey() + "\"");
            }
        }
    }

    @Override
    public Map<String, Class<? extends T>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends T>> result = new HashMap<String, Class<? extends T>>();
        for (Class<T> each : this.strategyMap.getTypes()) {
            this.addTypeAliases(result, each, forMarshalling);
        }
        return result;
    }

    private <S extends T> void addTypeAliases(Map<String, Class<? extends T>> result, Class<S> type, boolean forMarshalling) {
        List<ConversionStrategy<S>> strategies = this.strategyMap.get(type);
        for (ConversionStrategy<S> each : strategies) {
            for (Map.Entry<String, Class<S>> eachEntry : each.getTypeAliases(forMarshalling).entrySet()) {
                if (result.get(eachEntry.getKey()) == null) {
                    result.put(eachEntry.getKey(), eachEntry.getValue());
                    continue;
                }
                throw new IllegalStateException("Aliasing clash on string \"" + eachEntry.getKey() + "\"");
            }
        }
    }

    private static class StrategyMap<T> {
        private final Map<Class<?>, List> map = new LinkedHashMap();

        public <S extends T> void add(ConversionStrategy<S> strategy) {
            Class<S> type = strategy.getSupportedType();
            ArrayList<ConversionStrategy<S>> existingStrategies = this.map.get(type);
            if (existingStrategies == null) {
                existingStrategies = new ArrayList<ConversionStrategy<S>>();
                this.map.put(type, existingStrategies);
            }
            existingStrategies.add(strategy);
        }

        public <S extends T> List<ConversionStrategy<S>> get(Class<S> key) {
            return this.map.get(key);
        }

        public List<Class<? extends T>> getTypes() {
            ArrayList<Class<T>> result = new ArrayList<Class<T>>();
            for (Class<?> type : this.map.keySet()) {
                result.add(type);
            }
            return result;
        }

        private Class<?> get(String nodeName) {
            for (List eachList : this.map.values()) {
                for (ConversionStrategy each : eachList) {
                    Class type = each.getClassAliases(false).get(nodeName);
                    if (type == null) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

