/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence;

import com.ur.polyscope.persistence.OptionsSection;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Options {
    private final Map<String, OptionsSection> keyToSections = new LinkedHashMap<String, OptionsSection>();

    public boolean hasSection(String key) {
        return this.keyToSections.containsKey(key);
    }

    public Iterator<String> getKeys() {
        return this.keyToSections.keySet().iterator();
    }

    public OptionsSection getSection(String key) {
        if (!this.keyToSections.containsKey(key)) {
            this.keyToSections.put(key, new OptionsSection());
        }
        return this.keyToSections.get(key);
    }

    public void setSection(String key, OptionsSection section) {
        this.keyToSections.put(key, section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer writer) {
        try {
            for (String each : this.keyToSections.keySet()) {
                writer.write("[" + each + "]\n");
                this.keyToSections.get(each).save(writer);
                writer.write("\n");
            }
        }
        catch (IOException ex) {
            Log.error((String)"Unable to persist options: ", (Throwable)ex);
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Log.error((String)"Failed to flush and close options", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) {
        BufferedReader bufferedReader = (BufferedReader)(reader instanceof BufferedReader ? reader : new BufferedReader(reader));
        try {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty() || !line.startsWith("[") || !line.endsWith("]")) continue;
                this.getSection(line.substring(1, line.length() - 1)).load(bufferedReader);
            }
        }
        catch (IOException ex) {
            Log.error((String)"Failed to load options from reader", (Throwable)ex);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ex) {
                Log.error((String)"Failed to close reader", (Throwable)ex);
            }
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.save(writer);
        return ((Object)writer).toString();
    }
}

