/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.persistence.Copyable;
import com.ur.polyscope.persistence.Dictionary;
import com.ur.polyscope.persistence.PrimitiveDictionary;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionsSection
implements Iterable<Map.Entry<String, String>>,
Dictionary,
Copyable<OptionsSection> {
    private static final String ASSIGNMENT_SEPARATOR = " = ";
    private static final String SEPARATOR = ", ";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("null|\\[[^\\]]*\\]");
    protected final Map<String, String> keyToValues = new LinkedHashMap<String, String>();

    public OptionsSection() {
    }

    public OptionsSection(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.keyToValues.put(key, map.get(key));
        }
    }

    public OptionsSection clone() {
        return new OptionsSection(this.keyToValues);
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.keyToValues.put(key, Boolean.toString(value));
    }

    private String getValue(String key) {
        if (this.keyToValues.containsKey(key)) {
            return this.keyToValues.get(key);
        }
        return "";
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            String value = this.getValue(key);
            if (StringUtils.containsAnyIgnoreCase((String)value, (String[])new String[]{"true", "false"})) {
                return Boolean.parseBoolean(value);
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setInteger(String key, Integer value) {
        this.keyToValues.put(key, Integer.toString(value));
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        try {
            String value = this.getValue(key);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setDouble(String key, Double value) {
        this.keyToValues.put(key, Double.toString(value));
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        try {
            String value = this.getValue(key);
            return Double.valueOf(value.replace(",", "."));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setEnum(String key, Enum<?> enumeration) {
        try {
            this.keyToValues.put(key, enumeration.name());
        }
        catch (Exception e) {
            this.keyToValues.remove(key);
        }
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        try {
            String value = this.getValue(key);
            return Enum.valueOf(type, value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setLong(String key, Long value) {
        this.keyToValues.put(key, Long.toString(value));
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        try {
            String value = this.getValue(key);
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setFloat(String key, Float value) {
        this.keyToValues.put(key, Float.toString(value.floatValue()));
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        try {
            String value = this.getValue(key);
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setString(String key, String value) {
        if (StringUtils.isNullOrOnlyWhitespace((String)value)) {
            this.keyToValues.remove(key);
        } else {
            this.keyToValues.put(key, value);
        }
    }

    public String getString(String key) {
        return this.getValue(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        if (this.keyToValues.containsKey(key)) {
            return this.getValue(key);
        }
        return defaultValue;
    }

    @Override
    public void setUUID(String key, UUID value) {
        if (value == null) {
            this.keyToValues.remove(key);
        } else {
            this.keyToValues.put(key, value.toString());
        }
    }

    @Override
    public void setArrayOfFloatArrays(String key, float[][] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            ArrayList<String> arrayStrings = new ArrayList<String>();
            for (float[] each : value) {
                if (each == null) {
                    arrayStrings.add(null);
                    continue;
                }
                arrayStrings.add("[" + StringUtils.joinStringsWith((String)SEPARATOR, (float[])each) + "]");
            }
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (Object[])arrayStrings.toArray()));
        }
    }

    @Override
    public void setArrayOfDoubleArrays(String key, double[][] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            ArrayList<String> arrayStrings = new ArrayList<String>();
            for (double[] each : value) {
                if (each == null) {
                    arrayStrings.add(null);
                    continue;
                }
                arrayStrings.add("[" + StringUtils.joinStringsWith((String)SEPARATOR, (double[])each) + "]");
            }
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (Object[])arrayStrings.toArray()));
        }
    }

    @Override
    public UUID getUUID(String key, UUID defaultUUID) {
        if (this.keyToValues.containsKey(key)) {
            try {
                return UUID.fromString(this.keyToValues.get(key));
            }
            catch (Exception e) {
                return defaultUUID;
            }
        }
        return defaultUUID;
    }

    @Override
    public float[][] getArrayOfFloatArrays(String key, float[][] defaultValue) {
        try {
            String value = this.keyToValues.get(key);
            value = StringUtils.trimStartAndEnd((String)"[", (String)"]", (String)value);
            ArrayList<float[]> result = new ArrayList<float[]>();
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(value);
            while (arrayMatcher.find()) {
                String arrayAsString = arrayMatcher.group();
                result.add(PrimitiveUtils.parseFloatArray((String[])this.getArray(arrayAsString)));
            }
            return (float[][])result.toArray((T[])new float[0][]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public double[][] getArrayOfDoubleArrays(String key, double[][] defaultValue) {
        try {
            String value = this.keyToValues.get(key);
            value = StringUtils.trimStartAndEnd((String)"[", (String)"]", (String)value);
            ArrayList<double[]> result = new ArrayList<double[]>();
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(value);
            while (arrayMatcher.find()) {
                String arrayAsString = arrayMatcher.group();
                result.add(PrimitiveUtils.parseDoubleArray((String[])this.getArray(arrayAsString)));
            }
            return (double[][])result.toArray((T[])new double[0][]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setStringArray(String key, String[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (Object[])value));
        }
    }

    @Override
    public String[] getStringArray(String key, String[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return resultAsArray;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void setDoubleArray(String key, double[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (double[])value));
        }
    }

    @Override
    public void setIntArray(String key, int[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (int[])value));
        }
    }

    @Override
    public void setLongArray(String key, long[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (long[])value));
        }
    }

    @Override
    public void setFloatArray(String key, float[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (float[])value));
        }
    }

    private void setArray(String key, String arrayValue) {
        this.keyToValues.put(key, "[" + arrayValue + "]");
    }

    @Override
    public void setBooleanArray(String key, boolean[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith((String)SEPARATOR, (boolean[])value));
        }
    }

    @Override
    public double[] getDoubleArray(String key, double[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseDoubleArray((String[])resultAsArray);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public int[] getIntArray(String key, int[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseIntegerArray((String[])resultAsArray);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public long[] getLongArray(String key, long[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseLongArray((String[])resultAsArray);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public float[] getFloatArray(String key, float[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseFloatArray((String[])resultAsArray);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String[] getArrayForKey(String key) {
        String value = this.keyToValues.get(key);
        return this.getArray(value);
    }

    private String[] getArray(String value) {
        if ((value = StringUtils.trimStartAndEnd((String)"[", (String)"]", (String)value.trim())).isEmpty()) {
            return new String[0];
        }
        String[] result = StringUtils.split((String)SEPARATOR, (String)value);
        this.preserveNullValues(result);
        return result;
    }

    @Override
    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        if (!this.keyToValues.containsKey(key)) {
            return defaultValue;
        }
        try {
            return this.doGetBooleanArray(key, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean[] doGetBooleanArray(String key, boolean[] defaultValue) {
        String[] resultAsArray;
        for (String s : resultAsArray = this.getArrayForKey(key)) {
            if (StringUtils.containsAnyIgnoreCase((String)s.trim(), (String[])new String[]{"true", "false"})) continue;
            return defaultValue;
        }
        return PrimitiveUtils.parseBooleanArray((String[])resultAsArray);
    }

    private void preserveNullValues(String[] result) {
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].equals("null")) continue;
            result[i] = null;
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.keyToValues.entrySet().iterator();
    }

    public Iterator<String> keyIterator() {
        return this.keyToValues.keySet().iterator();
    }

    public void save(Writer writer) {
        try {
            for (String each : this.keyToValues.keySet()) {
                writer.write(each + ASSIGNMENT_SEPARATOR + this.keyToValues.get(each) + "\n");
            }
        }
        catch (IOException ex) {
            Log.error((String)"Unable to persist options: ", (Throwable)ex);
        }
    }

    public void load(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().isEmpty()) {
                    return;
                }
                if (line.startsWith("#")) continue;
                String[] split = line.split(ASSIGNMENT_SEPARATOR, 2);
                this.keyToValues.put(split[0], StringUtils.trimCommentAway((String)split[1]));
            }
        }
        catch (Exception ex) {
            Log.error((String)"Failed to load options from reader", (Throwable)ex);
        }
    }

    @Override
    public Set<String> getKeys() {
        return new LinkedHashSet<String>(this.keyToValues.keySet());
    }

    @Override
    public void loadFromStringRepresentation(String representation) {
        BufferedReader reader = new BufferedReader(new StringReader(representation));
        this.load(reader);
    }

    @Override
    public boolean isSet(String key) {
        return this.keyToValues.containsKey(key);
    }

    @Override
    public boolean remove(String key) {
        if (this.keyToValues.containsKey(key)) {
            this.keyToValues.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean equivalent(PrimitiveDictionary other) {
        boolean same = other instanceof OptionsSection;
        if (same) {
            OptionsSection options = (OptionsSection)other;
            same = this.keyToValues.equals(options.keyToValues);
        }
        return same;
    }

    @Override
    public OptionsSection copy() {
        return new OptionsSection(this.keyToValues);
    }
}

