/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.google.common.base.Objects;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.LocationType;
import java.io.File;
import java.util.UUID;

public class ConceptLocationFactoryDummy
implements ConceptLocationFactory {
    public ConceptLocation get(String name, String path, LocationType type) {
        return new DummyConceptLocation(name, path, type);
    }

    public ConceptLocation getUnique(ConceptLocation other) {
        return this.get(other.getName() + UUID.randomUUID(), other.getPath(), other.getType());
    }

    private class DummyConceptLocation
    extends ConceptLocation {
        private String name;
        private String path;
        private LocationType type;

        public DummyConceptLocation(String name, String path, LocationType type) {
            this.name = name;
            this.path = path;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isExternalTo(ConceptLocation other) {
            return false;
        }

        public LocationType getType() {
            return this.type;
        }

        public String getFullPath() {
            String extension = "";
            switch (this.type.getConcept()) {
                case INSTALLATION: {
                    extension = "installation";
                    break;
                }
                case PROGRAM: {
                    extension = "urp";
                    break;
                }
                case BACKUP: {
                    extension = "old" + this.type.getInstance();
                    break;
                }
                case VARIABLE: {
                    extension = "variables";
                    break;
                }
            }
            return this.path + File.separator + this.name + "." + extension;
        }

        public boolean isValid() {
            return false;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ConceptLocation other = (ConceptLocation)o;
            return this.getName().equals(other.getName()) && this.getPath().equals(other.getPath()) && this.getType().isConcept(other.getType().getConcept());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getName(), this.getPath(), this.getType().getInstance(), this.getType().getConcept()});
        }
    }
}

