/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.MoveOperationBuilder;
import com.ur.polyscope.concept.operations.UserInputResource;
import com.ur.polyscope.concept.operations.internal.MoveBuilderContribution;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class MoveOperationsBuilderImpl
implements MoveOperationBuilder {
    private final Set<MoveBuilderContribution> moveBuilders;

    @Inject
    public MoveOperationsBuilderImpl(Set<MoveBuilderContribution> moveBuilders) {
        this.moveBuilders = new HashSet<MoveBuilderContribution>(moveBuilders);
    }

    public List<ConceptOperation> buildMove(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
        for (MoveBuilderContribution moveBuilder : this.moveBuilders) {
            if (!moveBuilder.isSupported(source, dest)) continue;
            return moveBuilder.buildMove(source, dest, input);
        }
        return Collections.emptyList();
    }

    public List<ConceptOperation> buildRename(ConceptLocation source, ConceptLocation dest) {
        for (MoveBuilderContribution moveBuilder : this.moveBuilders) {
            if (!moveBuilder.isSupported(source, dest)) continue;
            return moveBuilder.buildRename(source, dest);
        }
        return Collections.emptyList();
    }
}

