/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.ConceptOperationFactory;
import com.ur.polyscope.concept.operations.ProgramInstallationService;
import com.ur.polyscope.concept.operations.UserInputResource;
import com.ur.polyscope.concept.operations.internal.CopyBuilderContribution;
import com.ur.polyscope.concept.operations.internal.MoveBuilderContribution;
import com.ur.polyscope.concept.operations.internal.UpdateInstallationProgramLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.LocationType;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.concept.operations.resource.InstallationResource;
import com.ur.polyscope.concept.operations.resource.ProgramResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class ProgramOperationBuilder
implements CopyBuilderContribution,
MoveBuilderContribution {
    private final ConceptOperationFactory conceptOperationFactory;
    private final ProgramInstallationService programInstallationService;
    private final ConceptLocationFactory conceptLocationFactory;

    @Inject
    public ProgramOperationBuilder(ConceptOperationFactory conceptOperationFactory, ProgramInstallationService programInstallationService, ConceptLocationFactory conceptLocationFactory) {
        this.conceptOperationFactory = conceptOperationFactory;
        this.programInstallationService = programInstallationService;
        this.conceptLocationFactory = conceptLocationFactory;
    }

    @Override
    public boolean isSupported(ConceptLocation source, ConceptLocation dest) {
        return source.getType().isConcept(LocationType.Concepts.PROGRAM) && dest.getType().isConcept(LocationType.Concepts.PROGRAM);
    }

    public List<ConceptOperation> buildCopy(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
        return this.relocateOperation(source, dest, new CopyConceptOperation(), input);
    }

    public List<ConceptOperation> buildMove(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
        return this.relocateOperation(source, dest, new MoveConceptOperation(), input);
    }

    public List<ConceptOperation> buildRename(ConceptLocation source, ConceptLocation dest) {
        return this.renameOperation(source, dest);
    }

    private List<ConceptOperation> renameOperation(ConceptLocation source, ConceptLocation dest) {
        List<ConceptOperation> operations = new ArrayList<ConceptOperation>();
        ProgramResource destProgram = this.programInstallationService.getProgram(dest);
        if (!destProgram.exists()) {
            operations = this.relocateOperation(source, dest, new MoveConceptOperation(), new NoOverwriteInput());
        } else {
            operations.add(new ConceptOperation(){

                public boolean canExecute() {
                    return false;
                }

                public boolean execute() {
                    return false;
                }

                public String getError() {
                    return "";
                }
            });
        }
        return operations;
    }

    private List<ConceptOperation> relocateOperation(ConceptLocation source, ConceptLocation dest, RelocateConceptOperation relocate, UserInputResource input) {
        ArrayList<ConceptOperation> operations = new ArrayList<ConceptOperation>();
        operations.add(relocate.get(source, dest, input));
        ProgramResource sourceProgram = this.programInstallationService.getProgram(source);
        InstallationResource installation = sourceProgram.getInstallation();
        ConceptLocation installationLocation = installation.getLocation();
        boolean fileExists = this.isConceptLocationExist(installationLocation);
        if (!fileExists) {
            return operations;
        }
        if (dest.isExternalTo(source) || source.isExternalTo(dest)) {
            operations.addAll(this.copyInstallation(installation, dest, input));
        } else {
            operations.add(new UpdateInstallationProgramLocation(dest, installation.getLocation()));
        }
        return operations;
    }

    protected boolean isConceptLocationExist(ConceptLocation conceptLocation) {
        String path = conceptLocation.getFullPath();
        File file = new File(path);
        return file.exists();
    }

    private List<ConceptOperation> copyInstallation(InstallationResource sourceInstallation, ConceptLocation programDest, UserInputResource input) {
        ConceptLocation installationSourceLoc = sourceInstallation.getLocation();
        ConceptLocation installationDestLoc = this.conceptLocationFactory.get(installationSourceLoc.getName(), programDest.getPath(), Types.getInstallation());
        ConceptOperation copyInstallation = this.conceptOperationFactory.getCopy(installationSourceLoc, installationDestLoc, input);
        ArrayList<ConceptOperation> operations = new ArrayList<ConceptOperation>();
        operations.add(copyInstallation);
        operations.add(new UpdateInstallationProgramLocation(programDest, installationDestLoc));
        ConceptLocation variableSourceLoc = sourceInstallation.getVariables().getLocation();
        ConceptLocation variableDestLoc = this.conceptLocationFactory.get(installationDestLoc.getName(), programDest.getPath(), Types.getVariable());
        operations.add(this.conceptOperationFactory.getCopy(variableSourceLoc, variableDestLoc, input));
        return operations;
    }

    private static class NoOverwriteInput
    implements UserInputResource {
        private NoOverwriteInput() {
        }

        public boolean canOverwriteFileName(ConceptLocation destination) {
            return false;
        }
    }

    private class MoveConceptOperation
    implements RelocateConceptOperation {
        private MoveConceptOperation() {
        }

        @Override
        public ConceptOperation get(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
            return ProgramOperationBuilder.this.conceptOperationFactory.getMove(source, dest, input);
        }
    }

    private class CopyConceptOperation
    implements RelocateConceptOperation {
        private CopyConceptOperation() {
        }

        @Override
        public ConceptOperation get(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
            return ProgramOperationBuilder.this.conceptOperationFactory.getCopy(source, dest, input);
        }
    }

    private static interface RelocateConceptOperation {
        public ConceptOperation get(ConceptLocation var1, ConceptLocation var2, UserInputResource var3);
    }
}

