/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.internal.io.ProgramReader;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class UpdateInstallationProgramLocation
implements ConceptOperation {
    private static final String INSTALLATION_RELATIVE_PATH_REGEX = "(installationRelativePath=\")([^\"]*)(\")";
    private static final String DIRECTORY_REGEX = "(directory=\")([^\"]*)(\")";
    private final ConceptLocation programLoc;
    private final ConceptLocation installationLocation;

    public UpdateInstallationProgramLocation(ConceptLocation programLoc, ConceptLocation installationLoc) {
        this.programLoc = programLoc;
        this.installationLocation = installationLoc;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean execute() {
        try {
            this.updateProgramDirectory();
        }
        catch (IOException e) {
            Log.error((String)"Could not update program directory", (Throwable)e);
            return false;
        }
        return true;
    }

    public String getError() {
        return "";
    }

    private void updateProgramDirectory() throws IOException {
        File file = new File(this.programLoc.getFullPath());
        boolean isGZipFile = ProgramReader.isGZipFile(file);
        String programContent = this.readProgramFile(file);
        programContent = this.updateDirectories(programContent);
        if (isGZipFile) {
            this.writeCompressedProgramFile(file, programContent);
            return;
        }
        this.writeProgramFile(file, programContent);
    }

    private String updateDirectories(String programContent) {
        programContent = this.replaceRegex(DIRECTORY_REGEX, programContent, this.programLoc.getPath());
        return this.replaceRegex(INSTALLATION_RELATIVE_PATH_REGEX, programContent, ProgramReader.getRelativePath(this.programLoc.getFullPath(), this.installationLocation.getFullPath()));
    }

    private String replaceRegex(String regex, String xmlContent, String newRelativePath) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(xmlContent);
        if (matcher.find()) {
            xmlContent = matcher.replaceFirst("$1" + newRelativePath + "$3");
        }
        return xmlContent;
    }

    private String readProgramFile(File file) throws IOException {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            InputStream inputStream = stream;
            if (ProgramReader.isGZipFile(file)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            String programContent = this.readInputStreamToString(inputStream);
            inputStream.close();
            String string = programContent;
            return string;
        }
    }

    private String readInputStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private void writeCompressedProgramFile(File file, String programContent) throws IOException {
        try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            GZIPOutputStream outputStream = new GZIPOutputStream(stream);
            this.writeProgramToOutputStream(outputStream, programContent);
        }
    }

    private void writeProgramFile(File file, String programContent) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.writeProgramToOutputStream(outputStream, programContent);
        }
    }

    private void writeProgramToOutputStream(OutputStream outputStream, String programContent) throws IOException {
        byte[] programContentBytes = programContent.getBytes(StandardCharsets.UTF_8);
        outputStream.write(programContentBytes);
        outputStream.flush();
        outputStream.close();
    }
}

