/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal.io;

import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ProgramReader {
    private ProgramReader() {
    }

    public static boolean isGZipFile(File file) {
        int magic = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
        }
        catch (IOException e) {
            Log.error((String)"Could not determine if file is GZIP", (Throwable)e);
        }
        return magic == 35615;
    }

    public static String getRelativePath(String sourcePath, String targetPath) {
        Path source = Paths.get(sourcePath, new String[0]);
        if (!source.toFile().isDirectory()) {
            source = source.getParent();
        }
        Path target = Paths.get(targetPath, new String[0]);
        Path relativePath = source.relativize(target);
        return ProgramReader.removeExtension(relativePath);
    }

    private static String removeExtension(Path path) {
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            fileName = fileName.substring(0, dotIndex);
        }
        return fileName;
    }
}

