/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.contributions;

import com.ur.polyscope.gripper.internal.gripper.ContributionConfigurationImpl;
import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.installation.InstallationValid;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyGripperProgramNodeService;
import com.ur.polyscope.gripper.internal.gripper.toolbar.ProxyGripperToolbarService;
import com.ur.polyscope.installation.urcap.proxy.DriverNodeBuilder;
import com.ur.polyscope.installation.urcap.proxy.DriverNodeFactory;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.driver.gripper.ContributionConfiguration;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ProxyGripper {
    private static final Logger LOG = LogFactory.createLogger(ProxyGripper.class);

    public ProxyGripper(BundleContext bundleContext) {
        try {
            this.registerAlreadyAddedGripper(bundleContext);
            this.addGripperListener(bundleContext);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("GripperContribution filter has wrong syntax", (Throwable)e);
        }
    }

    private void registerAlreadyAddedGripper(BundleContext context) throws InvalidSyntaxException {
        for (ServiceReference serviceReference : context.getServiceReferences(GripperContribution.class, null)) {
            this.setupProxy(context, (ServiceReference<GripperContribution>)serviceReference);
        }
    }

    private void addGripperListener(final BundleContext context) throws InvalidSyntaxException {
        context.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    ProxyGripper.this.setupProxy(context, (ServiceReference<GripperContribution>)event.getServiceReference());
                }
            }
        }, "( | (objectClass=" + GripperContribution.class.getName() + "))");
    }

    private void setupProxy(BundleContext context, ServiceReference<GripperContribution> gripperContributionReference) {
        GripperContribution gripperContribution = (GripperContribution)context.getService(gripperContributionReference);
        ContributionConfigurationImpl contributionConfiguration = new ContributionConfigurationImpl();
        ProxiedException exception = null;
        try {
            gripperContribution.configureContribution((ContributionConfiguration)contributionConfiguration);
        }
        catch (RuntimeException e) {
            exception = new ProxiedException(e, gripperContribution.getClass(), "com.ur.polyscope.gripper.internal.contributions.ProxyGripper", "setupProxy");
        }
        this.registerServices(context, gripperContribution, contributionConfiguration, (RuntimeException)exception);
    }

    private void registerServices(BundleContext context, GripperContribution gripperContribution, ContributionConfigurationImpl contributionConfiguration, RuntimeException exception) {
        GripperContext gripperContext = new GripperContext(gripperContribution.getClass());
        if (exception != null) {
            gripperContext.setInitializationException(exception);
        }
        DriverNodeBuilder builder = DriverNodeFactory.createBuilder();
        InstallationValid installationValid = new InstallationValid();
        ProxyGripperInstallationNodeService installationNodeService = new ProxyGripperInstallationNodeService(builder, gripperContribution, gripperContext, installationValid, contributionConfiguration, exception);
        context.registerService(SwingInstallationNodeService.class, (Object)installationNodeService, null);
        context.registerService(SwingProgramNodeService.class, (Object)new ProxyGripperProgramNodeService(gripperContribution, gripperContext, installationValid, contributionConfiguration), null);
        context.registerService(SwingToolbarService.class, (Object)new ProxyGripperToolbarService(gripperContribution, gripperContext, contributionConfiguration), null);
    }
}

