/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper;

import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure11;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure13;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure15;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure17;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure19;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure21;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure3;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure5;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure7;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl$AjcClosure9;
import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.GripperListBuilderImpl;
import com.ur.polyscope.gripper.internal.gripper.GripperSetProviderImpl;
import com.ur.polyscope.gripper.internal.gripper.MultiGripperCapabilityImpl;
import com.ur.polyscope.gripper.internal.gripper.RegisteredCapabilitiesImpl;
import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.program.ProgramTreeRenderingTriggerer;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.urcap.api.contribution.driver.gripper.CalledOutsideGripperConfigurationPhase;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.contribution.driver.gripper.capability.CapabilityAlreadyRegistered;
import com.ur.urcap.api.contribution.driver.gripper.capability.GripForceCapability;
import com.ur.urcap.api.contribution.driver.gripper.capability.GripVacuumCapability;
import com.ur.urcap.api.contribution.driver.gripper.capability.GripperCapabilities;
import com.ur.urcap.api.contribution.driver.gripper.capability.MultiGripperCapability;
import com.ur.urcap.api.contribution.driver.gripper.capability.SpeedCapability;
import com.ur.urcap.api.contribution.driver.gripper.capability.WidthCapability;
import com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.GripperList;
import com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.GripperListBuilder;
import com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.GripperListProvider;
import com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.LessThanTwoGrippers;
import com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.RegisteredCapabilities;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Pressure;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class GripperCapabilitiesImpl
implements GripperCapabilities {
    private static final String MULTI_GRIPPER = "MultiGripper";
    private final TextResource textResource;
    private final Provider<ProgramTreeRenderingTriggerer> programTreeRenderingProvider;
    private final Localization localization;
    private GripperContext context;
    private Class<? extends GripperContribution> gripperContributionClass;
    private boolean isMultiGripperRegistered;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Inject
    public GripperCapabilitiesImpl(final ProgramTreeRenderingTriggerer programTreeRenderingTriggerer, TextResource textResource, Localization localization) {
        this.textResource = textResource;
        this.programTreeRenderingProvider = new Provider<ProgramTreeRenderingTriggerer>(){

            public ProgramTreeRenderingTriggerer get() {
                return programTreeRenderingTriggerer;
            }
        };
        this.localization = localization;
    }

    public void init(GripperContext gripperContext, GripperContribution gripperContribution) {
        this.context = gripperContext;
        this.gripperContributionClass = gripperContribution.getClass();
    }

    public WidthCapability registerWidthCapability(double minWidth, double maxWidth, double defaultGripWidth, double defaultReleaseWidth, @NotNull Length.Unit unit) {
        Object object;
        double d = minWidth;
        double d2 = maxWidth;
        double d3 = defaultGripWidth;
        double d4 = defaultReleaseWidth;
        Length.Unit unit2 = unit;
        Object[] objectArray = new Object[]{Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit2, joinPoint};
        GripperCapabilitiesImpl$AjcClosure3 gripperCapabilitiesImpl$AjcClosure3 = new GripperCapabilitiesImpl$AjcClosure3(objectArray2);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure3.unlink();
            throw throwable;
        }
        return (WidthCapability)object;
    }

    public GripForceCapability registerGrippingForceCapability(double minForce, double maxForce, double defaultGripForce, @NotNull Force.Unit unit) {
        Object object;
        double d = minForce;
        double d2 = maxForce;
        double d3 = defaultGripForce;
        Force.Unit unit2 = unit;
        Object[] objectArray = new Object[]{Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit2, joinPoint};
        GripperCapabilitiesImpl$AjcClosure7 gripperCapabilitiesImpl$AjcClosure7 = new GripperCapabilitiesImpl$AjcClosure7(objectArray2);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure7.unlink();
            throw throwable;
        }
        return (GripForceCapability)object;
    }

    public SpeedCapability registerSpeedCapability(double minSpeed, double maxSpeed, double defaultGripSpeed, double defaultReleaseSpeed, @NotNull Speed.Unit unit) {
        Object object;
        double d = minSpeed;
        double d2 = maxSpeed;
        double d3 = defaultGripSpeed;
        double d4 = defaultReleaseSpeed;
        Speed.Unit unit2 = unit;
        Object[] objectArray = new Object[]{Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit2, joinPoint};
        GripperCapabilitiesImpl$AjcClosure11 gripperCapabilitiesImpl$AjcClosure11 = new GripperCapabilitiesImpl$AjcClosure11(objectArray2);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure11.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure11.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure11.unlink();
            throw throwable;
        }
        return (SpeedCapability)object;
    }

    public GripVacuumCapability registerGrippingVacuumCapability(double minVacuum, double maxVacuum, double defaultGripVacuum, @NotNull Pressure.Unit unit) {
        Object object;
        double d = minVacuum;
        double d2 = maxVacuum;
        double d3 = defaultGripVacuum;
        Pressure.Unit unit2 = unit;
        Object[] objectArray = new Object[]{Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit2, joinPoint};
        GripperCapabilitiesImpl$AjcClosure15 gripperCapabilitiesImpl$AjcClosure15 = new GripperCapabilitiesImpl$AjcClosure15(objectArray2);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure15.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure15.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure15.unlink();
            throw throwable;
        }
        return (GripVacuumCapability)object;
    }

    public MultiGripperCapability registerMultiGripperCapability(@NotNull GripperListProvider gripperListProvider) {
        Object object;
        GripperListProvider gripperListProvider2 = gripperListProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)gripperListProvider2);
        Object[] objectArray = new Object[]{this, gripperListProvider2, joinPoint};
        GripperCapabilitiesImpl$AjcClosure19 gripperCapabilitiesImpl$AjcClosure19 = new GripperCapabilitiesImpl$AjcClosure19(objectArray);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure19.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure19.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure19.unlink();
            throw throwable;
        }
        return (MultiGripperCapability)object;
    }

    private List<SelectableGripper> createGrippers(GripperListProvider gripperListProvider) {
        if (this.isAlreadyLoaded()) {
            return new ArrayList<SelectableGripper>(this.context.getGrippers());
        }
        GripperList gripperList = gripperListProvider.getGripperList((GripperListBuilder)new GripperListBuilderImpl(this.gripperContributionClass), this.localization.getLocale());
        this.checkIfGripperListNull(gripperList);
        ArrayList<SelectableGripper> grippers = new ArrayList<SelectableGripper>();
        for (SelectableGripper gripper : gripperList) {
            grippers.add(gripper);
        }
        return grippers;
    }

    private boolean isAlreadyLoaded() {
        return !this.context.getGrippers().isEmpty();
    }

    private void checkIfGripperListNull(GripperList gripperList) {
        if (gripperList == null) {
            throw new LessThanTwoGrippers("Gripper list must have at least two grippers");
        }
    }

    private HashMap<SelectableGripper, RegisteredCapabilities> createCapabilityMap(@NotNull GripperContext context, List<SelectableGripper> grippers) {
        GripperContext gripperContext = context;
        List<SelectableGripper> list = grippers;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)gripperContext, list);
        Object[] objectArray = new Object[]{this, gripperContext, list, joinPoint};
        GripperCapabilitiesImpl$AjcClosure21 gripperCapabilitiesImpl$AjcClosure21 = new GripperCapabilitiesImpl$AjcClosure21(objectArray);
        return (HashMap)NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperCapabilitiesImpl$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    private void checkIfRegisteredOutsideScope(String param) {
        if (!this.context.isCapabilityRegistrationAllowed()) {
            throw new CalledOutsideGripperConfigurationPhase("Cannot register `" + param + "` capability outside the scope of GripperContribution.configureGripper()");
        }
    }

    private void checkIfCapabilityAlreadyRegistered(String param) {
        if (this.context.containsParam(param)) {
            this.throwAlreadyRegistered(param);
        }
    }

    private void checkIfMultiGripperAlreadyRegistered(String capabilityName) {
        if (this.isMultiGripperRegistered) {
            this.throwAlreadyRegistered(capabilityName);
        }
        this.isMultiGripperRegistered = true;
    }

    private void throwAlreadyRegistered(String param) {
        throw new CapabilityAlreadyRegistered("Capability `" + param + "` already registered for " + this.gripperContributionClass.getSimpleName());
    }

    static {
        GripperCapabilitiesImpl.ajc$preClinit();
    }

    static final /* synthetic */ WidthCapability registerWidthCapability_aroundBody0(GripperCapabilitiesImpl ajc$this, double minWidth, double maxWidth, double defaultGripWidth, double defaultReleaseWidth, Length.Unit unit, JoinPoint joinPoint) {
        Length.Unit internalUnit = Length.Unit.internal((Length.Unit)unit);
        ajc$this.checkIfRegisteredOutsideScope("WIDTH");
        ajc$this.checkIfCapabilityAlreadyRegistered("WIDTH");
        WidthParam widthParam = new WidthParam("WIDTH", ajc$this.textResource.width(), Length.from((double)minWidth, (Length.Unit)internalUnit), (Length)Length.from((double)maxWidth, (Length.Unit)unit), (Length)Length.from((double)defaultGripWidth, (Length.Unit)unit), (Length)Length.from((double)defaultReleaseWidth, (Length.Unit)unit));
        widthParam.setProgramTreeRenderingProvider(ajc$this.programTreeRenderingProvider);
        ajc$this.context.appendParam(widthParam);
        return widthParam;
    }

    static final /* synthetic */ WidthCapability registerWidthCapability_aroundBody2(GripperCapabilitiesImpl gripperCapabilitiesImpl, double d, double d2, double d3, double d4, Length.Unit unit, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperCapabilitiesImpl, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit, joinPoint};
        GripperCapabilitiesImpl$AjcClosure1 gripperCapabilitiesImpl$AjcClosure1 = new GripperCapabilitiesImpl$AjcClosure1(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperCapabilitiesImpl$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure1.unlink();
            throw throwable;
        }
        return (WidthCapability)object;
    }

    static final /* synthetic */ GripForceCapability registerGrippingForceCapability_aroundBody4(GripperCapabilitiesImpl ajc$this, double minForce, double maxForce, double defaultGripForce, Force.Unit unit, JoinPoint joinPoint) {
        ajc$this.checkIfRegisteredOutsideScope("FORCE");
        ajc$this.checkIfCapabilityAlreadyRegistered("FORCE");
        GripForceParam forceParam = new GripForceParam("FORCE", ajc$this.textResource.force(), Force.from((double)minForce, (Force.Unit)unit), Force.from((double)maxForce, (Force.Unit)unit), Force.from((double)defaultGripForce, (Force.Unit)unit));
        forceParam.setProgramTreeRenderingProvider(ajc$this.programTreeRenderingProvider);
        ajc$this.context.appendParam(forceParam);
        return forceParam;
    }

    static final /* synthetic */ GripForceCapability registerGrippingForceCapability_aroundBody6(GripperCapabilitiesImpl gripperCapabilitiesImpl, double d, double d2, double d3, Force.Unit unit, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperCapabilitiesImpl, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit, joinPoint};
        GripperCapabilitiesImpl$AjcClosure5 gripperCapabilitiesImpl$AjcClosure5 = new GripperCapabilitiesImpl$AjcClosure5(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperCapabilitiesImpl$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure5.unlink();
            throw throwable;
        }
        return (GripForceCapability)object;
    }

    static final /* synthetic */ SpeedCapability registerSpeedCapability_aroundBody8(GripperCapabilitiesImpl ajc$this, double minSpeed, double maxSpeed, double defaultGripSpeed, double defaultReleaseSpeed, Speed.Unit unit, JoinPoint joinPoint) {
        ajc$this.checkIfRegisteredOutsideScope("SPEED");
        ajc$this.checkIfCapabilityAlreadyRegistered("SPEED");
        SpeedParam speedParam = new SpeedParam("SPEED", ajc$this.textResource.speed(), Speed.from((double)minSpeed, (Speed.Unit)unit), Speed.from((double)maxSpeed, (Speed.Unit)unit), Speed.from((double)defaultGripSpeed, (Speed.Unit)unit), Speed.from((double)defaultReleaseSpeed, (Speed.Unit)unit));
        speedParam.setProgramTreeRenderingProvider(ajc$this.programTreeRenderingProvider);
        ajc$this.context.appendParam(speedParam);
        return speedParam;
    }

    static final /* synthetic */ SpeedCapability registerSpeedCapability_aroundBody10(GripperCapabilitiesImpl gripperCapabilitiesImpl, double d, double d2, double d3, double d4, Speed.Unit unit, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperCapabilitiesImpl, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4), unit, joinPoint};
        GripperCapabilitiesImpl$AjcClosure9 gripperCapabilitiesImpl$AjcClosure9 = new GripperCapabilitiesImpl$AjcClosure9(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperCapabilitiesImpl$AjcClosure9.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure9.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure9.unlink();
            throw throwable;
        }
        return (SpeedCapability)object;
    }

    static final /* synthetic */ GripVacuumCapability registerGrippingVacuumCapability_aroundBody12(GripperCapabilitiesImpl ajc$this, double minVacuum, double maxVacuum, double defaultGripVacuum, Pressure.Unit unit, JoinPoint joinPoint) {
        ajc$this.checkIfRegisteredOutsideScope("VACUUM");
        ajc$this.checkIfCapabilityAlreadyRegistered("VACUUM");
        GripVacuumParam vacuumParam = new GripVacuumParam("VACUUM", ajc$this.textResource.vacuum(), Pressure.from((double)minVacuum, (Pressure.Unit)unit), Pressure.from((double)maxVacuum, (Pressure.Unit)unit), Pressure.from((double)defaultGripVacuum, (Pressure.Unit)unit));
        vacuumParam.setProgramTreeRenderingProvider(ajc$this.programTreeRenderingProvider);
        ajc$this.context.appendParam(vacuumParam);
        return vacuumParam;
    }

    static final /* synthetic */ GripVacuumCapability registerGrippingVacuumCapability_aroundBody14(GripperCapabilitiesImpl gripperCapabilitiesImpl, double d, double d2, double d3, Pressure.Unit unit, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperCapabilitiesImpl, Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), unit, joinPoint};
        GripperCapabilitiesImpl$AjcClosure13 gripperCapabilitiesImpl$AjcClosure13 = new GripperCapabilitiesImpl$AjcClosure13(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperCapabilitiesImpl$AjcClosure13.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure13.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure13.unlink();
            throw throwable;
        }
        return (GripVacuumCapability)object;
    }

    static final /* synthetic */ MultiGripperCapability registerMultiGripperCapability_aroundBody16(GripperCapabilitiesImpl ajc$this, GripperListProvider gripperListProvider, JoinPoint joinPoint) {
        ajc$this.checkIfRegisteredOutsideScope(MULTI_GRIPPER);
        ajc$this.checkIfMultiGripperAlreadyRegistered(MULTI_GRIPPER);
        List<SelectableGripper> grippers = ajc$this.createGrippers(gripperListProvider);
        HashMap<SelectableGripper, RegisteredCapabilities> capabilityMap = ajc$this.createCapabilityMap(ajc$this.context, grippers);
        ajc$this.context.setGripperSetProvider(new GripperSetProviderImpl(grippers));
        return new MultiGripperCapabilityImpl(grippers, capabilityMap, ajc$this.gripperContributionClass);
    }

    static final /* synthetic */ MultiGripperCapability registerMultiGripperCapability_aroundBody18(GripperCapabilitiesImpl gripperCapabilitiesImpl, GripperListProvider gripperListProvider, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperCapabilitiesImpl, gripperListProvider, joinPoint};
        GripperCapabilitiesImpl$AjcClosure17 gripperCapabilitiesImpl$AjcClosure17 = new GripperCapabilitiesImpl$AjcClosure17(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperCapabilitiesImpl$AjcClosure17.linkStackClosureAndJoinPoint(69648));
            gripperCapabilitiesImpl$AjcClosure17.unlink();
        }
        catch (Throwable throwable) {
            gripperCapabilitiesImpl$AjcClosure17.unlink();
            throw throwable;
        }
        return (MultiGripperCapability)object;
    }

    static final /* synthetic */ HashMap createCapabilityMap_aroundBody20(GripperCapabilitiesImpl ajc$this, GripperContext context, List grippers, JoinPoint joinPoint) {
        HashMap<SelectableGripper, RegisteredCapabilitiesImpl> capabilityMap = new HashMap<SelectableGripper, RegisteredCapabilitiesImpl>();
        for (SelectableGripper gripper : grippers) {
            capabilityMap.put(gripper, new RegisteredCapabilitiesImpl(context.getParamsDefinition(gripper)));
        }
        return capabilityMap;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GripperCapabilitiesImpl.java", GripperCapabilitiesImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerWidthCapability", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "double:double:double:double:com.ur.urcap.api.domain.value.simple.Length$Unit", "minWidth:maxWidth:defaultGripWidth:defaultReleaseWidth:unit", "", "com.ur.urcap.api.contribution.driver.gripper.capability.WidthCapability"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerGrippingForceCapability", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "double:double:double:com.ur.urcap.api.domain.value.simple.Force$Unit", "minForce:maxForce:defaultGripForce:unit", "", "com.ur.urcap.api.contribution.driver.gripper.capability.GripForceCapability"), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerSpeedCapability", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "double:double:double:double:com.ur.urcap.api.domain.value.simple.Speed$Unit", "minSpeed:maxSpeed:defaultGripSpeed:defaultReleaseSpeed:unit", "", "com.ur.urcap.api.contribution.driver.gripper.capability.SpeedCapability"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerGrippingVacuumCapability", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "double:double:double:com.ur.urcap.api.domain.value.simple.Pressure$Unit", "minVacuum:maxVacuum:defaultGripVacuum:unit", "", "com.ur.urcap.api.contribution.driver.gripper.capability.GripVacuumCapability"), 122);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerMultiGripperCapability", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "com.ur.urcap.api.contribution.driver.gripper.capability.multigripper.GripperListProvider", "gripperListProvider", "", "com.ur.urcap.api.contribution.driver.gripper.capability.MultiGripperCapability"), 139);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCapabilityMap", "com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl", "com.ur.polyscope.gripper.internal.gripper.GripperContext:java.util.List", "context:grippers", "", "java.util.HashMap"), 175);
    }
}

