/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.gripper.internal.gripper.GripperSetProvider;
import com.ur.polyscope.gripper.internal.gripper.PropertyChanger;
import com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinition;
import com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinitions;
import com.ur.polyscope.gripper.internal.gripper.params.GripOnlyParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.program.payload.InMemoryPayloadDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadDataModel;
import com.ur.polyscope.gripper.internal.gripper.service.GripperServiceProvider;
import com.ur.polyscope.gripper.internal.gripper.util.Enableable;
import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Provider;

public class GripperContext
implements FeedbackDefinitions {
    public static final String IS_HOLDING = "is_holding";
    public static final String IS_NOT_HOLDING = "is_not_holding";
    public static final String ACTUAL_WIDTH = "actual_width";
    private PayloadDataModel gripPayload = new InMemoryPayloadDataModel();
    private PayloadDataModel releasePayload = new InMemoryPayloadDataModel();
    private static AtomicInteger contributionCounter = new AtomicInteger(0);
    private static ConfirmationDialogCreator confirmationDialogCreator;
    private static Provider<URCapErrorPanel> errorPanelProvider;
    private static Provider<ExceptionHandling> exceptionHandlingProvider;
    private static GripperServiceProvider gripperServiceProvider;
    private final Class contributionClass;
    private final int contributionId;
    private final ParamsDefinition paramsDefinition;
    private final Map<SelectableGripper, ParamsDefinition> multiGripperParamsDefinition = new HashMap<SelectableGripper, ParamsDefinition>();
    private final Set<FeedbackDefinition> feedbackDefinition;
    private GripperSetProvider gripperSetProvider;
    private boolean capabilityRegistrationAllowed;
    private RuntimeException initializationException;

    @Deprecated
    public GripperContext() {
        this.contributionClass = null;
        this.contributionId = GripperContext.nextContributionId();
        this.paramsDefinition = new ParamsDefinition();
        this.feedbackDefinition = new LinkedHashSet<FeedbackDefinition>();
        this.clearGrippers();
    }

    public GripperContext(Class contributionClass) {
        this.contributionClass = contributionClass;
        this.contributionId = GripperContext.nextContributionId();
        this.paramsDefinition = new ParamsDefinition();
        this.feedbackDefinition = new LinkedHashSet<FeedbackDefinition>();
        this.clearGrippers();
    }

    private void clearGrippers() {
        this.gripperSetProvider = new GripperSetProvider(){

            @Override
            public Set<SelectableGripper> getGrippers() {
                return new LinkedHashSet<SelectableGripper>();
            }
        };
    }

    @Inject
    public static void setGripperServiceProvider(GripperServiceProvider gripperServiceProvider) {
        GripperContext.gripperServiceProvider = gripperServiceProvider;
    }

    public GripperDevice getGripperDevice() {
        return gripperServiceProvider.getDevice(this.contributionClass);
    }

    @Inject
    public static void setConfirmationDialogCreator(ConfirmationDialogCreator confirmationDialogCreator) {
        GripperContext.confirmationDialogCreator = confirmationDialogCreator;
    }

    public ConfirmationDialogCreator getConfirmationDialogCreator() {
        return confirmationDialogCreator;
    }

    @Override
    public int getContributionId() {
        return this.contributionId;
    }

    public Class getContributionClass() {
        return this.contributionClass;
    }

    public ParamsDefinition getParamsDefinition() {
        return this.paramsDefinition;
    }

    public ParamsDefinition getParamsDefinition(SelectableGripper gripper) {
        ParamsDefinition pd = this.multiGripperParamsDefinition.get(gripper);
        if (pd == null) {
            pd = new ParamsDefinition(this.paramsDefinition);
            this.multiGripperParamsDefinition.put(gripper, pd);
        }
        return pd;
    }

    public Set<SelectableGripper> getGrippers() {
        return this.gripperSetProvider.getGrippers();
    }

    public void setGripperSetProvider(GripperSetProvider gripperSetProvider) {
        this.gripperSetProvider = gripperSetProvider;
    }

    public PayloadDataModel getGripPayload() {
        return this.gripPayload;
    }

    public PayloadDataModel getReleasePayload() {
        return this.releasePayload;
    }

    private static int nextContributionId() {
        return contributionCounter.incrementAndGet();
    }

    public boolean isCapabilityRegistrationAllowed() {
        return this.capabilityRegistrationAllowed;
    }

    public void setCapabilityRegistrationAllowed(boolean capabilityRegistrationAllowed) {
        this.capabilityRegistrationAllowed = capabilityRegistrationAllowed;
    }

    public void resetParams() {
        this.multiGripperParamsDefinition.clear();
        this.getParamsDefinition().resetParams();
        this.resetFeedbackDefinitions();
        for (SelectableGripper gripper : this.getGrippers()) {
            if (!(gripper instanceof PropertyChanger)) continue;
            ((PropertyChanger)gripper).removeAllListeners();
        }
    }

    public void appendParam(GripOnlyParam param) {
        this.paramsDefinition.append(param);
        if (this.isMultiGripper()) {
            for (SelectableGripper selectableGripper : this.getGrippers()) {
                ParamsDefinition pd = this.multiGripperParamsDefinition.get(selectableGripper);
                if (pd == null) continue;
                pd.append(param);
            }
        }
    }

    public boolean containsParam(String param) {
        return this.paramsDefinition.contains(param);
    }

    public SelectableGripper getGripperById(final String id) {
        Collection grippers = Collections2.filter(this.getGrippers(), (Predicate)new Predicate<SelectableGripper>(){

            public boolean apply(SelectableGripper gripper) {
                return EqualsUtil.equals((Object)id, (Object)gripper.getId());
            }
        });
        if (grippers.isEmpty()) {
            return null;
        }
        return (SelectableGripper)grippers.iterator().next();
    }

    public boolean isMultiGripper() {
        return this.getGrippers().size() > 1;
    }

    public Collection<SelectableGripper> getGrippersEnabled() {
        return Collections2.filter(this.getGrippers(), (Predicate)new Predicate<SelectableGripper>(){

            public boolean apply(SelectableGripper gripper) {
                return GripperContext.this.isGripperEnabled(gripper);
            }
        });
    }

    public boolean isValidGripperSelected(GripperParam gripperParam) {
        if (!this.isMultiGripper()) {
            return true;
        }
        SelectableGripper selectedGripper = gripperParam.getValue();
        if (selectedGripper == null && this.isOnlyOneGripperAvailable()) {
            return true;
        }
        return selectedGripper != null && selectedGripper.getId() != null && this.isGripperEnabled(selectedGripper);
    }

    private boolean isGripperEnabled(SelectableGripper gripper) {
        if (gripper instanceof Enableable) {
            return ((Enableable)gripper).isEnabled();
        }
        return gripper.isResolvable();
    }

    public boolean isOnlyOneGripperAvailable() {
        return this.getGrippersEnabled().size() == 1;
    }

    @Override
    public Set<FeedbackDefinition> getFeedbackDefinitions() {
        return Collections.unmodifiableSet(this.feedbackDefinition);
    }

    public void resetFeedbackDefinitions() {
        this.feedbackDefinition.clear();
    }

    public void appendFeedbackDefinition(FeedbackDefinition def) {
        this.feedbackDefinition.add(def);
    }

    @Override
    public boolean hasFeedbackDefinitions(String functionName) {
        for (FeedbackDefinition fd : this.feedbackDefinition) {
            if (!fd.getFunctionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectedGripperDisabled(GripperParam gripperParam) {
        SelectableGripper selectedGripper = gripperParam.getValue();
        if (selectedGripper != null) {
            return !this.isGripperEnabled(selectedGripper);
        }
        return false;
    }

    public void setInitializationException(RuntimeException e) {
        this.initializationException = e;
    }

    public boolean hasInitializationException() {
        return this.initializationException != null;
    }

    public String getInitializationExceptionStackTrace() {
        if (this.initializationException == null) {
            return "";
        }
        ExceptionHandling exceptionHandling = GripperContext.createExceptionHandling();
        StackTraceElement[] stackTrace = this.initializationException.getStackTrace();
        int stackIndex = GripperContext.findEntryPointIndex(this.initializationException, this.contributionClass);
        return exceptionHandling.getStackTraceOutsidePolyScope((Throwable)this.initializationException, stackTrace[stackIndex]);
    }

    @Inject
    public static void setExceptionHandlingProvider(Provider<ExceptionHandling> provider) {
        exceptionHandlingProvider = provider;
    }

    public static ExceptionHandling createExceptionHandling() {
        return (ExceptionHandling)exceptionHandlingProvider.get();
    }

    @Inject
    public static void setURCapErrorPanelProvider(Provider<URCapErrorPanel> provider) {
        errorPanelProvider = provider;
    }

    public static URCapErrorPanel createErrorPanel() {
        return (URCapErrorPanel)errorPanelProvider.get();
    }

    public static int findEntryPointIndex(Throwable e, Class<? extends GripperContribution> clazz) {
        StackTraceElement[] stack = e.getStackTrace();
        String className = clazz.getName();
        int index = stack.length - 1;
        int i = 0;
        while (i < stack.length) {
            String name = stack[i].getClassName();
            if (name.equals(className)) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

