/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.common;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static Icon getScaledIcon(Icon logo, int desiredWidth, int desiredHeight) {
        double desiredRatio;
        ImageIcon icon = (ImageIcon)logo;
        int height = logo.getIconHeight();
        int width = logo.getIconWidth();
        double ratio = (double)width / (double)height;
        boolean tooWide = ratio > (desiredRatio = (double)desiredWidth / (double)desiredHeight);
        Image scaled = tooWide ? ImageUtil.getFixedWidthImageWithCorrectAspectRatio(desiredWidth, icon) : ImageUtil.getFixedHeightImageWithCorrectAspectRatio(desiredHeight, icon);
        return new ImageIcon(scaled);
    }

    private static Image getFixedHeightImageWithCorrectAspectRatio(int desiredHeight, ImageIcon icon) {
        return icon.getImage().getScaledInstance(-1, desiredHeight, 4);
    }

    private static Image getFixedWidthImageWithCorrectAspectRatio(int desiredWidth, ImageIcon icon) {
        return icon.getImage().getScaledInstance(desiredWidth, -1, 4);
    }
}

