/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.common.widgets;

import com.ur.polyscope.gripper.internal.gripper.common.widgets.DoubleValueConverter;

public class PercentConverter<T> {
    private final T min;
    private final T max;
    private final DoubleValueConverter<T> converter;

    public PercentConverter(T min, T max, DoubleValueConverter<T> converter) {
        this.min = min;
        this.max = max;
        this.converter = converter;
    }

    public int percentOf(T value) {
        double val = this.converter.asDouble(value);
        double minValue = this.converter.asDouble(this.min);
        double maxValue = this.converter.asDouble(this.max);
        if (val < minValue) {
            return 0;
        }
        if (val > maxValue) {
            return 100;
        }
        return (int)Math.floor((val - minValue) / ((maxValue - minValue) / 100.0));
    }

    public T valueOf(int percent) {
        double maxValue;
        double minValue = this.converter.asDouble(this.min);
        double val = minValue + (double)percent * (((maxValue = this.converter.asDouble(this.max)) - minValue) / 100.0);
        if (val > maxValue) {
            val = maxValue;
        }
        if (val < minValue) {
            val = minValue;
        }
        return this.converter.valueOf(val);
    }
}

