/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.common.widgets;

import com.ur.polyscope.gripper.internal.gripper.common.widgets.DoubleValueConverter;
import com.ur.polyscope.gripper.internal.gripper.common.widgets.PercentConverter;
import com.ur.polyscope.valueobjects.NumberValue;
import javax.swing.JSlider;

public class VOSlider<T extends NumberValue<?>>
extends JSlider {
    private final DoubleValueConverter<T> converter;
    private PercentConverter<T> percentConverter;

    public VOSlider(DoubleValueConverter<T> converter) {
        this.converter = converter;
        this.setMinimum(0);
        this.setMaximum(100);
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(1);
        this.setFocusable(false);
    }

    public void setValueObject(T value) {
        if (value == null || this.percentConverter == null) {
            this.setValue(0);
        } else {
            this.setValue(this.percentConverter.percentOf(value));
        }
    }

    public T getValueObject() {
        if (this.isEnabled()) {
            if (this.percentConverter == null) {
                this.converter.valueOf(0.0);
            } else {
                return (T)((NumberValue)this.percentConverter.valueOf(this.getValue()));
            }
        }
        return null;
    }

    public void setValueRange(T minimum, T maximum) {
        this.percentConverter = minimum == null || maximum == null ? null : new PercentConverter<T>(minimum, maximum, this.converter);
    }
}

