/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.device.impl;

import com.ur.polyscope.gripper.internal.gripper.device.impl.GripperDeviceImpl;
import com.ur.polyscope.gripper.internal.gripper.service.GripperServiceProvider;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.domain.ValueParser;
import com.ur.urcap.api.domain.URCapInfo;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import java.util.HashMap;
import javax.inject.Inject;

public class GripperDeviceParser
implements ValueParser<GripperDevice> {
    private static GripperServiceProvider gripperServiceProvider;

    @Inject
    public static void setGripperServiceProvider(GripperServiceProvider gripperServiceProvider) {
        GripperDeviceParser.gripperServiceProvider = gripperServiceProvider;
    }

    public boolean canRead(String nodeName) {
        return "GripperDevice".equals(nodeName);
    }

    public String readKey(PersistReader reader) {
        return reader.getStringAttribute("key");
    }

    public GripperDevice readValue(PersistReader reader) {
        String deviceName = reader.getStringAttribute("name");
        String deviceSymbolicName = reader.getStringAttribute("symbolicName");
        String id = reader.getStringAttribute("id");
        String vendor = reader.getStringAttribute("vendor");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", deviceName);
        map.put("Bundle-SymbolicName", deviceSymbolicName);
        map.put("vendor", vendor);
        URCapInformation urCapInfo = new URCapInformation(map);
        GripperDevice gripperDevice = gripperServiceProvider.getDevice(deviceSymbolicName, id);
        if (gripperDevice == null) {
            gripperDevice = new GripperDeviceImpl((URCapInfo)urCapInfo, deviceName, id, false);
        }
        return gripperDevice;
    }
}

