/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.device.impl;

import com.ur.polyscope.gripper.internal.gripper.capability.impl.ConformantGripperCapabilitiesImpl;
import com.ur.polyscope.gripper.internal.gripper.device.impl.GripperRegistrationConfigurationImpl;
import com.ur.polyscope.gripper.internal.gripper.device.impl.GripperRegistrationManagerImpl$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.device.impl.GripperRegistrationManagerImpl$AjcClosure3;
import com.ur.polyscope.gripper.internal.gripper.program.node.GripperProgramNodeProvider;
import com.ur.polyscope.gripper.internal.gripper.service.GripperServiceProvider;
import com.ur.polyscope.program.ProgramNodeProvider;
import com.ur.polyscope.program.nodes.URCapProgramNodeFactory;
import com.ur.polyscope.urcaps.device.URCapServiceProvider;
import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.polyscope.urcaps.proxy.SwitchableActionProxyCapable;
import com.ur.polyscope.urcaps.proxy.SwitchableProxy;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.contribution.driver.gripper.CalledOutsideGripperConfigurationPhase;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperConfigurable;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperRegistrationConfiguration;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperRegistrationManager;
import com.ur.urcap.api.domain.device.DeviceAlreadyRegistered;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.system.SystemSettings;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.util.CalledOutsideMethodScope;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class GripperRegistrationManagerImpl
implements GripperRegistrationManager,
SwitchableActionProxyCapable {
    private final GripperServiceProvider gripperServiceProvider;
    private final URCapServiceProvider urCapServiceProvider;
    private final GripperProgramNodeProvider gripperProgramNodeProvider;
    private final URCapProgramNodeFactory urCapProgramNodeFactory;
    private final SystemSettings systemSettings;
    private final Class<?> serviceClass;
    private GripperRegistrationConfiguration gripperRegistrationConfiguration;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    GripperRegistrationManagerImpl(GripperServiceProvider gripperServiceProvider, GripperProgramNodeProvider gripperProgramNodeProvider, URCapProgramNodeFactory urCapProgramNodeFactory, URCapServiceProvider urCapServiceProvider, SystemSettings systemSettings, Class<?> serviceClass) {
        this.gripperServiceProvider = gripperServiceProvider;
        this.gripperProgramNodeProvider = gripperProgramNodeProvider;
        this.urCapProgramNodeFactory = urCapProgramNodeFactory;
        this.urCapServiceProvider = urCapServiceProvider;
        this.systemSettings = systemSettings;
        this.serviceClass = serviceClass;
    }

    public <T extends ProgramNodeContribution & GripperConfigurable> GripperRegistrationConfiguration registerAsGripper(@NotNull Class<T> gripperProgramNodeClass) {
        Object object;
        Class<T> clazz = gripperProgramNodeClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, clazz);
        Object[] objectArray = new Object[]{this, clazz, joinPoint};
        GripperRegistrationManagerImpl$AjcClosure3 gripperRegistrationManagerImpl$AjcClosure3 = new GripperRegistrationManagerImpl$AjcClosure3(objectArray);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(gripperRegistrationManagerImpl$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            gripperRegistrationManagerImpl$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            gripperRegistrationManagerImpl$AjcClosure3.unlink();
            throw throwable;
        }
        return (GripperRegistrationConfiguration)object;
    }

    private GripperRegistrationConfiguration createGripperRegistrationConfiguration(GripperDevice gripperDevice) {
        Localization localization = this.systemSettings.getLocalization();
        ConformantGripperCapabilitiesImpl gripperCapabilities = new ConformantGripperCapabilitiesImpl(gripperDevice, localization, this.serviceClass);
        this.gripperRegistrationConfiguration = new GripperRegistrationConfigurationImpl(gripperCapabilities);
        this.gripperRegistrationConfiguration = (GripperRegistrationConfiguration)SwitchableProxy.createForwardingActionProxy((Object)this.gripperRegistrationConfiguration);
        return this.gripperRegistrationConfiguration;
    }

    private <T extends ProgramNodeContribution & GripperConfigurable> void throwIfDeviceAlreadyRegistered(Class<T> gripperProgramNodeClass) {
        URCapProgramNodeService service = this.urCapServiceProvider.getProgramNodeService(this.serviceClass);
        if (service == null) {
            throw new IllegalStateException("service not available");
        }
        Class actualServiceClass = URCapClassResolver.getURCapClass((URCapProgramNodeService)service);
        GripperDevice device = this.gripperServiceProvider.getDevice(actualServiceClass);
        if (device != null) {
            throw new DeviceAlreadyRegistered(String.valueOf(gripperProgramNodeClass.getSimpleName()) + " is already registered as a gripper device: " + device);
        }
    }

    public void switchToAction(Runnable runnable) {
        if (this.gripperRegistrationConfiguration == null) {
            return;
        }
        if (this.isConformantGripper()) {
            SwitchableProxy.switchToAction((Object)this.gripperRegistrationConfiguration, (Runnable)this.createCalledOutsideMethodScopeAction());
        } else {
            SwitchableProxy.switchToAction((Object)this.gripperRegistrationConfiguration, (Runnable)this.createCalledOutsideGripperConfigurationPhaseAction());
        }
    }

    private boolean isConformantGripper() {
        if (this.serviceClass == null) {
            return false;
        }
        return URCapProgramNodeService.class.isAssignableFrom(this.serviceClass);
    }

    private Runnable createCalledOutsideMethodScopeAction() {
        return new Runnable(){

            @Override
            public void run() {
                throw new CalledOutsideMethodScope("Capability registered outside the scope of the configureContribution() method in program node service");
            }
        };
    }

    private Runnable createCalledOutsideGripperConfigurationPhaseAction() {
        return new Runnable(){

            @Override
            public void run() {
                throw new CalledOutsideGripperConfigurationPhase("Gripper capability registration called outside scope of configureContribution method in program node service");
            }
        };
    }

    static {
        GripperRegistrationManagerImpl.ajc$preClinit();
    }

    static final /* synthetic */ GripperRegistrationConfiguration registerAsGripper_aroundBody0(GripperRegistrationManagerImpl ajc$this, Class gripperProgramNodeClass, JoinPoint joinPoint) {
        URCapProgramNodeService service = ajc$this.urCapServiceProvider.getProgramNodeService(ajc$this.serviceClass);
        if (service == null) {
            throw new IllegalStateException("service not available");
        }
        ajc$this.throwIfDeviceAlreadyRegistered(gripperProgramNodeClass);
        GripperDevice gripperDevice = ajc$this.gripperServiceProvider.add(service);
        ajc$this.urCapProgramNodeFactory.addProgramNodeProvider((ProgramNodeProvider)ajc$this.gripperProgramNodeProvider, ajc$this.serviceClass);
        return ajc$this.createGripperRegistrationConfiguration(gripperDevice);
    }

    static final /* synthetic */ GripperRegistrationConfiguration registerAsGripper_aroundBody2(GripperRegistrationManagerImpl gripperRegistrationManagerImpl, Class clazz, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{gripperRegistrationManagerImpl, clazz, joinPoint};
        GripperRegistrationManagerImpl$AjcClosure1 gripperRegistrationManagerImpl$AjcClosure1 = new GripperRegistrationManagerImpl$AjcClosure1(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(gripperRegistrationManagerImpl$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            gripperRegistrationManagerImpl$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            gripperRegistrationManagerImpl$AjcClosure1.unlink();
            throw throwable;
        }
        return (GripperRegistrationConfiguration)object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GripperRegistrationManagerImpl.java", GripperRegistrationManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerAsGripper", "com.ur.polyscope.gripper.internal.gripper.device.impl.GripperRegistrationManagerImpl", "java.lang.Class", "gripperProgramNodeClass", "", "com.ur.urcap.api.contribution.driver.gripper.conformant.GripperRegistrationConfiguration"), 50);
    }
}

