/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.feedback;

import com.ur.lang.StringUtils;
import com.ur.polyscope.gripper.internal.gripper.feedback.MultiGripperParameter;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.driver.general.script.ScriptCodeGenerator;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.script.ScriptWriter;

public class FeedbackDefinition<T> {
    private final String functionName;
    private final ScriptCodeGenerator<T> generator;
    private final T parameter;

    public FeedbackDefinition(String functionName, ScriptCodeGenerator<T> generator, T parameter) {
        this.functionName = functionName;
        this.generator = generator;
        this.parameter = parameter;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionName(String gripperContributionUniqueId, String individualMultiGripperUniqueId) {
        return String.valueOf(this.functionName) + "_" + gripperContributionUniqueId + this.suffix(individualMultiGripperUniqueId);
    }

    private String suffix(String individualMultiGripperUniqueId) {
        return StringUtils.isNullOrEmpty((String)individualMultiGripperUniqueId) ? "" : "_" + individualMultiGripperUniqueId;
    }

    public void generatePreambleFunction(ScriptWriter writer, String gripperContributionUniqueId, String individualMultiGripperUniqueId, SelectableGripper gripper) {
        writer.appendLine("# This is an internal function. Do not call it!");
        writer.defineFunction(this.getFunctionName(gripperContributionUniqueId, individualMultiGripperUniqueId));
        if (this.parameter instanceof MultiGripperParameter) {
            ((MultiGripperParameter)this.parameter).setSelectableGripper(gripper);
        }
        try {
            this.generator.generateScript(writer, this.parameter);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.generator.getClass(), "com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinition", "generatePreambleFunction");
        }
        writer.end();
    }

    public void generateCallFunction(ScriptWriter writer, String gripperUniqueId, String individualMultiGripperUniqueId) {
        writer.appendRaw(String.valueOf(this.getFunctionName(gripperUniqueId, individualMultiGripperUniqueId)) + "()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedbackDefinition that = (FeedbackDefinition)o;
        return this.functionName != null ? this.functionName.equals(that.functionName) : that.functionName == null;
    }

    public int hashCode() {
        return this.functionName != null ? this.functionName.hashCode() : 0;
    }
}

