/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.installation;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.IdentifiableGripper;
import com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinition;
import com.ur.polyscope.gripper.internal.gripper.util.Enableable;
import com.ur.polyscope.installation.urcap.proxy.PreambleGeneratorService;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.Set;

public class FeedbackPreambleGenerator
implements PreambleGeneratorService {
    private final GripperContext gripperContext;

    public FeedbackPreambleGenerator(GripperContext gripperContext) {
        this.gripperContext = gripperContext;
    }

    public void generatePreamble(ScriptWriter writer) {
        int contributionId = this.gripperContext.getContributionId();
        if (this.gripperContext.isMultiGripper()) {
            this.generateMultiGripperPreamble(writer, contributionId);
        } else {
            this.generateGripperPreamble(writer, contributionId);
        }
    }

    private void generateGripperPreamble(ScriptWriter writer, int contributionUniqueId) {
        Set<FeedbackDefinition> feedbackDefinitions = this.gripperContext.getFeedbackDefinitions();
        for (FeedbackDefinition feedback : feedbackDefinitions) {
            feedback.generatePreambleFunction(writer, String.valueOf(contributionUniqueId), "", null);
        }
    }

    private void generateMultiGripperPreamble(ScriptWriter writer, int contributionUniqueId) {
        Set<SelectableGripper> grippers = this.gripperContext.getGrippers();
        Set<FeedbackDefinition> feedbackDefinitions = this.gripperContext.getFeedbackDefinitions();
        for (SelectableGripper gripper : grippers) {
            if (!this.isGripperEnabled(gripper) || !(gripper instanceof IdentifiableGripper)) continue;
            for (FeedbackDefinition feedback : feedbackDefinitions) {
                feedback.generatePreambleFunction(writer, String.valueOf(contributionUniqueId), ((IdentifiableGripper)gripper).getUniqueId(), gripper);
            }
        }
    }

    private boolean isGripperEnabled(SelectableGripper gripper) {
        if (gripper instanceof Enableable) {
            return ((Enableable)gripper).isEnabled();
        }
        return gripper.isResolvable();
    }
}

